/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import spoon.support.visitor.java.reflect.RtMethod;

public class RtParameter {
    private final String name;
    private final Class<?> type;
    private final RtMethod method;
    private final Constructor constructor;
    private final int index;

    public RtParameter(String name, Class<?> type, RtMethod method, Constructor constructor, int index) {
        this.name = name;
        this.type = type;
        this.method = method;
        this.constructor = constructor;
        this.index = index;
    }

    public String getName() {
        if (this.name == null || this.name.equals("")) {
            return "arg" + this.index;
        }
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Annotation[] getDeclaredAnnotations() {
        if (this.method == null) {
            return this.constructor.getParameterAnnotations()[this.index];
        }
        return this.method.getParameterAnnotations()[this.index];
    }

    public boolean isVarArgs() {
        if (this.method == null) {
            return this.constructor.isVarArgs() && this.index == this.constructor.getParameterTypes().length - 1;
        }
        return this.method.isVarArgs() && this.index == this.method.getParameterTypes().length - 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RtParameter) {
            RtParameter other = (RtParameter)obj;
            if (this.method == null) {
                return other.constructor.equals(this.constructor) && other.index == this.index;
            }
            return other.method.equals(this.method) && other.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        if (this.method == null) {
            return this.constructor.hashCode() ^ this.index;
        }
        return this.method.hashCode() ^ this.index;
    }

    public static RtParameter[] parametersOf(RtMethod method) {
        RtParameter[] parameters = new RtParameter[method.getParameterTypes().length];
        for (int index = 0; index < method.getParameterTypes().length; ++index) {
            parameters[index] = new RtParameter(null, method.getParameterTypes()[index], method, null, index);
        }
        return parameters;
    }

    public static RtParameter[] parametersOf(Constructor constructor) {
        RtParameter[] parameters = new RtParameter[constructor.getParameterTypes().length];
        for (int index = 0; index < constructor.getParameterTypes().length; ++index) {
            parameters[index] = new RtParameter(null, constructor.getParameterTypes()[index], null, constructor, index);
        }
        return parameters;
    }
}

