/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import spoon.support.visitor.java.JavaReflectionVisitor;
import spoon.support.visitor.java.reflect.RtMethod;
import spoon.support.visitor.java.reflect.RtParameter;

class JavaReflectionVisitorImpl
implements JavaReflectionVisitor {
    JavaReflectionVisitorImpl() {
    }

    @Override
    public void visitPackage(Package aPackage) {
    }

    @Override
    public <T> void visitClass(Class<T> clazz) {
        if (clazz.getPackage() != null) {
            clazz.getPackage();
        }
        if (clazz.getSuperclass() != null) {
            this.visitClassReference(clazz.getSuperclass());
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            this.visitInterfaceReference(anInterface);
        }
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            this.visitConstructor(constructor);
        }
        for (RtMethod method : this.getDeclaredMethods(clazz)) {
            this.visitMethod(method);
        }
        for (Field field : clazz.getDeclaredFields()) {
            this.visitField(field);
        }
        for (Class<?> aClass : clazz.getDeclaredClasses()) {
            this.visitClass(aClass);
        }
        for (TypeVariable<Class<T>> generic : clazz.getTypeParameters()) {
            this.visitTypeParameter(generic);
        }
    }

    @Override
    public <T> void visitInterface(Class<T> clazz) {
        assert (clazz.isInterface());
        if (clazz.getPackage() != null) {
            clazz.getPackage();
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            this.visitInterfaceReference(anInterface);
        }
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        for (RtMethod method : this.getDeclaredMethods(clazz)) {
            this.visitMethod(method);
        }
        for (Field field : clazz.getDeclaredFields()) {
            this.visitField(field);
        }
        for (Class<?> aClass : clazz.getDeclaredClasses()) {
            this.visitClass(aClass);
        }
        for (TypeVariable<Class<T>> generic : clazz.getTypeParameters()) {
            this.visitTypeParameter(generic);
        }
    }

    @Override
    public <T> void visitEnum(Class<T> clazz) {
        assert (clazz.isEnum());
        if (clazz.getPackage() != null) {
            clazz.getPackage();
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            this.visitInterfaceReference(anInterface);
        }
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            this.visitConstructor(constructor);
        }
        for (RtMethod method : this.getDeclaredMethods(clazz)) {
            if ("valueOf".equals(method.getName()) && method.getParameterTypes().length == 1 && String.class.equals(method.getParameterTypes()[0]) || "values".equals(method.getName())) continue;
            this.visitMethod(method);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if ("$VALUES".equals(field.getName())) continue;
            if (field.isEnumConstant()) {
                this.visitEnumValue(field);
                continue;
            }
            this.visitField(field);
        }
        for (Class<?> aClass : clazz.getDeclaredClasses()) {
            this.visitClass(aClass);
        }
    }

    @Override
    public <T extends Annotation> void visitAnnotationClass(Class<T> clazz) {
        assert (clazz.isAnnotation());
        if (clazz.getPackage() != null) {
            clazz.getPackage();
        }
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        for (RtMethod method : this.getDeclaredMethods(clazz)) {
            this.visitMethod(method);
        }
        for (Field field : clazz.getDeclaredFields()) {
            this.visitField(field);
        }
        for (Class<?> aClass : clazz.getDeclaredClasses()) {
            this.visitClass(aClass);
        }
    }

    @Override
    public void visitAnnotation(Annotation annotation) {
        if (annotation.annotationType() != null) {
            this.visitClassReference(annotation.annotationType());
        }
    }

    @Override
    public <T> void visitConstructor(Constructor<T> constructor) {
        for (Annotation annotation : constructor.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        for (RtParameter parameter : RtParameter.parametersOf(constructor)) {
            this.visitParameter(parameter);
        }
        for (TypeVariable<Constructor<T>> aTypeParameter : constructor.getTypeParameters()) {
            this.visitTypeParameter(aTypeParameter);
        }
    }

    @Override
    public void visitMethod(RtMethod method) {
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        for (RtParameter parameter : RtParameter.parametersOf(method)) {
            this.visitParameter(parameter);
        }
        for (TypeVariable<Method> aTypeParameter : method.getTypeParameters()) {
            this.visitTypeParameter(aTypeParameter);
        }
        if (method.getReturnType() != null) {
            if (method.getReturnType().isArray() && method.getReturnType().getComponentType() != null) {
                this.visitArrayReference(method.getReturnType().getComponentType());
            } else {
                this.visitClassReference(method.getReturnType());
            }
        }
    }

    @Override
    public void visitField(Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        if (field.getType() != null) {
            if (field.getType().isArray() && field.getType().getComponentType() != null) {
                this.visitArrayReference(field.getType().getComponentType());
            } else {
                this.visitClassReference(field.getType());
            }
        }
    }

    @Override
    public void visitEnumValue(Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        if (field.getType() != null) {
            this.visitClassReference(field.getType());
        }
    }

    @Override
    public void visitParameter(RtParameter parameter) {
        for (Annotation annotation : parameter.getDeclaredAnnotations()) {
            this.visitAnnotation(annotation);
        }
        if (parameter.getType() != null) {
            if ((parameter.isVarArgs() || parameter.getType().isArray()) && parameter.getType().getComponentType() != null) {
                this.visitArrayReference(parameter.getType().getComponentType());
            } else {
                this.visitClassReference(parameter.getType());
            }
        }
    }

    @Override
    public <T extends GenericDeclaration> void visitTypeParameter(TypeVariable<T> parameter) {
        for (Type type : parameter.getBounds()) {
            if (type instanceof ParameterizedType) {
                this.visitType((ParameterizedType)type);
                continue;
            }
            if (type instanceof WildcardType) {
                this.visitType((WildcardType)type);
                continue;
            }
            this.visitType(type);
        }
    }

    @Override
    public void visitType(Type type) {
    }

    @Override
    public void visitType(ParameterizedType type) {
        if (type.getRawType() != null) {
            this.visitClassReference((Class)type.getRawType());
        }
        for (Type actualType : type.getActualTypeArguments()) {
            if (actualType instanceof ParameterizedType) {
                this.visitType((ParameterizedType)actualType);
                continue;
            }
            if (actualType instanceof WildcardType) {
                this.visitType((WildcardType)actualType);
                continue;
            }
            this.visitType(actualType);
        }
    }

    @Override
    public void visitType(WildcardType type) {
        if (!type.getUpperBounds()[0].equals(Object.class)) {
            for (Type upper : type.getUpperBounds()) {
                if (upper instanceof ParameterizedType) {
                    this.visitType((ParameterizedType)upper);
                    continue;
                }
                if (upper instanceof WildcardType) {
                    this.visitType((WildcardType)upper);
                    continue;
                }
                this.visitType(upper);
            }
        }
        for (Type lower : type.getLowerBounds()) {
            if (lower instanceof ParameterizedType) {
                this.visitType((ParameterizedType)lower);
                continue;
            }
            if (lower instanceof WildcardType) {
                this.visitType((WildcardType)lower);
                continue;
            }
            this.visitType(lower);
        }
    }

    @Override
    public <T> void visitArrayReference(Class<T> typeArray) {
        if (typeArray.isArray() && typeArray.getComponentType() != null) {
            this.visitArrayReference(typeArray.getComponentType());
        } else {
            this.visitClassReference(typeArray);
        }
    }

    @Override
    public <T> void visitClassReference(Class<T> clazz) {
        if (clazz.getPackage() != null && clazz.getEnclosingClass() == null) {
            this.visitPackage(clazz.getPackage());
        }
        if (clazz.getEnclosingClass() != null) {
            this.visitClassReference(clazz.getEnclosingClass());
        }
    }

    @Override
    public <T> void visitInterfaceReference(Class<T> type) {
        if (type.getPackage() != null) {
            this.visitPackage(type.getPackage());
        }
        if (type.getEnclosingClass() != null) {
            this.visitClassReference(type.getEnclosingClass());
        }
    }

    private <T> List<RtMethod> getDeclaredMethods(Class<T> clazz) {
        ArrayList<RtMethod> methods = new ArrayList<RtMethod>();
        methods.addAll(Arrays.asList(RtMethod.methodsOf(clazz)));
        Class<T> superclass = clazz.getSuperclass();
        if (superclass != null) {
            methods.removeAll(Arrays.asList(RtMethod.sameMethodsWithDifferentTypeOf(superclass, methods)));
        }
        return methods;
    }
}

