/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.Deque;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.support.visitor.java.JavaReflectionVisitorImpl;
import spoon.support.visitor.java.internal.AnnotationRuntimeBuilderContext;
import spoon.support.visitor.java.internal.ExecutableRuntimeBuilderContext;
import spoon.support.visitor.java.internal.PackageRuntimeBuilderContext;
import spoon.support.visitor.java.internal.RuntimeBuilderContext;
import spoon.support.visitor.java.internal.TypeReferenceRuntimeBuilderContext;
import spoon.support.visitor.java.internal.TypeRuntimeBuilderContext;
import spoon.support.visitor.java.internal.VariableRuntimeBuilderContext;
import spoon.support.visitor.java.reflect.RtMethod;
import spoon.support.visitor.java.reflect.RtParameter;

public class JavaReflectionTreeBuilder
extends JavaReflectionVisitorImpl {
    private Deque<RuntimeBuilderContext> contexts = new ArrayDeque<RuntimeBuilderContext>();
    private Factory factory;

    public JavaReflectionTreeBuilder(Factory factory) {
        this.factory = factory;
    }

    private void enter(RuntimeBuilderContext context) {
        this.contexts.push(context);
    }

    private RuntimeBuilderContext exit() {
        return this.contexts.pop();
    }

    public <T, R extends CtType<T>> R scan(Class<T> clazz) {
        if (clazz.getEnclosingClass() != null) {
            R ctEnclosingClass = this.scan(clazz.getEnclosingClass());
            return (R)ctEnclosingClass.getNestedType(clazz.getSimpleName());
        }
        CtPackage ctPackage = clazz.getPackage() == null ? this.factory.Package().getRootPackage() : this.factory.Package().getOrCreate(clazz.getPackage().getName());
        if (this.contexts.isEmpty()) {
            this.enter(new PackageRuntimeBuilderContext(ctPackage));
        }
        if (clazz.isAnnotation()) {
            this.visitAnnotationClass(clazz);
        } else if (clazz.isInterface()) {
            this.visitInterface(clazz);
        } else if (clazz.isEnum()) {
            this.visitEnum(clazz);
        } else {
            this.visitClass(clazz);
        }
        this.exit();
        Object type = ctPackage.getType(clazz.getSimpleName());
        if (clazz.isPrimitive() && type.getParent() instanceof CtPackage) {
            type.setParent(null);
        }
        return (R)type;
    }

    @Override
    public void visitPackage(Package aPackage) {
        CtPackage ctPackage = this.factory.Package().getOrCreate(aPackage.getName());
        this.enter(new PackageRuntimeBuilderContext(ctPackage));
        super.visitPackage(aPackage);
        this.exit();
        this.contexts.peek().addPackage(ctPackage);
    }

    @Override
    public <T> void visitClass(Class<T> clazz) {
        final CtClass ctClass = this.factory.Core().createClass();
        ctClass.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctClass, clazz.getModifiers());
        this.enter(new TypeRuntimeBuilderContext(ctClass){

            @Override
            public void addConstructor(CtConstructor<?> ctConstructor) {
                ctClass.addConstructor(ctConstructor);
            }

            @Override
            public void addClassReference(CtTypeReference<?> typeReference) {
                ctClass.setSuperclass(typeReference);
            }
        });
        super.visitClass(clazz);
        this.exit();
        this.contexts.peek().addType(ctClass);
    }

    @Override
    public <T> void visitInterface(Class<T> clazz) {
        CtInterface ctInterface = this.factory.Core().createInterface();
        ctInterface.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctInterface, clazz.getModifiers());
        this.enter(new TypeRuntimeBuilderContext(ctInterface){

            public void addMethod(CtMethod ctMethod) {
                super.addMethod(ctMethod);
                ctMethod.setBody(null);
            }
        });
        super.visitInterface(clazz);
        this.exit();
        this.contexts.peek().addType(ctInterface);
    }

    @Override
    public <T> void visitEnum(Class<T> clazz) {
        final CtEnum ctEnum = this.factory.Core().createEnum();
        ctEnum.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctEnum, clazz.getModifiers());
        this.enter(new TypeRuntimeBuilderContext(ctEnum){

            @Override
            public void addConstructor(CtConstructor<?> ctConstructor) {
                ctEnum.addConstructor(ctConstructor);
            }

            @Override
            public void addEnumValue(CtEnumValue<?> ctEnumValue) {
                ctEnum.addEnumValue(ctEnumValue);
            }
        });
        super.visitEnum(clazz);
        this.exit();
        this.contexts.peek().addType(ctEnum);
    }

    @Override
    public <T extends Annotation> void visitAnnotationClass(Class<T> clazz) {
        final CtAnnotationType ctAnnotationType = this.factory.Core().createAnnotationType();
        ctAnnotationType.setSimpleName(clazz.getSimpleName());
        this.setModifier(ctAnnotationType, clazz.getModifiers());
        this.enter(new TypeRuntimeBuilderContext(ctAnnotationType){

            public void addMethod(CtMethod ctMethod) {
                CtField field = JavaReflectionTreeBuilder.this.factory.Core().createField();
                field.setSimpleName(ctMethod.getSimpleName());
                field.setModifiers(ctMethod.getModifiers());
                field.setType(ctMethod.getType());
                ctAnnotationType.addField(field);
            }
        });
        super.visitAnnotationClass(clazz);
        this.exit();
        this.contexts.peek().addType(ctAnnotationType);
    }

    @Override
    public void visitAnnotation(Annotation annotation) {
        CtAnnotation<Annotation> ctAnnotation = this.factory.Core().createAnnotation();
        this.enter(new AnnotationRuntimeBuilderContext(ctAnnotation));
        super.visitAnnotation(annotation);
        this.exit();
        this.contexts.peek().addAnnotation(ctAnnotation);
    }

    @Override
    public <T> void visitConstructor(Constructor<T> constructor) {
        CtConstructor ctConstructor = this.factory.Core().createConstructor();
        ctConstructor.setBody(this.factory.Core().createBlock());
        this.setModifier(ctConstructor, constructor.getModifiers());
        this.enter(new ExecutableRuntimeBuilderContext(ctConstructor));
        super.visitConstructor(constructor);
        this.exit();
        this.contexts.peek().addConstructor(ctConstructor);
    }

    @Override
    public void visitMethod(RtMethod method) {
        CtMethod ctMethod = this.factory.Core().createMethod();
        ctMethod.setSimpleName(method.getName());
        ctMethod.setBody(this.factory.Core().createBlock());
        this.setModifier(ctMethod, method.getModifiers());
        ctMethod.setDefaultMethod(method.isDefault());
        this.enter(new ExecutableRuntimeBuilderContext(ctMethod));
        super.visitMethod(method);
        this.exit();
        this.contexts.peek().addMethod(ctMethod);
    }

    @Override
    public void visitField(Field field) {
        CtField ctField = this.factory.Core().createField();
        ctField.setSimpleName(field.getName());
        this.setModifier(ctField, field.getModifiers());
        this.enter(new VariableRuntimeBuilderContext(ctField));
        super.visitField(field);
        this.exit();
        this.contexts.peek().addField(ctField);
    }

    @Override
    public void visitEnumValue(Field field) {
        CtEnumValue ctEnumValue = this.factory.Core().createEnumValue();
        ctEnumValue.setSimpleName(field.getName());
        this.enter(new VariableRuntimeBuilderContext(ctEnumValue));
        super.visitEnumValue(field);
        this.exit();
        this.contexts.peek().addEnumValue(ctEnumValue);
    }

    @Override
    public void visitParameter(RtParameter parameter) {
        CtParameter ctParameter = this.factory.Core().createParameter();
        ctParameter.setSimpleName(parameter.getName());
        ctParameter.setVarArgs(parameter.isVarArgs());
        this.enter(new VariableRuntimeBuilderContext(ctParameter));
        super.visitParameter(parameter);
        this.exit();
        this.contexts.peek().addParameter(ctParameter);
    }

    @Override
    public <T extends GenericDeclaration> void visitTypeParameter(TypeVariable<T> parameter) {
        CtTypeParameter typeParameter = this.factory.Core().createTypeParameter();
        typeParameter.setSimpleName(parameter.getName());
        this.enter(new TypeRuntimeBuilderContext(typeParameter));
        super.visitTypeParameter(parameter);
        this.exit();
        this.contexts.peek().addFormalType(typeParameter);
    }

    @Override
    public void visitType(Type type) {
        CtTypeReference ctTypeReference = this.factory.Core().createTypeReference();
        ctTypeReference.setSimpleName(this.getTypeName(type));
        this.enter(new TypeReferenceRuntimeBuilderContext(ctTypeReference));
        super.visitType(type);
        this.exit();
        this.contexts.peek().addTypeName(ctTypeReference);
    }

    @Override
    public void visitType(ParameterizedType type) {
        final CtTypeReference ctTypeReference = this.factory.Core().createTypeReference();
        this.enter(new TypeReferenceRuntimeBuilderContext(ctTypeReference){

            @Override
            public void addClassReference(CtTypeReference<?> typeReference) {
                ctTypeReference.setSimpleName(typeReference.getSimpleName());
                ctTypeReference.setPackage(typeReference.getPackage());
                ctTypeReference.setDeclaringType(typeReference.getDeclaringType());
                ctTypeReference.setActualTypeArguments(typeReference.getActualTypeArguments());
                ctTypeReference.setAnnotations(typeReference.getAnnotations());
            }

            @Override
            public void addType(CtType<?> aType) {
            }
        });
        super.visitType(type);
        this.exit();
        this.contexts.peek().addTypeName(ctTypeReference);
    }

    @Override
    public void visitType(WildcardType type) {
        CtWildcardReference wildcard = this.factory.Core().createWildcardReference();
        wildcard.setUpper(type.getUpperBounds() != null && !type.getUpperBounds()[0].equals(Object.class));
        this.enter(new TypeReferenceRuntimeBuilderContext(wildcard));
        super.visitType(type);
        this.exit();
        this.contexts.peek().addTypeName(wildcard);
    }

    private String getTypeName(Type type) {
        if (!(type instanceof Class)) {
            return type.toString();
        }
        Class<?> clazz = (Class<?>)type;
        if (clazz.isArray()) {
            try {
                Class<?> cl = clazz;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }

    @Override
    public <T> void visitArrayReference(final Class<T> typeArray) {
        final CtArrayTypeReference arrayTypeReference = this.factory.Core().createArrayTypeReference();
        this.enter(new TypeReferenceRuntimeBuilderContext(arrayTypeReference){

            @Override
            public void addClassReference(CtTypeReference<?> typeReference) {
                if (typeArray.getSimpleName().equals(typeReference.getSimpleName())) {
                    arrayTypeReference.setComponentType(typeReference);
                } else {
                    arrayTypeReference.setDeclaringType(typeReference);
                }
            }

            @Override
            public void addArrayReference(CtArrayTypeReference<?> typeReference) {
                arrayTypeReference.setComponentType(typeReference);
            }
        });
        super.visitArrayReference(typeArray);
        this.exit();
        this.contexts.peek().addArrayReference(arrayTypeReference);
    }

    @Override
    public <T> void visitClassReference(Class<T> clazz) {
        CtTypeReference typeReference = this.factory.Core().createTypeReference();
        typeReference.setSimpleName(clazz.getSimpleName());
        this.enter(new TypeReferenceRuntimeBuilderContext(typeReference));
        super.visitClassReference(clazz);
        this.exit();
        this.contexts.peek().addClassReference(typeReference);
    }

    @Override
    public <T> void visitInterfaceReference(Class<T> anInterface) {
        CtTypeReference typeReference = this.factory.Core().createTypeReference();
        typeReference.setSimpleName(anInterface.getSimpleName());
        this.enter(new TypeReferenceRuntimeBuilderContext(typeReference));
        super.visitInterfaceReference(anInterface);
        this.exit();
        this.contexts.peek().addInterfaceReference(typeReference);
    }

    private void setModifier(CtModifiable ctModifiable, int modifiers) {
        if (Modifier.isAbstract(modifiers)) {
            ctModifiable.addModifier(ModifierKind.ABSTRACT);
        }
        if (Modifier.isFinal(modifiers)) {
            ctModifiable.addModifier(ModifierKind.FINAL);
        }
        if (Modifier.isNative(modifiers)) {
            ctModifiable.addModifier(ModifierKind.NATIVE);
        }
        if (Modifier.isPrivate(modifiers)) {
            ctModifiable.addModifier(ModifierKind.PRIVATE);
        }
        if (Modifier.isProtected(modifiers)) {
            ctModifiable.addModifier(ModifierKind.PROTECTED);
        }
        if (Modifier.isPublic(modifiers)) {
            ctModifiable.addModifier(ModifierKind.PUBLIC);
        }
        if (Modifier.isStatic(modifiers)) {
            ctModifiable.addModifier(ModifierKind.STATIC);
        }
        if (Modifier.isStrict(modifiers)) {
            ctModifiable.addModifier(ModifierKind.STRICTFP);
        }
        if (Modifier.isSynchronized(modifiers)) {
            ctModifiable.addModifier(ModifierKind.SYNCHRONIZED);
        }
        if (Modifier.isTransient(modifiers)) {
            ctModifiable.addModifier(ModifierKind.TRANSIENT);
        }
        if (Modifier.isVolatile(modifiers)) {
            ctModifiable.addModifier(ModifierKind.VOLATILE);
        }
    }
}

