/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.equals;

import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.CtInheritanceScanner;

public class EqualsChecker
extends CtInheritanceScanner {
    private CtElement other;
    private boolean isNotEqual;

    public void setOther(CtElement other) {
        this.other = other;
    }

    public boolean isNotEqual() {
        return this.isNotEqual;
    }

    @Override
    public void scanCtNamedElement(CtNamedElement e) {
        CtNamedElement peek = (CtNamedElement)this.other;
        if (!e.getSimpleName().equals(peek.getSimpleName())) {
            this.isNotEqual = true;
            return;
        }
        super.scanCtNamedElement(e);
    }

    @Override
    public void scanCtReference(CtReference reference) {
        CtReference peek = (CtReference)this.other;
        if (!reference.getSimpleName().equals(peek.getSimpleName())) {
            this.isNotEqual = true;
            return;
        }
        super.scanCtReference(reference);
    }

    @Override
    public void scanCtStatement(CtStatement s) {
        CtStatement peek = (CtStatement)this.other;
        String leftLabel = s.getLabel();
        String rightLabel = peek.getLabel();
        if (leftLabel == null && rightLabel == null) {
            super.scanCtStatement(s);
            return;
        }
        if (leftLabel == null || !leftLabel.equals(rightLabel)) {
            this.isNotEqual = true;
            return;
        }
        super.scanCtStatement(s);
    }

    @Override
    public void scanCtModifiable(CtModifiable m) {
        CtModifiable peek = (CtModifiable)this.other;
        if (m.getVisibility() == null) {
            if (peek.getVisibility() != null) {
                this.isNotEqual = true;
                return;
            }
        } else {
            if (peek.getVisibility() == null) {
                this.isNotEqual = true;
                return;
            }
            if (!m.getVisibility().equals((Object)peek.getVisibility())) {
                this.isNotEqual = true;
                return;
            }
        }
        if (m.getModifiers().size() != peek.getModifiers().size()) {
            this.isNotEqual = true;
            return;
        }
        if (!m.getModifiers().containsAll(peek.getModifiers())) {
            this.isNotEqual = true;
            return;
        }
        super.scanCtModifiable(m);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        CtOperatorAssignment peek = (CtOperatorAssignment)this.other;
        if (assignment.getKind() == null) {
            if (peek.getKind() != null) {
                this.isNotEqual = true;
                return;
            }
        } else {
            if (peek.getKind() == null) {
                this.isNotEqual = true;
                return;
            }
            if (!assignment.getKind().equals((Object)peek.getKind())) {
                this.isNotEqual = true;
                return;
            }
        }
        super.visitCtOperatorAssignment(assignment);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> e) {
        CtBinaryOperator peek = (CtBinaryOperator)this.other;
        if (e.getKind() == null) {
            if (peek.getKind() != null) {
                this.isNotEqual = true;
                return;
            }
        } else {
            if (peek.getKind() == null) {
                this.isNotEqual = true;
                return;
            }
            if (!e.getKind().equals((Object)peek.getKind())) {
                this.isNotEqual = true;
                return;
            }
        }
        super.visitCtBinaryOperator(e);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> e) {
        CtUnaryOperator peek = (CtUnaryOperator)this.other;
        if (e.getKind() == null) {
            if (peek.getKind() != null) {
                this.isNotEqual = true;
                return;
            }
        } else {
            if (peek.getKind() == null) {
                this.isNotEqual = true;
                return;
            }
            if (!e.getKind().equals((Object)peek.getKind())) {
                this.isNotEqual = true;
                return;
            }
        }
        super.visitCtUnaryOperator(e);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> e) {
        CtArrayTypeReference peek = (CtArrayTypeReference)this.other;
        if (e.getDimensionCount() != peek.getDimensionCount()) {
            this.isNotEqual = true;
            return;
        }
        super.visitCtArrayTypeReference(e);
    }

    @Override
    public void visitCtBreak(CtBreak e) {
        CtBreak peek = (CtBreak)this.other;
        if (e.getTargetLabel() == null) {
            if (peek.getTargetLabel() != null) {
                this.isNotEqual = true;
                return;
            }
        } else {
            if (peek.getTargetLabel() == null) {
                this.isNotEqual = true;
                return;
            }
            if (!e.getTargetLabel().equals(peek.getTargetLabel())) {
                this.isNotEqual = true;
                return;
            }
        }
        super.visitCtBreak(e);
    }

    @Override
    public void visitCtContinue(CtContinue e) {
        CtContinue peek = (CtContinue)this.other;
        if (e.getTargetLabel() == null) {
            if (peek.getTargetLabel() != null) {
                this.isNotEqual = true;
                return;
            }
        } else {
            if (peek.getTargetLabel() == null) {
                this.isNotEqual = true;
                return;
            }
            if (!e.getTargetLabel().equals(peek.getTargetLabel())) {
                this.isNotEqual = true;
                return;
            }
        }
        super.visitCtContinue(e);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> e) {
        CtExecutableReference peek = (CtExecutableReference)this.other;
        if (e.isConstructor() != peek.isConstructor()) {
            this.isNotEqual = true;
            return;
        }
        super.visitCtExecutableReference(e);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> e) {
        CtMethod peek = (CtMethod)this.other;
        if (e.isDefaultMethod() != peek.isDefaultMethod()) {
            this.isNotEqual = true;
            return;
        }
        super.visitCtMethod(e);
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> e) {
        CtParameter peek = (CtParameter)this.other;
        if (e.isVarArgs() != peek.isVarArgs()) {
            this.isNotEqual = true;
            return;
        }
        super.visitCtParameter(e);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> e) {
        CtLiteral peek = (CtLiteral)this.other;
        if (e.getValue() == null) {
            if (peek.getValue() != null) {
                this.isNotEqual = true;
                return;
            }
        } else {
            if (peek.getValue() == null) {
                this.isNotEqual = true;
                return;
            }
            if (!e.getValue().equals(peek.getValue())) {
                this.isNotEqual = true;
                return;
            }
        }
        super.visitCtLiteral(e);
    }
}

