/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.equals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.support.util.EmptyClearableList;
import spoon.support.util.EmptyClearableSet;
import spoon.support.visitor.clone.CloneVisitor;

public final class CloneHelper {
    public static <T extends CtElement> T clone(T element) {
        CloneVisitor cloneVisitor = new CloneVisitor();
        cloneVisitor.scan(element);
        return cloneVisitor.getClone();
    }

    public static <T extends CtElement> Collection<T> clone(Collection<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<CtElement> others = new ArrayList<CtElement>();
        for (CtElement element : elements) {
            others.add(CloneHelper.clone(element));
        }
        return others;
    }

    public static <T extends CtElement> List<T> clone(List<T> elements) {
        if (elements instanceof EmptyClearableList) {
            return elements;
        }
        if (elements == null || elements.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<CtElement> others = new ArrayList<CtElement>();
        for (CtElement element : elements) {
            others.add(CloneHelper.clone(element));
        }
        return others;
    }

    private static <T extends CtElement> Set<T> createRightSet(Set<T> elements) {
        try {
            if (elements instanceof TreeSet) {
                Set s = (Set)((TreeSet)elements).clone();
                s.clear();
                return s;
            }
            return (Set)elements.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SpoonException(e);
        }
    }

    public static <T extends CtElement> Set<T> clone(Set<T> elements) {
        if (elements instanceof EmptyClearableSet) {
            return elements;
        }
        if (elements == null || elements.isEmpty()) {
            return EmptyClearableSet.instance();
        }
        Set<T> others = CloneHelper.createRightSet(elements);
        for (CtElement element : elements) {
            others.add(CloneHelper.clone(element));
        }
        return others;
    }

    public static <T extends CtElement> Map<String, T> clone(Map<String, T> elements) {
        if (elements == null || elements.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, CtElement> others = new HashMap<String, CtElement>();
        for (Map.Entry<String, T> tEntry : elements.entrySet()) {
            others.put(tEntry.getKey(), CloneHelper.clone((CtElement)tEntry.getValue()));
        }
        return others;
    }

    private CloneHelper() {
        throw new AssertionError((Object)"No instance.");
    }
}

