/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.Set;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;
import spoon.support.util.QualifiedNameBasedSortedSet;

public class CtPackageImpl
extends CtNamedElementImpl
implements CtPackage {
    private static final long serialVersionUID = 1L;
    protected Set<CtPackage> packs = this.orderedPackageSet();
    private Set<CtType<?>> types = this.orderedTypeSet();
    boolean isShadow;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtPackage(this);
    }

    @Override
    public <T extends CtPackage> T addPackage(CtPackage pack) {
        if (pack == null) {
            return (T)this;
        }
        if (this.packs == CtElementImpl.emptySet()) {
            this.packs = this.orderedPackageSet();
        }
        if (this.getQualifiedName().equals(pack.getQualifiedName())) {
            this.addAllTypes(pack, this);
            this.addAllPackages(pack, this);
            return (T)this;
        }
        for (CtPackage p1 : this.packs) {
            if (!p1.getQualifiedName().equals(pack.getQualifiedName())) continue;
            this.addAllTypes(pack, p1);
            this.addAllPackages(pack, p1);
            return (T)this;
        }
        pack.setParent(this);
        this.packs.add(pack);
        return (T)this;
    }

    private Set<CtPackage> orderedPackageSet() {
        return new QualifiedNameBasedSortedSet<CtPackage>();
    }

    private Set<CtType<?>> orderedTypeSet() {
        return new QualifiedNameBasedSortedSet();
    }

    private void addAllTypes(CtPackage from, CtPackage to) {
        for (CtType<?> t : from.getTypes()) {
            for (CtType<?> t2 : to.getTypes()) {
                if (!t2.getQualifiedName().equals(t.getQualifiedName()) || t2.equals(t)) continue;
                throw new IllegalStateException("types with same qualified names and different code cannot be merged");
            }
            to.addType(t);
        }
    }

    private void addAllPackages(CtPackage from, CtPackage to) {
        for (CtPackage p : from.getPackages()) {
            to.addPackage(p);
        }
    }

    @Override
    public boolean removePackage(CtPackage pack) {
        return this.packs.remove(pack);
    }

    @Override
    public CtPackage getDeclaringPackage() {
        try {
            return this.getParent(CtPackage.class);
        }
        catch (ParentNotInitializedException e) {
            return null;
        }
    }

    @Override
    public CtPackage getPackage(String name) {
        for (CtPackage p : this.packs) {
            if (!p.getSimpleName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Set<CtPackage> getPackages() {
        return this.packs;
    }

    @Override
    public String getQualifiedName() {
        if (this.getDeclaringPackage() == null || this.getDeclaringPackage().isUnnamedPackage()) {
            return this.getSimpleName();
        }
        return this.getDeclaringPackage().getQualifiedName() + "." + this.getSimpleName();
    }

    @Override
    public <T extends CtType<?>> T getType(String simpleName) {
        for (CtType<?> t : this.types) {
            if (!t.getSimpleName().equals(simpleName)) continue;
            return (T)t;
        }
        return null;
    }

    @Override
    public Set<CtType<?>> getTypes() {
        return this.types;
    }

    @Override
    public <T extends CtPackage> T setPackages(Set<CtPackage> packs) {
        if (packs == null || packs.isEmpty()) {
            this.packs = CtElementImpl.emptySet();
            return (T)this;
        }
        this.packs.clear();
        for (CtPackage p : packs) {
            this.addPackage(p);
        }
        return (T)this;
    }

    @Override
    public <T extends CtPackage> T setTypes(Set<CtType<?>> types) {
        if (types == null || types.isEmpty()) {
            this.types = CtElementImpl.emptySet();
            return (T)this;
        }
        this.types.clear();
        for (CtType<?> t : types) {
            this.addType(t);
        }
        return (T)this;
    }

    @Override
    public CtPackageReference getReference() {
        return this.getFactory().Package().createReference(this);
    }

    @Override
    public <T extends CtPackage> T addType(CtType<?> type) {
        if (type == null) {
            return (T)this;
        }
        if (this.types == CtElementImpl.emptySet()) {
            this.types = this.orderedTypeSet();
        }
        type.setParent(this);
        this.types.add(type);
        return (T)this;
    }

    @Override
    public void removeType(CtType<?> type) {
        this.types.remove(type);
    }

    @Override
    public SourcePosition getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtPackage clone() {
        return (CtPackage)super.clone();
    }

    @Override
    public boolean isUnnamedPackage() {
        return "unnamed package".equals(this.getSimpleName());
    }
}

