/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtExecutableImpl;

public class CtMethodImpl<T>
extends CtExecutableImpl<T>
implements CtMethod<T> {
    private static final long serialVersionUID = 1L;
    CtTypeReference<T> returnType;
    boolean defaultMethod = false;
    List<CtTypeParameterReference> formalTypeParameters = CtMethodImpl.emptyList();
    List<CtTypeParameter> formalCtTypeParameters = CtMethodImpl.emptyList();
    Set<ModifierKind> modifiers = CtElementImpl.emptySet();
    boolean isShadow;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtMethod(this);
    }

    @Override
    public CtTypeReference<T> getType() {
        return this.returnType;
    }

    @Override
    public <C extends CtTypedElement> C setType(CtTypeReference<T> type) {
        if (type != null) {
            type.setParent(this);
        }
        this.returnType = type;
        return (C)this;
    }

    @Override
    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    @Override
    public <C extends CtMethod<T>> C setDefaultMethod(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
        return (C)this;
    }

    @Override
    public List<CtTypeParameter> getFormalCtTypeParameters() {
        return this.formalCtTypeParameters;
    }

    public <C extends CtFormalTypeDeclarer> C setFormalCtTypeParameters(List<CtTypeParameter> formalTypeParameters) {
        if (formalTypeParameters == null || formalTypeParameters.isEmpty()) {
            this.formalCtTypeParameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        this.formalCtTypeParameters.clear();
        for (CtTypeParameter formalTypeParameter : formalTypeParameters) {
            this.addFormalCtTypeParameter(formalTypeParameter);
        }
        return (C)this;
    }

    public <C extends CtFormalTypeDeclarer> C addFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        if (formalTypeParameter == null) {
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        formalTypeParameter.setParent(this);
        this.formalCtTypeParameters.add(formalTypeParameter);
        return (C)this;
    }

    @Override
    public boolean removeFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        return this.formalCtTypeParameters.contains(formalTypeParameter) && this.formalCtTypeParameters.remove(formalTypeParameter);
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        if (modifiers.size() > 0) {
            this.modifiers = EnumSet.copyOf(modifiers);
        }
        return (C)this;
    }

    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.modifiers.add(modifier);
        return (C)this;
    }

    @Override
    public boolean removeModifier(ModifierKind modifier) {
        return !this.modifiers.isEmpty() && this.modifiers.remove((Object)modifier);
    }

    public <C extends CtModifiable> C setVisibility(ModifierKind visibility) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.getModifiers().remove((Object)ModifierKind.PUBLIC);
        this.getModifiers().remove((Object)ModifierKind.PROTECTED);
        this.getModifiers().remove((Object)ModifierKind.PRIVATE);
        this.getModifiers().add(visibility);
        return (C)this;
    }

    @Override
    public ModifierKind getVisibility() {
        if (this.getModifiers().contains((Object)ModifierKind.PUBLIC)) {
            return ModifierKind.PUBLIC;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PROTECTED)) {
            return ModifierKind.PROTECTED;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PRIVATE)) {
            return ModifierKind.PRIVATE;
        }
        return null;
    }

    @Override
    public <R extends T> void replace(CtMethod<T> element) {
        this.replace((CtElement)element);
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtMethod<T> clone() {
        return (CtMethod)super.clone();
    }
}

