/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.EnumSet;
import java.util.Set;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtRHSReceiver;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;

public class CtFieldImpl<T>
extends CtNamedElementImpl
implements CtField<T> {
    private static final long serialVersionUID = 1L;
    CtExpression<T> defaultExpression;
    CtTypeReference<T> type;
    Set<ModifierKind> modifiers = CtElementImpl.emptySet();
    boolean isShadow;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtField(this);
    }

    @Override
    public CtType<?> getDeclaringType() {
        return (CtType)this.parent;
    }

    @Override
    public <T> CtType<T> getTopLevelType() {
        return this.getDeclaringType().getTopLevelType();
    }

    @Override
    public CtExpression<T> getDefaultExpression() {
        return this.defaultExpression;
    }

    @Override
    public CtFieldReference<T> getReference() {
        return this.getFactory().Field().createReference(this);
    }

    @Override
    public CtTypeReference<T> getType() {
        return this.type;
    }

    @Override
    public <C extends CtVariable<T>> C setDefaultExpression(CtExpression<T> defaultExpression) {
        if (defaultExpression != null) {
            defaultExpression.setParent(this);
        }
        this.defaultExpression = defaultExpression;
        return (C)this;
    }

    @Override
    public <C extends CtTypedElement> C setType(CtTypeReference<T> type) {
        if (type != null) {
            type.setParent(this);
        }
        this.type = type;
        return (C)this;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        if (modifiers.size() > 0) {
            this.modifiers = EnumSet.copyOf(modifiers);
        }
        return (C)this;
    }

    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.modifiers.add(modifier);
        return (C)this;
    }

    @Override
    public boolean removeModifier(ModifierKind modifier) {
        return !this.modifiers.isEmpty() && this.modifiers.remove((Object)modifier);
    }

    public <C extends CtModifiable> C setVisibility(ModifierKind visibility) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.getModifiers().remove((Object)ModifierKind.PUBLIC);
        this.getModifiers().remove((Object)ModifierKind.PROTECTED);
        this.getModifiers().remove((Object)ModifierKind.PRIVATE);
        this.getModifiers().add(visibility);
        return (C)this;
    }

    @Override
    public ModifierKind getVisibility() {
        if (this.getModifiers().contains((Object)ModifierKind.PUBLIC)) {
            return ModifierKind.PUBLIC;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PROTECTED)) {
            return ModifierKind.PROTECTED;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PRIVATE)) {
            return ModifierKind.PRIVATE;
        }
        return null;
    }

    @Override
    public <R extends T> void replace(CtField<R> element) {
        this.replace((CtElement)element);
    }

    @Override
    public CtExpression<T> getAssignment() {
        return this.getDefaultExpression();
    }

    @Override
    @UnsettableProperty
    public <C extends CtRHSReceiver<T>> C setAssignment(CtExpression<T> assignment) {
        this.setDefaultExpression(assignment);
        return (C)this;
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtField<T> clone() {
        return (CtField)super.clone();
    }
}

