/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;
import spoon.support.util.QualifiedNameBasedSortedSet;
import spoon.support.visitor.SignaturePrinter;

public abstract class CtExecutableImpl<R>
extends CtNamedElementImpl
implements CtExecutable<R> {
    private static final long serialVersionUID = 1L;
    CtBlock<?> body;
    List<CtParameter<?>> parameters = CtExecutableImpl.emptyList();
    Set<CtTypeReference<? extends Throwable>> thrownTypes = CtExecutableImpl.emptySet();

    public CtType<?> getDeclaringType() {
        return (CtType)this.parent;
    }

    public <T> CtType<T> getTopLevelType() {
        return this.getDeclaringType().getTopLevelType();
    }

    @Override
    public CtBlock<R> getBody() {
        return this.body;
    }

    @Override
    public <T extends CtBodyHolder> T setBody(CtStatement statement) {
        if (statement != null) {
            CtBlock<?> body = this.getFactory().Code().getOrCreateCtBlock(statement);
            if (body != null) {
                body.setParent(this);
            }
            this.body = body;
        } else {
            this.body = null;
        }
        return (T)this;
    }

    @Override
    public List<CtParameter<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public <T extends CtExecutable<R>> T setParameters(List<CtParameter<?>> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.parameters = CtElementImpl.emptyList();
            return (T)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        this.parameters.clear();
        for (CtParameter<?> p : parameters) {
            this.addParameter(p);
        }
        return (T)this;
    }

    @Override
    public <T extends CtExecutable<R>> T addParameter(CtParameter<?> parameter) {
        if (parameter == null) {
            return (T)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        parameter.setParent(this);
        this.parameters.add(parameter);
        return (T)this;
    }

    @Override
    public boolean removeParameter(CtParameter<?> parameter) {
        return this.parameters != CtElementImpl.emptyList() && this.parameters.remove(parameter);
    }

    @Override
    public Set<CtTypeReference<? extends Throwable>> getThrownTypes() {
        return this.thrownTypes;
    }

    @Override
    public <T extends CtExecutable<R>> T setThrownTypes(Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        if (thrownTypes == null || thrownTypes.isEmpty()) {
            this.thrownTypes = CtElementImpl.emptySet();
            return (T)this;
        }
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            this.thrownTypes = new QualifiedNameBasedSortedSet<CtTypeReference<? extends Throwable>>();
        }
        this.thrownTypes.clear();
        for (CtTypeReference<? extends Throwable> thrownType : thrownTypes) {
            this.addThrownType(thrownType);
        }
        return (T)this;
    }

    @Override
    public <T extends CtExecutable<R>> T addThrownType(CtTypeReference<? extends Throwable> throwType) {
        if (throwType == null) {
            return (T)this;
        }
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            this.thrownTypes = new QualifiedNameBasedSortedSet<CtTypeReference<? extends Throwable>>();
        }
        throwType.setParent(this);
        this.thrownTypes.add(throwType);
        return (T)this;
    }

    @Override
    public boolean removeThrownType(CtTypeReference<? extends Throwable> throwType) {
        return this.thrownTypes.remove(throwType);
    }

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public CtExecutableReference<R> getReference() {
        return this.getFactory().Executable().createReference(this);
    }

    @Override
    public CtExecutable<R> clone() {
        return (CtExecutable)super.clone();
    }
}

