/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.DerivedProperty;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtExecutableImpl;

public class CtConstructorImpl<T>
extends CtExecutableImpl<T>
implements CtConstructor<T> {
    private static final long serialVersionUID = 1L;
    List<CtTypeParameterReference> formalTypeParameters = CtConstructorImpl.emptyList();
    List<CtTypeParameter> formalCtTypeParameters = CtConstructorImpl.emptyList();
    Set<ModifierKind> modifiers = CtElementImpl.emptySet();
    boolean isShadow;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtConstructor(this);
    }

    @UnsettableProperty
    public <C extends CtNamedElement> C setSimpleName(String simpleName) {
        return (C)this;
    }

    @Override
    public String getSimpleName() {
        return "<init>";
    }

    @Override
    public CtType<T> getDeclaringType() {
        return (CtType)this.parent;
    }

    @Override
    @DerivedProperty
    public CtTypeReference<T> getType() {
        if (this.getDeclaringType() == null) {
            return null;
        }
        return this.getDeclaringType().getReference();
    }

    @Override
    @UnsettableProperty
    public <C extends CtTypedElement> C setType(CtTypeReference<T> type) {
        return (C)this;
    }

    @Override
    public List<CtTypeParameter> getFormalCtTypeParameters() {
        return this.formalCtTypeParameters;
    }

    public <C extends CtFormalTypeDeclarer> C setFormalCtTypeParameters(List<CtTypeParameter> formalTypeParameters) {
        if (formalTypeParameters == null || formalTypeParameters.isEmpty()) {
            this.formalCtTypeParameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        this.formalCtTypeParameters.clear();
        for (CtTypeParameter formalTypeParameter : formalTypeParameters) {
            this.addFormalCtTypeParameter(formalTypeParameter);
        }
        return (C)this;
    }

    public <C extends CtFormalTypeDeclarer> C addFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        if (formalTypeParameter == null) {
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        formalTypeParameter.setParent(this);
        this.formalCtTypeParameters.add(formalTypeParameter);
        return (C)this;
    }

    @Override
    public boolean removeFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        return this.formalCtTypeParameters.contains(formalTypeParameter) && this.formalCtTypeParameters.remove(formalTypeParameter);
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        if (modifiers.size() > 0) {
            this.modifiers = EnumSet.copyOf(modifiers);
        }
        return (C)this;
    }

    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.modifiers.add(modifier);
        return (C)this;
    }

    @Override
    public boolean removeModifier(ModifierKind modifier) {
        return !this.modifiers.isEmpty() && this.modifiers.remove((Object)modifier);
    }

    public <C extends CtModifiable> C setVisibility(ModifierKind visibility) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.getModifiers().remove((Object)ModifierKind.PUBLIC);
        this.getModifiers().remove((Object)ModifierKind.PROTECTED);
        this.getModifiers().remove((Object)ModifierKind.PRIVATE);
        this.getModifiers().add(visibility);
        return (C)this;
    }

    @Override
    public ModifierKind getVisibility() {
        if (this.getModifiers().contains((Object)ModifierKind.PUBLIC)) {
            return ModifierKind.PUBLIC;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PROTECTED)) {
            return ModifierKind.PROTECTED;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PRIVATE)) {
            return ModifierKind.PRIVATE;
        }
        return null;
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtConstructor<T> clone() {
        return (CtConstructor)super.clone();
    }
}

