/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtAnnotatedElementType;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.comparator.CtLineElementComparator;
import spoon.support.reflect.code.CtExpressionImpl;

public class CtAnnotationImpl<A extends Annotation>
extends CtExpressionImpl<A>
implements CtAnnotation<A> {
    private static final long serialVersionUID = 1L;
    CtTypeReference<A> annotationType;
    private Map<String, CtExpression> elementValues = new TreeMap(){

        @Override
        public Set<Map.Entry<String, CtExpression>> entrySet() {
            TreeSet<Map.Entry<String, CtExpression>> result = new TreeSet<Map.Entry<String, CtExpression>>(new Comparator<Map.Entry<String, CtExpression>>(){
                final CtLineElementComparator comp = new CtLineElementComparator();

                @Override
                public int compare(Map.Entry<String, CtExpression> o1, Map.Entry<String, CtExpression> o2) {
                    return this.comp.compare(o1.getValue(), o2.getValue());
                }
            });
            result.addAll(super.entrySet());
            return result;
        }
    };
    boolean isShadow;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtAnnotation(this);
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, Object value) {
        if (value instanceof CtExpression) {
            return this.addValueExpression(elementName, (CtExpression)value);
        }
        return this.addValueExpression(elementName, this.convertValueToExpression(value));
    }

    private CtExpression convertValueToExpression(Object value) {
        CtExpression<Object> res;
        if (value.getClass().isArray()) {
            res = this.getFactory().Core().createNewArray();
            Object[] values = (Object[])value;
            res.setType(this.getFactory().Type().createArrayReference(this.getFactory().Type().createReference(values[0].getClass())));
            for (Object o : values) {
                res.addElement(this.convertValueToExpression(o));
            }
        } else if (value instanceof Collection) {
            res = this.getFactory().Core().createNewArray();
            Collection values = (Collection)value;
            res.setType(this.getFactory().Type().createArrayReference(this.getFactory().Type().createReference(values.toArray()[0].getClass())));
            for (Object o : values) {
                res.addElement(this.convertValueToExpression(o));
            }
        } else if (value instanceof Class) {
            res = this.getFactory().Code().createClassAccess(this.getFactory().Type().createReference((Class)value));
        } else if (value instanceof Field) {
            CtFieldReference variable = this.getFactory().Field().createReference((Field)value);
            variable.setStatic(true);
            CtTypeAccess<?> target = this.getFactory().Code().createTypeAccess(this.getFactory().Type().createReference(((Field)value).getDeclaringClass()));
            CtFieldRead<Object> fieldRead = this.getFactory().Core().createFieldRead();
            fieldRead.setVariable(variable);
            fieldRead.setTarget(target);
            fieldRead.setType(target.getAccessedType());
            res = fieldRead;
        } else if (this.isPrimitive(value.getClass()) || value instanceof String) {
            res = this.getFactory().Code().createLiteral(value);
        } else if (value.getClass().isEnum()) {
            CtTypeReference declaringClass = this.getFactory().Type().createReference(((Enum)value).getDeclaringClass());
            CtFieldReference variableRef = this.getFactory().Field().createReference(declaringClass, declaringClass, ((Enum)value).name());
            CtTypeAccess target = this.getFactory().Code().createTypeAccess(declaringClass);
            CtFieldRead fieldRead = this.getFactory().Core().createFieldRead();
            fieldRead.setVariable(variableRef);
            fieldRead.setTarget(target);
            fieldRead.setType(declaringClass);
            res = fieldRead;
        } else {
            throw new SpoonException("Please, submit a valid value.");
        }
        return res;
    }

    private boolean isPrimitive(Class c) {
        return c.isPrimitive() || c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class || c == Boolean.class || c == Character.class;
    }

    private <T extends CtAnnotation<A>> T addValueExpression(String elementName, CtExpression<?> expression) {
        if (this.elementValues.containsKey(elementName)) {
            CtExpression ctExpression = this.elementValues.get(elementName);
            if (ctExpression instanceof CtNewArray) {
                if (expression instanceof CtNewArray) {
                    List<CtExpression<?>> elements = ((CtNewArray)expression).getElements();
                    for (CtExpression<?> expInArray : elements) {
                        ((CtNewArray)ctExpression).addElement(expInArray);
                    }
                } else {
                    ((CtNewArray)ctExpression).addElement(expression);
                }
            } else {
                CtNewArray newArray = this.getFactory().Core().createNewArray();
                newArray.setType(ctExpression.getType());
                newArray.setParent(this);
                newArray.addElement(ctExpression);
                newArray.addElement(expression);
                this.elementValues.put(elementName, newArray);
            }
        } else {
            this.elementValues.put(elementName, expression);
            expression.setParent(this);
        }
        return (T)this;
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, CtLiteral<?> value) {
        return this.addValueExpression(elementName, value);
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, CtNewArray<? extends CtExpression> value) {
        return this.addValueExpression(elementName, value);
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, CtFieldAccess<?> value) {
        return this.addValueExpression(elementName, value);
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, CtAnnotation<?> value) {
        return this.addValueExpression(elementName, value);
    }

    private Object convertValue(Object value) {
        if (value instanceof CtFieldReference) {
            Class<?> c = null;
            try {
                c = ((CtFieldReference)value).getDeclaringType().getActualClass();
            }
            catch (Exception e) {
                return ((CtLiteral)((CtFieldReference)value).getDeclaration().getDefaultExpression().partiallyEvaluate()).getValue();
            }
            if (((CtFieldReference)value).getSimpleName().equals("class")) {
                return c;
            }
            CtField field = ((CtFieldReference)value).getDeclaration();
            if (Enum.class.isAssignableFrom(c)) {
                return Enum.valueOf(c, ((CtFieldReference)value).getSimpleName());
            }
            if (field != null) {
                return this.convertValue(field.getDefaultExpression());
            }
            try {
                return ((Field)((CtFieldReference)value).getActualField()).get(null);
            }
            catch (Exception e) {
                Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        if (value instanceof CtFieldAccess) {
            return this.convertValue(((CtFieldAccess)value).getVariable());
        }
        if (value instanceof CtNewArray) {
            CtNewArray arrayExpression = (CtNewArray)value;
            Class<?> componentType = arrayExpression.getType().getActualClass().getComponentType();
            List<CtExpression<?>> elements = arrayExpression.getElements();
            Object array = Array.newInstance(componentType, elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Array.set(array, i, this.convertValue(elements.get(i)));
            }
            return array;
        }
        if (value instanceof CtAnnotation) {
            return ((CtAnnotation)value).getActualAnnotation();
        }
        if (value instanceof CtLiteral) {
            return ((CtLiteral)value).getValue();
        }
        if (value instanceof CtCodeElement) {
            PartialEvaluator eval = this.getFactory().Eval().createPartialEvaluator();
            CtCodeElement ret = eval.evaluate((CtCodeElement)value);
            return this.convertValue(ret);
        }
        if (value instanceof CtTypeReference) {
            return ((CtTypeReference)value).getActualClass();
        }
        return value;
    }

    private Class<?> getElementType(String name) {
        CtType<A> t = this.getAnnotationType().getDeclaration();
        if (t != null) {
            CtMethod method = t.getMethod(name, new CtTypeReference[0]);
            return method.getType().getActualClass();
        }
        Class<A> c = this.getAnnotationType().getActualClass();
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(name)) continue;
            return m.getReturnType();
        }
        return null;
    }

    @Override
    public CtTypeReference<A> getAnnotationType() {
        return this.annotationType;
    }

    private Object getDefaultValue(String fieldName) {
        CtExpression ret = null;
        CtAnnotationType at = (CtAnnotationType)this.getAnnotationType().getDeclaration();
        if (at != null) {
            CtAnnotationMethod f = (CtAnnotationMethod)at.getMethod(fieldName, new CtTypeReference[0]);
            ret = f.getDefaultExpression();
        }
        return ret;
    }

    public <T> T getElementValue(String key) {
        Object ret = this.elementValues.get(key);
        if (ret == null) {
            ret = this.getDefaultValue(key);
        }
        if (ret == null) {
            ret = this.getReflectValue(key);
        }
        Class<?> type = this.getElementType(key);
        ret = this.convertValue(ret);
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE && ret.getClass() != Boolean.TYPE) {
                ret = Boolean.parseBoolean(ret.toString());
            } else if (type == Byte.TYPE && ret.getClass() != Byte.TYPE) {
                ret = Byte.parseByte(ret.toString());
            } else if (type == Character.TYPE && ret.getClass() != Character.TYPE) {
                ret = Character.valueOf(ret.toString().charAt(0));
            } else if (type == Double.TYPE && ret.getClass() != Double.TYPE) {
                ret = Double.parseDouble(ret.toString());
            } else if (type == Float.TYPE && ret.getClass() != Float.TYPE) {
                ret = Float.valueOf(Float.parseFloat(ret.toString()));
            } else if (type == Integer.TYPE && ret.getClass() != Integer.TYPE) {
                ret = Integer.parseInt(ret.toString());
            } else if (type == Long.TYPE && ret.getClass() != Long.TYPE) {
                ret = Long.parseLong(ret.toString());
            } else if (type == Short.TYPE && ret.getClass() != Short.TYPE) {
                ret = Short.parseShort(ret.toString());
            }
        }
        if (type.isArray() && ret != null && ret.getClass() != type) {
            Object array = Array.newInstance(ret.getClass(), 1);
            ((Object[])array)[0] = ret;
            ret = array;
        }
        return (T)ret;
    }

    @Override
    public <T extends CtExpression> T getValue(String key) {
        return (T)this.elementValues.get(key);
    }

    public Map<String, Object> getElementValues() {
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        for (Map.Entry<String, CtExpression> elementValue : this.elementValues.entrySet()) {
            res.put(elementValue.getKey(), elementValue.getValue());
        }
        return res;
    }

    @Override
    public Map<String, CtExpression> getValues() {
        return Collections.unmodifiableMap(this.elementValues);
    }

    private Object getReflectValue(String fieldname) {
        try {
            Class<A> c = this.getAnnotationType().getActualClass();
            Method m = c.getMethod(fieldname, new Class[0]);
            return m.getDefaultValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends CtAnnotation<A>> T setAnnotationType(CtTypeReference<? extends Annotation> annotationType) {
        if (annotationType != null) {
            annotationType.setParent(this);
        }
        this.annotationType = annotationType;
        return (T)this;
    }

    @Override
    public <T extends CtAnnotation<A>> T setElementValues(Map<String, Object> values) {
        this.elementValues.clear();
        for (Map.Entry<String, Object> e : values.entrySet()) {
            this.addValue(e.getKey(), e.getValue());
        }
        return (T)this;
    }

    @Override
    public <T extends CtAnnotation<A>> T setValues(Map<String, CtExpression> values) {
        this.elementValues.clear();
        for (Map.Entry<String, CtExpression> e : values.entrySet()) {
            this.addValue(e.getKey(), e.getValue());
        }
        return (T)this;
    }

    @Override
    public CtElement getAnnotatedElement() {
        return this.getParent();
    }

    @Override
    public CtAnnotatedElementType getAnnotatedElementType() {
        CtElement annotatedElement = this.getAnnotatedElement();
        if (annotatedElement == null) {
            return null;
        }
        if (annotatedElement instanceof CtMethod) {
            return CtAnnotatedElementType.METHOD;
        }
        if (annotatedElement instanceof CtAnnotation || annotatedElement instanceof CtAnnotationType) {
            return CtAnnotatedElementType.ANNOTATION_TYPE;
        }
        if (annotatedElement instanceof CtType) {
            return CtAnnotatedElementType.TYPE;
        }
        if (annotatedElement instanceof CtField) {
            return CtAnnotatedElementType.FIELD;
        }
        if (annotatedElement instanceof CtConstructor) {
            return CtAnnotatedElementType.CONSTRUCTOR;
        }
        if (annotatedElement instanceof CtParameter) {
            return CtAnnotatedElementType.PARAMETER;
        }
        if (annotatedElement instanceof CtLocalVariable) {
            return CtAnnotatedElementType.LOCAL_VARIABLE;
        }
        if (annotatedElement instanceof CtPackage) {
            return CtAnnotatedElementType.PACKAGE;
        }
        if (annotatedElement instanceof CtTypeParameterReference) {
            return CtAnnotatedElementType.TYPE_PARAMETER;
        }
        if (annotatedElement instanceof CtTypeReference) {
            return CtAnnotatedElementType.TYPE_USE;
        }
        return null;
    }

    @Override
    public A getActualAnnotation() {
        class AnnotationInvocationHandler
        implements InvocationHandler {
            CtAnnotation<? extends Annotation> annotation;

            AnnotationInvocationHandler(CtAnnotation<? extends Annotation> annotation) {
                this.annotation = annotation;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String fieldname = method.getName();
                if ("toString".equals(fieldname)) {
                    return CtAnnotationImpl.this.toString();
                }
                if ("annotationType".equals(fieldname)) {
                    return this.annotation.getAnnotationType().getActualClass();
                }
                Object ret = CtAnnotationImpl.this.getElementValue(fieldname);
                if (ret instanceof CtLiteral) {
                    CtLiteral l = (CtLiteral)ret;
                    return l.getValue();
                }
                return ret;
            }
        }
        return (A)((Annotation)Proxy.newProxyInstance(this.annotationType.getActualClass().getClassLoader(), new Class[]{this.annotationType.getActualClass()}, (InvocationHandler)new AnnotationInvocationHandler(this)));
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtAnnotation<A> clone() {
        return (CtAnnotation)super.clone();
    }
}

