/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.List;
import spoon.SpoonException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.support.reflect.code.CtCodeElementImpl;

public abstract class CtStatementImpl
extends CtCodeElementImpl
implements CtStatement {
    private static final long serialVersionUID = 1L;
    String label;

    public static void insertAfter(CtStatement target, CtStatement statement) throws ParentNotInitializedException {
        CtStatementList sts = target.getFactory().Core().createStatementList();
        sts.addStatement(statement);
        CtStatementImpl.insertAfter(target, sts);
    }

    public static void insertAfter(CtStatement target, CtStatementList statements) throws ParentNotInitializedException {
        CtElement e = target.getParent();
        if (e instanceof CtExecutable) {
            throw new RuntimeException("cannot insert in this context (use insertEnd?)");
        }
        new InsertVisitor(target, statements, InsertType.AFTER).scan(e);
    }

    public static void insertBefore(CtStatement target, CtStatement statement) throws ParentNotInitializedException {
        CtStatementList sts = target.getFactory().Core().createStatementList();
        sts.addStatement(statement);
        CtStatementImpl.insertBefore(target, sts);
    }

    public static void insertBefore(CtStatement target, CtStatementList statementsToBeInserted) throws ParentNotInitializedException {
        CtElement targetParent = target.getParent();
        if (targetParent instanceof CtExecutable) {
            throw new SpoonException("cannot insert in this context (use insertEnd?)");
        }
        try {
            if (target.getParent(CtConstructor.class) != null && target instanceof CtInvocation && ((CtInvocation)target).getExecutable().getSimpleName().startsWith("<init>")) {
                throw new SpoonException("cannot insert a statement before a super or this invocation.");
            }
        }
        catch (ParentNotInitializedException parentNotInitializedException) {
            // empty catch block
        }
        new InsertVisitor(target, statementsToBeInserted, InsertType.BEFORE).scan(targetParent);
    }

    @Override
    public <T extends CtStatement> T insertBefore(CtStatement statement) throws ParentNotInitializedException {
        CtStatementImpl.insertBefore((CtStatement)this, statement);
        return (T)this;
    }

    @Override
    public <T extends CtStatement> T insertBefore(CtStatementList statements) throws ParentNotInitializedException {
        CtStatementImpl.insertBefore((CtStatement)this, statements);
        return (T)this;
    }

    @Override
    public <T extends CtStatement> T insertAfter(CtStatement statement) throws ParentNotInitializedException {
        CtStatementImpl.insertAfter((CtStatement)this, statement);
        return (T)this;
    }

    @Override
    public <T extends CtStatement> T insertAfter(CtStatementList statements) throws ParentNotInitializedException {
        CtStatementImpl.insertAfter((CtStatement)this, statements);
        return (T)this;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public <T extends CtStatement> T setLabel(String label) {
        this.label = label;
        return (T)this;
    }

    @Override
    public void replace(CtStatement element) {
        this.replace((CtElement)element);
    }

    @Override
    public CtStatement clone() {
        return (CtStatement)super.clone();
    }

    private static enum InsertType {
        BEFORE{

            @Override
            void insert(CtBlock<?> block, CtStatementList statementsToBeInserted) {
                block.insertBegin(statementsToBeInserted);
            }

            @Override
            void insertFromFirstStatement(CtBlock<?> block, CtStatement target, CtStatementList statementsToBeInserted) {
                ArrayList<CtStatement> copy = new ArrayList<CtStatement>(block.getStatements());
                int indexOfTargetElement = this.indexOfReference(block.getStatements(), target);
                for (CtStatement ctStatement : statementsToBeInserted) {
                    copy.add(indexOfTargetElement++, ctStatement);
                }
                block.setStatements(copy);
            }

            @Override
            <T extends CtElement> List<T> insertFromLastStatement(List<T> statements, CtStatement target, CtStatementList statementsToBeInserted) {
                ArrayList<T> copy = new ArrayList<T>(statements);
                int indexOfTargetElement = this.indexOfReference(statements, target);
                for (int j = statementsToBeInserted.getStatements().size() - 1; j >= 0; --j) {
                    copy.add(indexOfTargetElement, (CtElement)statementsToBeInserted.getStatements().get(j));
                }
                return copy;
            }
        }
        ,
        AFTER{

            @Override
            void insert(CtBlock<?> block, CtStatementList statementsToBeInserted) {
                block.insertEnd(statementsToBeInserted);
            }

            @Override
            void insertFromFirstStatement(CtBlock<?> block, CtStatement target, CtStatementList statementsToBeInserted) {
                ArrayList<CtStatement> copy = new ArrayList<CtStatement>(block.getStatements());
                int indexOfTargetElement = this.indexOfReference(block.getStatements(), target);
                for (CtStatement s : statementsToBeInserted) {
                    copy.add(++indexOfTargetElement, s);
                }
                block.setStatements(copy);
            }

            @Override
            <T extends CtElement> List<T> insertFromLastStatement(List<T> statements, CtStatement target, CtStatementList statementsToBeInserted) {
                ArrayList<T> copy = new ArrayList<T>(statements);
                int indexOfTargetElement = this.indexOfReference(copy, target) + 1;
                for (int j = statementsToBeInserted.getStatements().size() - 1; j >= 0; --j) {
                    copy.add(indexOfTargetElement, (CtElement)statementsToBeInserted.getStatements().get(j));
                }
                return copy;
            }
        };


        public int indexOfReference(List statements, CtElement target) {
            int indexOfTargetElement = -1;
            for (int i = 0; i < statements.size(); ++i) {
                if (statements.get(i) != target) continue;
                indexOfTargetElement = i;
                break;
            }
            return indexOfTargetElement;
        }

        abstract void insert(CtBlock<?> var1, CtStatementList var2);

        abstract void insertFromFirstStatement(CtBlock<?> var1, CtStatement var2, CtStatementList var3);

        abstract <T extends CtElement> List<T> insertFromLastStatement(List<T> var1, CtStatement var2, CtStatementList var3);
    }

    private static class InsertVisitor
    extends CtInheritanceScanner {
        private final CtStatement target;
        private final CtStatementList statementsToBeInserted;
        private final InsertType insertType;

        InsertVisitor(CtStatement target, CtStatementList statementsToBeInserted, InsertType insertType) {
            this.target = target;
            this.statementsToBeInserted = statementsToBeInserted;
            this.insertType = insertType;
        }

        @Override
        public <R> void visitCtBlock(CtBlock<R> e) {
            super.visitCtBlock(e);
            this.insertType.insertFromFirstStatement(e, this.target, this.statementsToBeInserted);
        }

        @Override
        public void visitCtIf(CtIf e) {
            super.visitCtIf(e);
            boolean inThen = true;
            Object stat = e.getThenStatement();
            if (stat != this.target) {
                stat = e.getElseStatement();
                inThen = false;
            }
            if (stat != this.target) {
                throw new IllegalArgumentException("should not happen");
            }
            if (stat instanceof CtBlock) {
                this.insertType.insert((CtBlock)stat, this.statementsToBeInserted);
            } else {
                CtBlock<?> block = this.insertNewBlock((CtStatement)stat);
                if (inThen) {
                    e.setThenStatement(block);
                } else {
                    e.setElseStatement(block);
                }
            }
        }

        @Override
        public <E> void visitCtSwitch(CtSwitch<E> e) {
            super.visitCtSwitch(e);
            for (CtStatement s : this.statementsToBeInserted) {
                if (s instanceof CtCase) continue;
                throw new RuntimeException("cannot insert something that is not case in a switch");
            }
            e.setCases(this.insertType.insertFromLastStatement(e.getCases(), this.target, this.statementsToBeInserted));
        }

        @Override
        public <E> void visitCtCase(CtCase<E> e) {
            super.visitCtCase(e);
            this.target.setParent(e);
            e.setStatements(this.insertType.insertFromLastStatement(e.getStatements(), this.target, this.statementsToBeInserted));
        }

        @Override
        public void scanCtLoop(CtLoop loop) {
            super.scanCtLoop(loop);
            CtStatement stat = loop.getBody();
            if (stat instanceof CtBlock) {
                this.insertType.insert((CtBlock)stat, this.statementsToBeInserted);
            } else {
                CtBlock<?> block = this.insertNewBlock(stat);
                this.target.setParent(block);
                loop.setBody(block);
            }
        }

        private CtBlock<?> insertNewBlock(CtStatement stat) {
            CtBlock block = this.target.getFactory().Core().createBlock();
            block.addStatement(stat);
            this.insertType.insertFromFirstStatement(block, this.target, this.statementsToBeInserted);
            return block;
        }
    }
}

