/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtCaseImpl<E>
extends CtStatementImpl
implements CtCase<E> {
    private static final long serialVersionUID = 1L;
    CtExpression<E> caseExpression;
    List<CtStatement> statements = CtCaseImpl.emptyList();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtCase(this);
    }

    @Override
    public CtExpression<E> getCaseExpression() {
        return this.caseExpression;
    }

    @Override
    public List<CtStatement> getStatements() {
        return this.statements;
    }

    @Override
    public <T extends CtCase<E>> T setCaseExpression(CtExpression<E> caseExpression) {
        if (caseExpression != null) {
            caseExpression.setParent(this);
        }
        this.caseExpression = caseExpression;
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T setStatements(List<CtStatement> statements) {
        if (statements == null || statements.isEmpty()) {
            this.statements = CtElementImpl.emptyList();
            return (T)this;
        }
        this.statements.clear();
        for (CtStatement stmt : statements) {
            this.addStatement(stmt);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T addStatement(CtStatement statement) {
        if (statement == null) {
            return (T)this;
        }
        if (this.statements == CtElementImpl.emptyList()) {
            this.statements = new ArrayList<CtStatement>(2);
        }
        statement.setParent(this);
        this.statements.add(statement);
        return (T)this;
    }

    @Override
    public void removeStatement(CtStatement statement) {
        if (this.statements == CtElementImpl.emptyList()) {
            return;
        }
        this.statements.remove(statement);
    }

    @Override
    public Iterator<CtStatement> iterator() {
        return this.getStatements().iterator();
    }

    @Override
    public CtCase<E> clone() {
        return (CtCase)super.clone();
    }
}

