/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import spoon.Launcher;
import spoon.reflect.factory.Factory;
import spoon.support.SerializationModelStreamer;
import spoon.support.gui.SpoonObjectFieldsTable;
import spoon.support.gui.SpoonTreeBuilder;

public class SpoonModelTree
extends JFrame
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    Enumeration<?> enume;
    private Factory factory;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTree jTree = null;
    JPopupMenu menu;
    private DefaultMutableTreeNode root;
    String searchValue;

    public SpoonModelTree(Factory factory) {
        SpoonTreeBuilder cst = new SpoonTreeBuilder();
        cst.scan(factory.Package().getRootPackage());
        this.factory = factory;
        this.root = cst.getRoot();
        this.initialize();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(gridLayout);
            this.jContentPane.add((Component)this.getJScrollPane(), null);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree(this.root);
            this.jTree.addKeyListener(this);
            this.jTree.addMouseListener(this);
        }
        return this.jTree;
    }

    private JPopupMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Save");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean cont;
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileSelectionMode(0);
                    boolean bl = cont = chooser.showSaveDialog(SpoonModelTree.this) == 0;
                    if (cont) {
                        SerializationModelStreamer ser = new SerializationModelStreamer();
                        try {
                            ser.save(SpoonModelTree.this.factory, new FileOutputStream(chooser.getSelectedFile()));
                        }
                        catch (IOException e1) {
                            Launcher.LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            });
            this.menu.add(item);
            this.menu.addSeparator();
            item = new JMenuItem("Reflect");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)SpoonModelTree.this.jTree.getLastSelectedPathComponent();
                    if (node == null) {
                        node = SpoonModelTree.this.root;
                    }
                    new SpoonObjectFieldsTable(node.getUserObject());
                }
            });
            this.menu.add(item);
            this.menu.addSeparator();
            item = new JMenuItem("Search");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpoonModelTree.this.search();
                }
            });
            this.menu.add(item);
            item = new JMenuItem("Search next");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpoonModelTree.this.next();
                }
            });
            this.menu.add(item);
            this.menu.addSeparator();
            item = new JMenuItem("Expand all");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)SpoonModelTree.this.jTree.getLastSelectedPathComponent();
                    if (node == null) {
                        node = SpoonModelTree.this.root;
                    }
                    SpoonModelTree.this.expandAll(node);
                }
            });
            this.menu.add(item);
        }
        return this.menu;
    }

    private void initialize() {
        this.setSize(640, 480);
        this.setLocation((this.getGraphicsConfiguration().getDevice().getDisplayMode().getWidth() - this.getWidth()) / 2, (this.getGraphicsConfiguration().getDevice().getDisplayMode().getHeight() - this.getHeight()) / 2);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Spoon");
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        switch (e.getKeyChar()) {
            case 's': {
                break;
            }
            case 'n': {
                this.next();
                break;
            }
            case 'o': {
                if (this.jTree.getLastSelectedPathComponent() == null) break;
                new SpoonObjectFieldsTable(((DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent()).getUserObject());
            }
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.getJTree().setSelectionRow(this.getJTree().getClosestRowForLocation(e.getX(), e.getY()));
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public DefaultMutableTreeNode next() {
        DefaultMutableTreeNode current = null;
        while (this.enume != null && this.enume.hasMoreElements()) {
            current = (DefaultMutableTreeNode)this.enume.nextElement();
            if (current.getUserObject() == null || !current.getUserObject().toString().contains(this.searchValue)) continue;
            this.setVisible(current);
            return current;
        }
        return null;
    }

    public DefaultMutableTreeNode search() {
        this.searchValue = JOptionPane.showInputDialog(this, "Enter value to search:", "Search");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            node = this.root;
        }
        this.enume = node.depthFirstEnumeration();
        if (this.searchValue != null) {
            return this.next();
        }
        return null;
    }

    public DefaultMutableTreeNode expandAll(final DefaultMutableTreeNode node) {
        if (node == null || node.isLeaf()) {
            return null;
        }
        final ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LinkedList<DefaultMutableTreeNode> q = new LinkedList<DefaultMutableTreeNode>();
                    q.add(node);
                    while (!q.isEmpty()) {
                        DefaultMutableTreeNode n = (DefaultMutableTreeNode)q.poll();
                        SpoonModelTree.this.expand(n);
                        Enumeration<TreeNode> children = n.children();
                        while (children.hasMoreElements()) {
                            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                            if (child.isLeaf() || child.getChildCount() <= 0) continue;
                            q.offer(child);
                        }
                    }
                }
                finally {
                    executor.shutdownNow();
                }
            }
        });
        return node;
    }

    public void expand(final DefaultMutableTreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath path = new TreePath(node.getPath());
                if (!SpoonModelTree.this.jTree.isExpanded(path)) {
                    SpoonModelTree.this.jTree.expandPath(path);
                    SpoonModelTree.this.jTree.updateUI();
                }
            }
        });
    }

    public void setVisible(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.getJTree().scrollPathToVisible(path);
        this.getJTree().setSelectionPath(path);
    }
}

