/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.CoreFactory;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;

public class PositionBuilder {
    private final JDTTreeBuilder jdtTreeBuilder;

    public PositionBuilder(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    SourcePosition buildPosition(int sourceStart, int sourceEnd) {
        CompilationUnit cu = this.jdtTreeBuilder.getContextBuilder().compilationUnitSpoon;
        int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.compilationResult.lineSeparatorPositions;
        return this.jdtTreeBuilder.getFactory().Core().createSourcePosition(cu, sourceStart, sourceEnd, lineSeparatorPositions);
    }

    SourcePosition buildPositionCtElement(CtElement e, ASTNode node) {
        CoreFactory cf = this.jdtTreeBuilder.getFactory().Core();
        CompilationUnit cu = this.jdtTreeBuilder.getFactory().CompilationUnit().create(new String(this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.getFileName()));
        int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.compilationResult.lineSeparatorPositions;
        int sourceStart = node.sourceStart;
        int sourceEnd = node.sourceEnd;
        if (node instanceof Expression && ((Expression)node).statementEnd > 0) {
            sourceEnd = ((Expression)node).statementEnd;
        }
        if (node instanceof AbstractVariableDeclaration) {
            int modifiersSourceEnd;
            AbstractVariableDeclaration variableDeclaration = (AbstractVariableDeclaration)node;
            int modifiersSourceStart = variableDeclaration.modifiersSourceStart;
            int declarationSourceStart = variableDeclaration.declarationSourceStart;
            int declarationSourceEnd = variableDeclaration.declarationSourceEnd;
            int declarationEnd = variableDeclaration.declarationEnd;
            Annotation[] annotations = variableDeclaration.annotations;
            if (annotations != null && annotations.length > 0 && annotations[0].sourceStart() == sourceStart) {
                modifiersSourceStart = annotations[annotations.length - 1].sourceEnd() + 2;
            }
            if (modifiersSourceStart == 0) {
                modifiersSourceStart = declarationSourceStart;
            }
            if (modifiersSourceStart > (modifiersSourceEnd = variableDeclaration.type != null ? variableDeclaration.type.sourceStart() - 2 : declarationSourceStart - 1)) {
                modifiersSourceEnd = modifiersSourceStart - 1;
            }
            return cf.createDeclarationSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, lineSeparatorPositions);
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)node;
            int declarationSourceStart = typeDeclaration.declarationSourceStart;
            int declarationSourceEnd = typeDeclaration.declarationSourceEnd;
            int modifiersSourceStart = typeDeclaration.modifiersSourceStart;
            int bodyStart = typeDeclaration.bodyStart;
            int bodyEnd = typeDeclaration.bodyEnd;
            Annotation[] annotations = typeDeclaration.annotations;
            if (annotations != null && annotations.length > 0 && annotations[0].sourceStart() == declarationSourceStart) {
                modifiersSourceStart = annotations[annotations.length - 1].sourceEnd() + 2;
            }
            if (modifiersSourceStart == 0) {
                modifiersSourceStart = declarationSourceStart;
            }
            int modifiersSourceEnd = sourceStart - 8;
            return cf.createBodyHolderSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, bodyStart - 1, bodyEnd, lineSeparatorPositions);
        }
        if (node instanceof AbstractMethodDeclaration) {
            TypeParameter[] typeParameters;
            Annotation[] annotations;
            Javadoc javadoc;
            AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)node;
            int bodyStart = methodDeclaration.bodyStart;
            int bodyEnd = methodDeclaration.bodyEnd;
            int declarationSourceStart = methodDeclaration.declarationSourceStart;
            int declarationSourceEnd = methodDeclaration.declarationSourceEnd;
            int modifiersSourceStart = methodDeclaration.modifiersSourceStart;
            if (modifiersSourceStart == 0) {
                modifiersSourceStart = declarationSourceStart;
            }
            if ((javadoc = methodDeclaration.javadoc) != null && javadoc.sourceEnd() > declarationSourceStart) {
                modifiersSourceStart = javadoc.sourceEnd() + 1;
            }
            if ((annotations = methodDeclaration.annotations) != null && annotations.length > 0 && annotations[0].sourceStart() == declarationSourceStart) {
                modifiersSourceStart = annotations[annotations.length - 1].sourceEnd() + 2;
            }
            int modifiersSourceEnd = sourceStart - 1;
            if (methodDeclaration instanceof MethodDeclaration && ((MethodDeclaration)methodDeclaration).returnType != null) {
                modifiersSourceEnd = ((MethodDeclaration)methodDeclaration).returnType.sourceStart() - 2;
            }
            if ((typeParameters = methodDeclaration.typeParameters()) != null && typeParameters.length > 0) {
                modifiersSourceEnd = typeParameters[0].declarationSourceStart - 3;
            }
            if (JDTTreeBuilderQuery.getModifiers(methodDeclaration.modifiers).isEmpty()) {
                modifiersSourceStart = modifiersSourceEnd + 1;
            }
            sourceEnd = sourceStart + methodDeclaration.selector.length - 1;
            if (e instanceof CtStatementList) {
                return cf.createSourcePosition(cu, bodyStart - 1, bodyEnd + 1, lineSeparatorPositions);
            }
            if (bodyStart == 0) {
                return SourcePosition.NOPOSITION;
            }
            return cf.createBodyHolderSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, bodyStart - 1, bodyEnd + 1, lineSeparatorPositions);
        }
        if (node instanceof Expression) {
            Expression expression = (Expression)node;
            int statementEnd = expression.statementEnd;
            if (statementEnd > 0) {
                sourceEnd = statementEnd;
            }
        }
        return cf.createSourcePosition(cu, sourceStart, sourceEnd, lineSeparatorPositions);
    }
}

