/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtAnnotatedElementType;
import spoon.reflect.declaration.ModifierKind;
import spoon.support.compiler.jdt.ContextBuilder;

class JDTTreeBuilderQuery {
    JDTTreeBuilderQuery() {
    }

    static TypeBinding searchTypeBinding(ReferenceBinding type, String simpleName) {
        if (simpleName == null || type == null) {
            return null;
        }
        if (type.memberTypes() != null) {
            for (ReferenceBinding memberType : type.memberTypes()) {
                if (!simpleName.equals(CharOperation.charToString(memberType.sourceName()))) continue;
                return memberType;
            }
        }
        return JDTTreeBuilderQuery.searchTypeBinding(type.superclass(), simpleName);
    }

    static TypeBinding searchTypeBinding(String qualifiedName, CompilationUnitDeclaration[] unitsToProcess) {
        if (qualifiedName == null) {
            return null;
        }
        for (CompilationUnitDeclaration unitToProcess : unitsToProcess) {
            for (TypeDeclaration type : unitToProcess.types) {
                if (qualifiedName.equals(CharOperation.toString(type.binding.compoundName))) {
                    return type.binding;
                }
                if (type.memberTypes == null) continue;
                for (TypeDeclaration memberType : type.memberTypes) {
                    if (!qualifiedName.equals(CharOperation.toString(memberType.binding.compoundName))) continue;
                    return type.binding;
                }
            }
        }
        return null;
    }

    static String searchType(String typeName, ImportReference[] imports) {
        if (typeName == null) {
            return null;
        }
        if (imports == null) {
            return null;
        }
        for (ImportReference anImport : imports) {
            String importType = CharOperation.charToString(anImport.getImportName()[anImport.getImportName().length - 1]);
            if (importType == null || !importType.equals(typeName)) continue;
            return CharOperation.toString(anImport.getImportName());
        }
        return null;
    }

    static ImportReference searchPackage(char[][] packageName, CompilationUnitDeclaration[] unitsToProcess) {
        for (CompilationUnitDeclaration unit : unitsToProcess) {
            char[][] tokens;
            ImportReference currentPackage = unit.currentPackage;
            if (currentPackage == null || packageName.length > (tokens = currentPackage.tokens).length) continue;
            boolean isFound = true;
            for (int i = 0; i < packageName.length; ++i) {
                char[] chars = packageName[i];
                if (CharOperation.equals(chars, tokens[i])) continue;
                isFound = false;
                break;
            }
            if (!isFound) continue;
            return currentPackage;
        }
        return null;
    }

    static boolean hasAnnotationWithType(Annotation a, CtAnnotatedElementType elementType) {
        if (a.resolvedType == null) {
            return false;
        }
        for (AnnotationBinding annotation : a.resolvedType.getAnnotations()) {
            Object[] fields;
            Object value;
            if (!"Target".equals(CharOperation.charToString(annotation.getAnnotationType().sourceName())) || (value = annotation.getElementValuePairs()[0].value) == null || !value.getClass().isArray()) continue;
            for (Object field : fields = (Object[])value) {
                if (!(field instanceof FieldBinding) || !elementType.name().equals(CharOperation.charToString(((FieldBinding)field).name))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isValidProblemBindingField(QualifiedNameReference qualifiedNameReference) {
        return qualifiedNameReference.binding instanceof ProblemFieldBinding && !((FieldBinding)qualifiedNameReference.binding).declaringClass.isAnonymousType() && qualifiedNameReference.tokens.length - 1 == ((FieldBinding)qualifiedNameReference.binding).declaringClass.compoundName.length && CharOperation.equals(CharOperation.subarray(qualifiedNameReference.tokens, 0, qualifiedNameReference.tokens.length - 1), ((FieldBinding)qualifiedNameReference.binding).declaringClass.compoundName);
    }

    static boolean isLhsAssignment(ContextBuilder context, Expression lhs) {
        return context.stack.peek().node instanceof Assignment && ((Assignment)context.stack.peek().node).lhs.equals(lhs);
    }

    static UnaryOperatorKind getUnaryOperator(int operator) {
        switch (operator) {
            case 14: {
                return UnaryOperatorKind.POS;
            }
            case 13: {
                return UnaryOperatorKind.NEG;
            }
            case 11: {
                return UnaryOperatorKind.NOT;
            }
            case 12: {
                return UnaryOperatorKind.COMPL;
            }
        }
        return null;
    }

    static BinaryOperatorKind getBinaryOperatorKind(int operator) {
        switch (operator) {
            case 18: {
                return BinaryOperatorKind.EQ;
            }
            case 5: {
                return BinaryOperatorKind.LE;
            }
            case 7: {
                return BinaryOperatorKind.GE;
            }
            case 29: {
                return BinaryOperatorKind.NE;
            }
            case 10: {
                return BinaryOperatorKind.SL;
            }
            case 17: {
                return BinaryOperatorKind.SR;
            }
            case 19: {
                return BinaryOperatorKind.USR;
            }
            case 1: {
                return BinaryOperatorKind.OR;
            }
            case 0: {
                return BinaryOperatorKind.AND;
            }
            case 14: {
                return BinaryOperatorKind.PLUS;
            }
            case 13: {
                return BinaryOperatorKind.MINUS;
            }
            case 11: {
                return BinaryOperatorKind.NE;
            }
            case 16: {
                return BinaryOperatorKind.MOD;
            }
            case 8: {
                return BinaryOperatorKind.BITXOR;
            }
            case 2: {
                return BinaryOperatorKind.BITAND;
            }
            case 15: {
                return BinaryOperatorKind.MUL;
            }
            case 3: {
                return BinaryOperatorKind.BITOR;
            }
            case 9: {
                return BinaryOperatorKind.DIV;
            }
            case 6: {
                return BinaryOperatorKind.GT;
            }
            case 4: {
                return BinaryOperatorKind.LT;
            }
            case 23: {
                throw new RuntimeException("Unknown operator");
            }
            case 30: {
                return BinaryOperatorKind.EQ;
            }
        }
        return null;
    }

    static Set<ModifierKind> getModifiers(int modifier) {
        EnumSet<ModifierKind> modifiers = EnumSet.noneOf(ModifierKind.class);
        if ((modifier & 1) != 0) {
            modifiers.add(ModifierKind.PUBLIC);
        }
        if ((modifier & 2) != 0) {
            modifiers.add(ModifierKind.PRIVATE);
        }
        if ((modifier & 4) != 0) {
            modifiers.add(ModifierKind.PROTECTED);
        }
        if ((modifier & 8) != 0) {
            modifiers.add(ModifierKind.STATIC);
        }
        if ((modifier & 0x10) != 0) {
            modifiers.add(ModifierKind.FINAL);
        }
        if ((modifier & 0x20) != 0) {
            modifiers.add(ModifierKind.SYNCHRONIZED);
        }
        if ((modifier & 0x40) != 0) {
            modifiers.add(ModifierKind.VOLATILE);
        }
        if ((modifier & 0x80) != 0) {
            modifiers.add(ModifierKind.TRANSIENT);
        }
        if ((modifier & 0x400) != 0) {
            modifiers.add(ModifierKind.ABSTRACT);
        }
        if ((modifier & 0x800) != 0) {
            modifiers.add(ModifierKind.STRICTFP);
        }
        if ((modifier & 0x100) != 0) {
            modifiers.add(ModifierKind.NATIVE);
        }
        return modifiers;
    }
}

