/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.output.NullOutputStream;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.util.CommentRecorderParser;
import spoon.SpoonException;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.compiler.jdt.TreeBuilderCompiler;

public class JDTBatchCompiler
extends Main {
    protected final JDTBasedSpoonCompiler jdtCompiler;
    protected CompilationUnit[] compilationUnits;
    protected Set<String> filesToBeIgnored = new HashSet<String>();

    public JDTBatchCompiler(JDTBasedSpoonCompiler jdtCompiler) {
        this(jdtCompiler, (OutputStream)new NullOutputStream(), (OutputStream)new NullOutputStream());
    }

    JDTBatchCompiler(JDTBasedSpoonCompiler jdtCompiler, OutputStream outWriter, OutputStream errWriter) {
        super(new PrintWriter(outWriter), new PrintWriter(errWriter), false, null, null);
        this.jdtCompiler = jdtCompiler;
        if (jdtCompiler != null) {
            this.jdtCompiler.probs.clear();
        }
    }

    @Override
    public CompilationUnit[] getCompilationUnits() {
        return this.compilationUnits;
    }

    public void setCompilationUnits(CompilationUnit[] compilationUnits) {
        this.compilationUnits = compilationUnits;
    }

    @Override
    public ICompilerRequestor getBatchRequestor() {
        final ICompilerRequestor r = super.getBatchRequestor();
        return new ICompilerRequestor(){

            @Override
            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.hasErrors()) {
                    for (CategorizedProblem problem : compilationResult.problems) {
                        if (JDTBatchCompiler.this.jdtCompiler == null) {
                            throw new SpoonException(problem.toString());
                        }
                        JDTBatchCompiler.this.jdtCompiler.reportProblem(problem);
                    }
                }
                r.acceptResult(compilationResult);
            }
        };
    }

    public void ignoreFile(String filePath) {
        this.filesToBeIgnored.add(filePath);
    }

    public CompilationUnitDeclaration[] getUnits() {
        this.startTime = System.currentTimeMillis();
        INameEnvironment environment = this.jdtCompiler.environment;
        if (environment == null) {
            environment = this.getLibraryAccess();
        }
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.parseLiteralExpressionsAsConstants = false;
        TreeBuilderCompiler treeBuilderCompiler = new TreeBuilderCompiler(environment, this.getHandlingPolicy(), compilerOptions, this.jdtCompiler.requestor, this.getProblemFactory(), this.out, null);
        if (this.jdtCompiler.getEnvironment().getNoClasspath()) {
            treeBuilderCompiler.lookupEnvironment.mayTolerateMissingType = true;
        }
        CompilationUnitDeclaration[] result = treeBuilderCompiler.buildUnits(this.getCompilationUnits());
        for (int i = 0; i < result.length; ++i) {
            CompilationUnitDeclaration unit = result[i];
            CommentRecorderParser parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault())), false);
            ICompilationUnit sourceUnit = unit.compilationResult.compilationUnit;
            CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
            CompilationUnitDeclaration tmpDeclForComment = parser.dietParse(sourceUnit, compilationResult);
            unit.comments = tmpDeclForComment.comments;
        }
        return result;
    }

    public JDTBasedSpoonCompiler getJdtCompiler() {
        return this.jdtCompiler;
    }
}

