/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.Launcher;
import spoon.processing.AbstractProcessor;
import spoon.processing.FileGenerator;
import spoon.processing.TraversalStrategy;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.PrettyPrinter;

public class JavaOutputProcessor
extends AbstractProcessor<CtNamedElement>
implements FileGenerator<CtNamedElement> {
    PrettyPrinter printer;
    File directory;
    List<File> printedFiles = new ArrayList<File>();
    Map<String, Map<Integer, Integer>> lineNumberMappings = new HashMap<String, Map<Integer, Integer>>();

    public JavaOutputProcessor(File outputDirectory, PrettyPrinter printer) {
        this.directory = outputDirectory;
        this.printer = printer;
    }

    public JavaOutputProcessor() {
    }

    public PrettyPrinter getPrinter() {
        return this.printer;
    }

    @Override
    public List<File> getCreatedFiles() {
        return this.printedFiles;
    }

    @Override
    public File getOutputDirectory() {
        return this.directory;
    }

    @Override
    public void init() {
        if (this.directory == null) {
            throw new RuntimeException("You should set output directory before printing");
        }
        if (this.directory.isFile()) {
            throw new RuntimeException("Output must be a directory");
        }
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new RuntimeException("Error creating output directory");
        }
        try {
            this.directory = this.directory.getCanonicalFile();
        }
        catch (IOException e) {
            Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJavaFile(CtType<?> element) {
        this.getEnvironment().debugMessage("printing " + element.getQualifiedName() + " to " + this.directory);
        if (!element.isTopLevel()) {
            throw new IllegalArgumentException();
        }
        CompilationUnit cu = null;
        if (element.getPosition() != null && (cu = element.getPosition().getCompilationUnit()) == null) {
            cu = element.getFactory().CompilationUnit().create(element.getQualifiedName());
            cu.setDeclaredPackage(element.getPackage());
        }
        ArrayList toBePrinted = new ArrayList();
        toBePrinted.add(element);
        this.printer.calculate(cu, toBePrinted);
        CtPackage pack = element.getPackage();
        try (PrintStream stream = null;){
            File file = new File(this.getPackageFile(pack).getAbsolutePath() + File.separatorChar + element.getSimpleName() + ".java");
            file.createNewFile();
            if (!this.printedFiles.contains(file)) {
                this.printedFiles.add(file);
            }
            stream = new PrintStream(file);
            stream.print(this.printer.getResult());
            for (CtType ctType : toBePrinted) {
                this.lineNumberMappings.put(ctType.getQualifiedName(), this.printer.getLineNumberMapping());
            }
            stream.close();
        }
    }

    @Override
    public boolean isToBeProcessed(CtNamedElement candidate) {
        return candidate instanceof CtType || candidate instanceof CtPackage && (candidate.getComments().size() > 0 || candidate.getAnnotations().size() > 0);
    }

    @Override
    public void process(CtNamedElement nameElement) {
        if (nameElement instanceof CtType && ((CtType)nameElement).isTopLevel()) {
            this.createJavaFile((CtType)nameElement);
        } else if (nameElement instanceof CtPackage) {
            this.createPackageFile((CtPackage)nameElement);
        }
        this.printer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPackageFile(CtPackage pack) {
        File packageAnnot = new File(this.getPackageFile(pack).getAbsolutePath() + File.separatorChar + "package-info.java");
        if (!this.printedFiles.contains(packageAnnot)) {
            this.printedFiles.add(packageAnnot);
        }
        try (PrintStream stream = null;){
            stream = new PrintStream(packageAnnot);
            stream.println(this.printer.printPackageInfo(pack));
            stream.close();
        }
    }

    private File getPackageFile(CtPackage pack) {
        File packageDir = pack.isUnnamedPackage() ? new File(this.directory.getAbsolutePath()) : new File(this.directory.getAbsolutePath() + File.separatorChar + pack.getQualifiedName().replace('.', File.separatorChar));
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            throw new RuntimeException("Error creating output directory");
        }
        return packageDir;
    }

    @Override
    public void setOutputDirectory(File directory) {
        this.directory = directory;
    }

    public Map<String, Map<Integer, Integer>> getLineNumberMappings() {
        return this.lineNumberMappings;
    }

    @Override
    public TraversalStrategy getTraversalStrategy() {
        return TraversalStrategy.PRE_ORDER;
    }
}

