/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.printer;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import spoon.compiler.Environment;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtElement;

public class PrinterHelper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Environment env;
    private final StringBuffer sbf = new StringBuffer();
    private int nbTabs = 0;
    private int line = 1;
    private Map<Integer, Integer> lineNumberMapping = new HashMap<Integer, Integer>();
    private ArrayDeque<Integer> lengths = new ArrayDeque();

    public PrinterHelper(Environment env) {
        this.env = env;
    }

    public PrinterHelper write(String s) {
        if (s != null) {
            this.sbf.append(s);
        }
        return this;
    }

    public PrinterHelper write(char c) {
        this.sbf.append(c);
        return this;
    }

    public PrinterHelper writeln() {
        this.sbf.append(LINE_SEPARATOR);
        ++this.line;
        return this;
    }

    public PrinterHelper writeTabs() {
        for (int i = 0; i < this.nbTabs; ++i) {
            if (this.env.isUsingTabulations()) {
                this.sbf.append("\t");
                continue;
            }
            for (int j = 0; j < this.env.getTabulationSize(); ++j) {
                this.sbf.append(" ");
            }
        }
        return this;
    }

    public PrinterHelper incTab() {
        ++this.nbTabs;
        return this;
    }

    public PrinterHelper decTab() {
        --this.nbTabs;
        return this;
    }

    public PrinterHelper setTabCount(int tabCount) {
        this.nbTabs = tabCount;
        return this;
    }

    public void insertLine() {
        int i;
        for (i = this.sbf.length() - 1; i >= 0 && (this.sbf.charAt(i) == ' ' || this.sbf.charAt(i) == '\t'); --i) {
        }
        this.sbf.insert(i + 1, LINE_SEPARATOR);
        ++this.line;
    }

    public boolean removeLine() {
        int i;
        String ls = LINE_SEPARATOR;
        boolean hasWhite = false;
        for (i = this.sbf.length() - ls.length(); i > 0 && !ls.equals(this.sbf.substring(i, i + ls.length())); --i) {
            if (!this.isWhite(this.sbf.charAt(i))) {
                return false;
            }
            hasWhite = true;
        }
        if (i <= 0) {
            return false;
        }
        hasWhite = hasWhite || this.isWhite(this.sbf.charAt(i - 1));
        this.sbf.replace(i, i + ls.length(), hasWhite ? "" : " ");
        --this.line;
        return true;
    }

    private boolean isWhite(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public void adjustPosition(CtElement e, CompilationUnit unitExpected) {
        if (e.getPosition() != null && !e.isImplicit() && e.getPosition().getCompilationUnit() != null && e.getPosition().getCompilationUnit() == unitExpected) {
            while (this.line < e.getPosition().getLine()) {
                this.insertLine();
            }
            while (this.line > e.getPosition().getLine()) {
                if (this.removeLine()) continue;
                if (this.line <= e.getPosition().getEndLine()) break;
                String message = "cannot adjust position of " + e.getClass().getSimpleName() + " '" + e.getShortRepresentation() + "'  to match lines: " + this.line + " > [" + e.getPosition().getLine() + ", " + e.getPosition().getEndLine() + "]";
                this.env.report(null, Level.WARN, e, message);
                break;
            }
        }
    }

    public void undefineLine() {
        if (this.lineNumberMapping.get(this.line) == null) {
            this.putLineNumberMapping(0);
        }
    }

    public void mapLine(CtElement e, CompilationUnit unitExpected) {
        if (e.getPosition() != null && e.getPosition().getCompilationUnit() == unitExpected) {
            this.putLineNumberMapping(e.getPosition().getLine());
        } else {
            this.undefineLine();
        }
    }

    public void putLineNumberMapping(int valueLine) {
        this.lineNumberMapping.put(this.line, valueLine);
    }

    public PrinterHelper removeLastChar() {
        while (this.isWhite(this.sbf.charAt(this.sbf.length() - 1))) {
            if (this.sbf.charAt(this.sbf.length() - 1) == '\n') {
                --this.line;
            }
            this.sbf.deleteCharAt(this.sbf.length() - 1);
        }
        this.sbf.deleteCharAt(this.sbf.length() - 1);
        while (this.isWhite(this.sbf.charAt(this.sbf.length() - 1))) {
            if (this.sbf.charAt(this.sbf.length() - 1) == '\n') {
                --this.line;
            }
            this.sbf.deleteCharAt(this.sbf.length() - 1);
        }
        return this;
    }

    public void preWriteUnaryOperator(UnaryOperatorKind o) {
        switch (o) {
            case POS: {
                this.write("+");
                break;
            }
            case NEG: {
                this.write("-");
                break;
            }
            case NOT: {
                this.write("!");
                break;
            }
            case COMPL: {
                this.write("~");
                break;
            }
            case PREINC: {
                this.write("++");
                break;
            }
            case PREDEC: {
                this.write("--");
                break;
            }
        }
    }

    public void postWriteUnaryOperator(UnaryOperatorKind o) {
        switch (o) {
            case POSTINC: {
                this.write("++");
                break;
            }
            case POSTDEC: {
                this.write("--");
                break;
            }
        }
    }

    public PrinterHelper writeOperator(BinaryOperatorKind o) {
        switch (o) {
            case OR: {
                this.write("||");
                break;
            }
            case AND: {
                this.write("&&");
                break;
            }
            case BITOR: {
                this.write("|");
                break;
            }
            case BITXOR: {
                this.write("^");
                break;
            }
            case BITAND: {
                this.write("&");
                break;
            }
            case EQ: {
                this.write("==");
                break;
            }
            case NE: {
                this.write("!=");
                break;
            }
            case LT: {
                this.write("<");
                break;
            }
            case GT: {
                this.write(">");
                break;
            }
            case LE: {
                this.write("<=");
                break;
            }
            case GE: {
                this.write(">=");
                break;
            }
            case SL: {
                this.write("<<");
                break;
            }
            case SR: {
                this.write(">>");
                break;
            }
            case USR: {
                this.write(">>>");
                break;
            }
            case PLUS: {
                this.write("+");
                break;
            }
            case MINUS: {
                this.write("-");
                break;
            }
            case MUL: {
                this.write("*");
                break;
            }
            case DIV: {
                this.write("/");
                break;
            }
            case MOD: {
                this.write("%");
                break;
            }
            case INSTANCEOF: {
                this.write("instanceof");
            }
        }
        return this;
    }

    public void writeStringLiteral(String value, boolean mayContainsSpecialCharacter) {
        if (!mayContainsSpecialCharacter) {
            this.write(value);
            return;
        }
        block10: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.UnicodeBlock.of(c) != Character.UnicodeBlock.BASIC_LATIN) {
                if (c < '\u0010') {
                    this.write("\\u000" + Integer.toHexString(c));
                    continue;
                }
                if (c < '\u0100') {
                    this.write("\\u00" + Integer.toHexString(c));
                    continue;
                }
                if (c < '\u1000') {
                    this.write("\\u0" + Integer.toHexString(c));
                    continue;
                }
                this.write("\\u" + Integer.toHexString(c));
                continue;
            }
            switch (c) {
                case '\b': {
                    this.write("\\b");
                    continue block10;
                }
                case '\t': {
                    this.write("\\t");
                    continue block10;
                }
                case '\n': {
                    this.write("\\n");
                    continue block10;
                }
                case '\f': {
                    this.write("\\f");
                    continue block10;
                }
                case '\r': {
                    this.write("\\r");
                    continue block10;
                }
                case '\"': {
                    this.write("\\\"");
                    continue block10;
                }
                case '\'': {
                    this.write("\\'");
                    continue block10;
                }
                case '\\': {
                    this.write("\\\\");
                    continue block10;
                }
                default: {
                    this.write(value.charAt(i));
                }
            }
        }
    }

    public Map<Integer, Integer> getLineNumberMapping() {
        return this.lineNumberMapping;
    }

    public String toString() {
        return this.sbf.toString();
    }

    public void snapshotLength() {
        this.lengths.addLast(this.toString().length());
    }

    public boolean hasNewContent() {
        return this.lengths.pollLast() < this.toString().length();
    }
}

