/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.chain;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtFunction;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryAware;
import spoon.reflect.visitor.chain.QueryFailurePolicy;
import spoon.reflect.visitor.filter.CtScannerFunction;

public class CtQueryImpl
implements CtQuery {
    private List<Object> inputs;
    private OutputFunctionWrapper outputStep = new OutputFunctionWrapper();
    private AbstractStep lastStep;
    private AbstractStep firstStep = this.lastStep = this.outputStep;
    private boolean terminated = false;
    private boolean logging = false;
    private QueryFailurePolicy failurePolicy = QueryFailurePolicy.FAIL;

    public CtQueryImpl(Object ... input) {
        this.setInput(input);
    }

    public List<Object> getInputs() {
        return this.inputs == null ? Collections.emptyList() : this.inputs;
    }

    public CtQueryImpl setInput(Object ... input) {
        if (this.inputs != null) {
            this.inputs.clear();
        }
        return this.addInput(input);
    }

    public CtQueryImpl addInput(Object ... input) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Object>();
        }
        if (input != null) {
            for (Object in : input) {
                this.inputs.add(in);
            }
        }
        return this;
    }

    @Override
    public <R> void forEach(CtConsumer<R> consumer) {
        this.outputStep.setNext(consumer);
        for (Object input : this.inputs) {
            this.firstStep.accept(input);
        }
    }

    @Override
    public <R> List<R> list() {
        return this.list(Object.class);
    }

    @Override
    public <R> List<R> list(final Class<R> itemClass) {
        final ArrayList list = new ArrayList();
        this.forEach(new CtConsumer<R>(){

            @Override
            public void accept(R out) {
                if (out != null && itemClass.isAssignableFrom(out.getClass())) {
                    list.add(out);
                }
            }
        });
        return list;
    }

    @Override
    public <R> R first() {
        return (R)this.first(Object.class);
    }

    @Override
    public <R> R first(final Class<R> itemClass) {
        final Object[] result = new Object[1];
        this.outputStep.setNext(new CtConsumer<R>(){

            @Override
            public void accept(R out) {
                if (out != null && itemClass.isAssignableFrom(out.getClass())) {
                    result[0] = out;
                    CtQueryImpl.this.terminate();
                }
            }
        });
        for (Object input : this.inputs) {
            this.firstStep.accept(input);
            if (!this.isTerminated()) continue;
            break;
        }
        return (R)result[0];
    }

    @Override
    public <I> CtQueryImpl map(CtConsumableFunction<I> code) {
        this.addStep(new LazyFunctionWrapper(code));
        return this;
    }

    @Override
    public <I, R> CtQueryImpl map(CtFunction<I, R> function) {
        this.addStep(new FunctionWrapper(function));
        return this;
    }

    @Override
    public <R extends CtElement> CtQueryImpl filterChildren(Filter<R> filter) {
        this.map((CtConsumableFunction)new CtScannerFunction());
        if (filter != null) {
            this.select((Filter)filter);
        }
        return this;
    }

    @Override
    public <R extends CtElement> CtQueryImpl select(final Filter<R> filter) {
        this.map(new CtFunction<R, Boolean>(){

            @Override
            public Boolean apply(R input) {
                return filter.matches(input);
            }
        });
        this.stepFailurePolicy(QueryFailurePolicy.IGNORE);
        return this;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }

    public <I, R> void evaluate(I input, CtConsumer<R> outputConsumer) {
        this.outputStep.setNext(outputConsumer);
        this.firstStep.accept(input);
    }

    @Override
    public CtQueryImpl name(String name) {
        this.lastStep.setName(name);
        return this;
    }

    @Override
    public CtQueryImpl failurePolicy(QueryFailurePolicy policy) {
        this.failurePolicy = policy;
        return this;
    }

    public CtQueryImpl stepFailurePolicy(QueryFailurePolicy policy) {
        this.lastStep.setLocalFailurePolicy(policy);
        return this;
    }

    public CtQueryImpl logging(boolean logging) {
        this.logging = logging;
        return this;
    }

    protected void handleListenerSetQuery(Object target) {
        if (target instanceof CtQueryAware) {
            ((CtQueryAware)target).setQuery(this);
        }
    }

    private void addStep(AbstractStep step) {
        step.nextStep = this.outputStep;
        this.lastStep.nextStep = step;
        this.lastStep = step;
        if (this.firstStep == this.outputStep) {
            this.firstStep = step;
        }
        step.setName(String.valueOf(this.getStepIndex(step) + 1));
    }

    private int getStepIndex(AbstractStep step) {
        int idx = 0;
        AbstractStep s = this.firstStep;
        while (s != this.outputStep) {
            if (s == step) {
                return idx;
            }
            s = (AbstractStep)s.nextStep;
            ++idx;
        }
        return -1;
    }

    private boolean isLogging() {
        return this.logging;
    }

    private void onClassCastException(AbstractStep step, ClassCastException e, Object ... parameters) {
        if (step.isFailOnCCE()) {
            throw new SpoonException(this.getStepDescription(step, e.getMessage(), parameters), e);
        }
        if (Launcher.LOGGER.isTraceEnabled()) {
            Launcher.LOGGER.trace((Object)e);
        }
        this.log(step, e.getMessage(), parameters);
    }

    private void log(AbstractStep step, String message, Object ... parameters) {
        if (this.isLogging() && Launcher.LOGGER.isInfoEnabled()) {
            Launcher.LOGGER.info((Object)this.getStepDescription(step, message, parameters));
        }
    }

    private String getStepDescription(AbstractStep step, String message, Object ... parameters) {
        StringBuilder sb = new StringBuilder("Step ");
        sb.append(step.getName()).append(") ");
        sb.append(message);
        for (int i = 0; i < parameters.length; ++i) {
            sb.append("\nParameter ").append(i + 1).append(") ");
            if (parameters[i] != null) {
                sb.append(parameters[i].getClass().getSimpleName());
                sb.append(": ");
            }
            sb.append(parameters[i]);
        }
        return sb.toString();
    }

    protected void reset() {
        this.terminated = false;
    }

    private class FunctionWrapper
    extends AbstractStep {
        private CtFunction<Object, Object> fnc;

        FunctionWrapper(CtFunction<?, ?> code) {
            this.fnc = code;
            CtQueryImpl.this.handleListenerSetQuery(this.fnc);
        }

        @Override
        public void accept(Object input) {
            Object result;
            if (input == null || CtQueryImpl.this.isTerminated()) {
                return;
            }
            try {
                result = this.fnc.apply(input);
            }
            catch (ClassCastException e) {
                CtQueryImpl.this.onClassCastException(this, e, new Object[]{input});
                return;
            }
            if (result == null || CtQueryImpl.this.isTerminated()) {
                return;
            }
            if (result instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    this.nextStep.accept(input);
                } else {
                    CtQueryImpl.this.log(this, "Skipped element, because CtFunction#accept(input) returned false", new Object[]{input});
                }
                return;
            }
            if (result instanceof Iterable) {
                for (Object out : (Iterable)result) {
                    this.nextStep.accept(out);
                    if (!CtQueryImpl.this.isTerminated()) continue;
                    return;
                }
                return;
            }
            if (result.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(result); ++i) {
                    this.nextStep.accept(Array.get(result, i));
                    if (!CtQueryImpl.this.isTerminated()) continue;
                    return;
                }
                return;
            }
            this.nextStep.accept(result);
        }
    }

    private class LazyFunctionWrapper
    extends AbstractStep {
        private final CtConsumableFunction<Object> fnc;

        LazyFunctionWrapper(CtConsumableFunction<?> fnc) {
            this.fnc = fnc;
            CtQueryImpl.this.handleListenerSetQuery(this.fnc);
        }

        @Override
        public void accept(Object input) {
            if (input == null || CtQueryImpl.this.isTerminated()) {
                return;
            }
            try {
                this.fnc.apply(input, this.nextStep);
            }
            catch (ClassCastException e) {
                CtQueryImpl.this.onClassCastException(this, e, new Object[]{input});
                return;
            }
        }
    }

    private class OutputFunctionWrapper
    extends AbstractStep {
        private OutputFunctionWrapper() {
        }

        @Override
        public void accept(Object element) {
            block3: {
                if (element == null || CtQueryImpl.this.isTerminated()) {
                    return;
                }
                try {
                    this.nextStep.accept(element);
                }
                catch (ClassCastException e) {
                    if (!Launcher.LOGGER.isTraceEnabled()) break block3;
                    Launcher.LOGGER.trace((Object)e);
                }
            }
        }

        <R> void setNext(CtConsumer<R> out) {
            CtQueryImpl.this.reset();
            this.nextStep = out;
            CtQueryImpl.this.handleListenerSetQuery(this.nextStep);
        }
    }

    private abstract class AbstractStep
    implements CtConsumer<Object> {
        String name;
        QueryFailurePolicy localFailurePolicy = null;
        CtConsumer<Object> nextStep;

        private AbstractStep() {
        }

        private String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        private boolean isFailOnCCE() {
            if (this.localFailurePolicy != null) {
                return this.localFailurePolicy == QueryFailurePolicy.FAIL;
            }
            return CtQueryImpl.this.failurePolicy == QueryFailurePolicy.FAIL;
        }

        private void setLocalFailurePolicy(QueryFailurePolicy localFailurePolicy) {
            this.localFailurePolicy = localFailurePolicy;
        }
    }
}

