/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;

public class TypeContext {
    CtType<?> type;
    CtTypeReference<?> typeRef;
    Set<String> memberNames;

    TypeContext(CtType<?> p_type) {
        this.type = p_type;
        this.typeRef = this.type.getReference();
    }

    public boolean isNameConflict(String name) {
        if (this.memberNames == null) {
            Collection<CtFieldReference<?>> allFields = this.type.getAllFields();
            this.memberNames = new HashSet<String>(allFields.size());
            for (CtFieldReference<?> field : allFields) {
                this.memberNames.add(field.getSimpleName());
            }
        }
        return this.memberNames.contains(name);
    }

    public String getSimpleName() {
        return this.typeRef.getSimpleName();
    }

    public CtPackageReference getPackage() {
        return this.typeRef.getPackage();
    }
}

