/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.ImportScanner;
import spoon.reflect.visitor.ImportScannerImpl;

public class MinimalImportScanner
extends ImportScannerImpl
implements ImportScanner {
    private boolean shouldTypeBeImported(CtReference ref) {
        if (ref.equals(this.targetType)) {
            return true;
        }
        return this.isTypeInCollision(ref, true);
    }

    @Override
    protected boolean addClassImport(CtTypeReference<?> ref) {
        boolean shouldTypeBeImported = this.shouldTypeBeImported(ref);
        if (shouldTypeBeImported) {
            return super.addClassImport(ref);
        }
        return false;
    }

    @Override
    protected boolean addFieldImport(CtFieldReference ref) {
        boolean shouldTypeBeImported = this.shouldTypeBeImported(ref);
        if (shouldTypeBeImported) {
            if (this.fieldImports.containsKey(ref.getSimpleName())) {
                return this.isImportedInFieldImports(ref);
            }
            this.fieldImports.put(ref.getSimpleName(), ref);
            return true;
        }
        return false;
    }

    @Override
    protected boolean addMethodImport(CtExecutableReference ref) {
        boolean shouldTypeBeImported = this.shouldTypeBeImported(ref);
        if (shouldTypeBeImported) {
            if (this.methodImports.containsKey(ref.getSimpleName())) {
                return this.isImportedInMethodImports(ref);
            }
            this.methodImports.put(ref.getSimpleName(), ref);
            if (ref.getDeclaringType() != null && ref.getDeclaringType().getPackage() != null && ref.getDeclaringType().getPackage().equals(this.targetType.getPackage())) {
                this.addClassImport(ref.getDeclaringType());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isImportedInClassImports(CtTypeReference<?> ref) {
        CtTypeReference exist;
        return !ref.isImplicit() && this.classImports.containsKey(ref.getSimpleName()) && (exist = (CtTypeReference)this.classImports.get(ref.getSimpleName())).getQualifiedName().equals(ref.getQualifiedName());
    }
}

