/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import spoon.compiler.Environment;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.ImportScanner;
import spoon.reflect.visitor.ImportScannerImpl;
import spoon.reflect.visitor.MinimalImportScanner;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.reflect.visitor.PrintingContext;
import spoon.reflect.visitor.TypeContext;
import spoon.reflect.visitor.filter.PotentialVariableDeclarationFunction;
import spoon.reflect.visitor.printer.CommentOffset;
import spoon.reflect.visitor.printer.ElementPrinterHelper;
import spoon.reflect.visitor.printer.PrinterHelper;

public class DefaultJavaPrettyPrinter
implements CtVisitor,
PrettyPrinter {
    public static final String JAVA_FILE_EXTENSION = ".java";
    public static final String JAVA_PACKAGE_DECLARATION = "package-info.java";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public PrintingContext context = new PrintingContext();
    private ImportScanner importsContext;
    private Environment env;
    private PrinterHelper printer;
    private ElementPrinterHelper elementPrinterHelper;
    private CompilationUnit sourceCompilationUnit;

    public DefaultJavaPrettyPrinter(Environment env) {
        this.env = env;
        this.printer = new PrinterHelper(env);
        this.elementPrinterHelper = new ElementPrinterHelper(this.printer, this, env);
        this.importsContext = env.isAutoImports() ? new ImportScannerImpl() : new MinimalImportScanner();
    }

    protected void enterCtExpression(CtExpression<?> e) {
        if (!(e instanceof CtStatement)) {
            this.elementPrinterHelper.writeComment(e, CommentOffset.BEFORE);
        }
        this.printer.mapLine(e, this.sourceCompilationUnit);
        if (this.shouldSetBracket(e)) {
            this.context.parenthesedExpression.push(e);
            this.printer.write("(");
        }
        if (!e.getTypeCasts().isEmpty()) {
            for (CtTypeReference<?> r : e.getTypeCasts()) {
                this.printer.write("(");
                this.scan(r);
                this.printer.write(") ");
                this.printer.write("(");
                this.context.parenthesedExpression.push(e);
            }
        }
    }

    protected void enterCtStatement(CtStatement s) {
        this.elementPrinterHelper.writeComment(s, CommentOffset.BEFORE);
        this.printer.mapLine(s, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeAnnotations(s);
        if (s.getLabel() != null) {
            this.printer.write(s.getLabel()).write(" : ");
        }
    }

    protected void exitCtExpression(CtExpression<?> e) {
        while (this.context.parenthesedExpression.size() > 0 && e == this.context.parenthesedExpression.peek()) {
            this.context.parenthesedExpression.pop();
            this.printer.write(")");
        }
        if (!(e instanceof CtStatement)) {
            this.elementPrinterHelper.writeComment(e, CommentOffset.AFTER);
        }
    }

    public Collection<CtReference> computeImports(CtType<?> type) {
        this.context.currentTopLevel = type;
        return this.importsContext.computeAllImports(this.context.currentTopLevel);
    }

    public void computeImports(CtElement element) {
        if (this.env.isAutoImports()) {
            this.importsContext.computeImports(element);
        }
    }

    public DefaultJavaPrettyPrinter scan(CtElement e) {
        if (e != null) {
            this.context.elementStack.push(e);
            if (this.env.isPreserveLineNumbers() && !(e instanceof CtNamedElement)) {
                this.printer.adjustPosition(e, this.sourceCompilationUnit);
            }
            e.accept(this);
            this.context.elementStack.pop();
        }
        return this;
    }

    public DefaultJavaPrettyPrinter scan(CtReference ref) {
        if (ref != null) {
            ref.accept(this);
        }
        return this;
    }

    private boolean shouldSetBracket(CtExpression<?> e) {
        if (e.getTypeCasts().size() != 0) {
            return true;
        }
        try {
            if (e.getParent() instanceof CtBinaryOperator || e.getParent() instanceof CtUnaryOperator) {
                return e instanceof CtTargetedExpression || e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtUnaryOperator || e instanceof CtBinaryOperator;
            }
            if (e.getParent() instanceof CtTargetedExpression) {
                return e instanceof CtBinaryOperator || e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtUnaryOperator;
            }
        }
        catch (ParentNotInitializedException parentNotInitializedException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return this.printer.toString();
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.elementPrinterHelper.writeAnnotations(annotation);
        this.printer.write("@");
        this.scan(annotation.getAnnotationType());
        if (annotation.getValues().size() > 0) {
            this.printer.write("(");
            for (Map.Entry<String, CtExpression> e : annotation.getValues().entrySet()) {
                this.printer.write(e.getKey() + " = ");
                this.elementPrinterHelper.writeAnnotationElement(annotation.getFactory(), e.getValue());
                this.printer.write(", ");
            }
            this.printer.removeLastChar();
            this.printer.write(")");
        }
        this.printer.writeln().writeTabs();
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.visitCtType(annotationType);
        this.printer.write("@interface " + annotationType.getSimpleName() + " {").incTab();
        this.elementPrinterHelper.writeElementList(annotationType.getTypeMembers());
        this.printer.decTab().writeTabs().write("}");
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable impl) {
        this.elementPrinterHelper.writeComment(impl);
        this.elementPrinterHelper.writeAnnotations(impl);
        this.elementPrinterHelper.writeModifiers(impl);
        this.scan(impl.getBody());
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        this.printCtArrayAccess(arrayRead);
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.printCtArrayAccess(arrayWrite);
    }

    private <T, E extends CtExpression<?>> void printCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.enterCtExpression(arrayAccess);
        this.scan((CtElement)arrayAccess.getTarget());
        this.printer.write("[");
        this.scan(arrayAccess.getIndexExpression());
        this.printer.write("]");
        this.exitCtExpression(arrayAccess);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        if (reference.isImplicit()) {
            return;
        }
        this.scan(reference.getComponentType());
        if (!this.context.skipArray()) {
            this.printer.write("[]");
        }
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.enterCtStatement(asserted);
        this.printer.write("assert ");
        this.scan(asserted.getAssertExpression());
        if (asserted.getExpression() != null) {
            this.printer.write(" : ");
            this.scan(asserted.getExpression());
        }
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.enterCtStatement(assignement);
        this.enterCtExpression(assignement);
        this.scan(assignement.getAssigned());
        this.printer.write(" = ");
        this.scan(assignement.getAssignment());
        this.exitCtExpression(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.enterCtExpression(operator);
        this.scan(operator.getLeftHandOperand());
        this.printer.write(" ").writeOperator(operator.getKind()).write(" ");
        this.scan(operator.getRightHandOperand());
        this.exitCtExpression(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.enterCtStatement(block);
        if (!block.isImplicit()) {
            this.printer.write("{");
        }
        this.printer.incTab();
        for (CtStatement statement : block.getStatements()) {
            if (statement.isImplicit()) continue;
            this.printer.writeln().writeTabs();
            this.elementPrinterHelper.writeStatement(statement);
        }
        this.printer.decTab();
        if (this.env.isPreserveLineNumbers()) {
            if (!block.isImplicit()) {
                this.printer.write("}");
            }
        } else {
            this.printer.writeln().writeTabs();
            if (!block.isImplicit()) {
                this.printer.write("}");
            }
        }
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.enterCtStatement(breakStatement);
        this.printer.write("break");
        if (breakStatement.getTargetLabel() != null) {
            this.printer.write(" " + breakStatement.getTargetLabel());
        }
    }

    public <E> void visitCtCase(CtCase<E> caseStatement) {
        this.enterCtStatement(caseStatement);
        if (caseStatement.getCaseExpression() != null) {
            this.printer.write("case ");
            if (caseStatement.getCaseExpression() instanceof CtFieldAccess) {
                CtFieldReference variable = ((CtFieldAccess)caseStatement.getCaseExpression()).getVariable();
                if (variable.getType() != null && variable.getDeclaringType() != null && variable.getType().getQualifiedName().equals(variable.getDeclaringType().getQualifiedName())) {
                    this.printer.write(variable.getSimpleName());
                } else {
                    this.scan(caseStatement.getCaseExpression());
                }
            } else {
                this.scan(caseStatement.getCaseExpression());
            }
        } else {
            this.printer.write("default");
        }
        this.printer.write(" :").incTab();
        for (CtStatement statement : caseStatement.getStatements()) {
            this.printer.writeln().writeTabs();
            this.elementPrinterHelper.writeStatement(statement);
        }
        this.printer.decTab();
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.elementPrinterHelper.writeComment(catchBlock, CommentOffset.BEFORE);
        this.printer.write(" catch (");
        CtCatchVariable<? extends Throwable> parameter = catchBlock.getParameter();
        if (parameter.getMultiTypes().size() > 0) {
            for (int i = 0; i < parameter.getMultiTypes().size(); ++i) {
                CtTypeReference<?> type = parameter.getMultiTypes().get(i);
                this.scan(type);
                if (i >= parameter.getMultiTypes().size() - 1) continue;
                this.printer.write(" | ");
            }
            this.printer.write(" " + parameter.getSimpleName());
        } else {
            this.scan(parameter);
        }
        this.printer.write(") ");
        this.scan(catchBlock.getBody());
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.context.pushCurrentThis(ctClass);
        if (ctClass.getSimpleName() != null && !"<unknown>".equals(ctClass.getSimpleName()) && !ctClass.isAnonymous()) {
            this.visitCtType(ctClass);
            if (ctClass.isLocalType()) {
                this.printer.write("class " + ctClass.getSimpleName().replaceAll("^[0-9]*", ""));
            } else {
                this.printer.write("class " + ctClass.getSimpleName());
            }
            this.elementPrinterHelper.writeFormalTypeParameters(ctClass);
            this.elementPrinterHelper.writeExtendsClause(ctClass);
            this.elementPrinterHelper.writeImplementsClause(ctClass);
        }
        this.printer.write(" {").incTab();
        this.elementPrinterHelper.writeElementList(ctClass.getTypeMembers());
        this.printer.decTab().writeTabs().write("}");
        this.context.popCurrentThis();
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.visitCtTypeParameterReference(typeParameter.getReference());
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        boolean parent;
        this.enterCtExpression(conditional);
        CtExpression<Boolean> condition = conditional.getCondition();
        try {
            parent = conditional.getParent() instanceof CtAssignment || conditional.getParent() instanceof CtVariable;
        }
        catch (ParentNotInitializedException ex) {
            parent = false;
        }
        if (parent) {
            this.printer.write("(");
        }
        this.scan(condition);
        if (parent) {
            this.printer.write(")");
        }
        this.printer.write(" ? ");
        CtExpression<T> thenExpression = conditional.getThenExpression();
        this.scan(thenExpression);
        this.printer.write(" : ");
        CtExpression<T> elseExpression = conditional.getElseExpression();
        boolean isAssign = false;
        isAssign = elseExpression instanceof CtAssignment;
        if (isAssign) {
            this.printer.write("(");
        }
        this.scan(elseExpression);
        if (isAssign) {
            this.printer.write(")");
        }
        this.exitCtExpression(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> constructor) {
        this.elementPrinterHelper.writeComment(constructor);
        this.elementPrinterHelper.visitCtNamedElement(constructor, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(constructor);
        this.elementPrinterHelper.writeFormalTypeParameters(constructor);
        if (constructor.getFormalCtTypeParameters().size() > 0) {
            this.printer.write(' ');
        }
        if (constructor.getDeclaringType().isLocalType()) {
            this.printer.write(constructor.getDeclaringType().getSimpleName().replaceAll("^[0-9]*", ""));
        } else {
            this.printer.write(constructor.getDeclaringType().getSimpleName());
        }
        this.elementPrinterHelper.writeExecutableParameters(constructor);
        this.elementPrinterHelper.writeThrowsClause(constructor);
        this.printer.write(" ");
        this.scan(constructor.getBody());
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.enterCtStatement(continueStatement);
        this.printer.write("continue");
        if (continueStatement.getTargetLabel() != null) {
            this.printer.write(" " + continueStatement.getTargetLabel());
        }
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.enterCtStatement(doLoop);
        this.printer.write("do");
        this.elementPrinterHelper.writeIfOrLoopBlock(doLoop.getBody());
        this.printer.write("while (");
        this.scan(doLoop.getLoopingExpression());
        this.printer.write(" )");
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.visitCtType(ctEnum);
        this.printer.write("enum " + ctEnum.getSimpleName());
        this.elementPrinterHelper.writeImplementsClause(ctEnum);
        this.context.pushCurrentThis(ctEnum);
        this.printer.write(" {").incTab().writeln();
        if (ctEnum.getEnumValues().size() == 0) {
            this.printer.writeTabs().write(";").writeln();
        } else {
            for (CtEnumValue<?> enumValue : ctEnum.getEnumValues()) {
                this.scan(enumValue);
                this.printer.write(", ");
            }
            this.printer.removeLastChar();
            this.printer.write(";");
        }
        this.elementPrinterHelper.writeElementList(ctEnum.getTypeMembers());
        this.printer.decTab().writeTabs().write("}");
        this.context.popCurrentThis();
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.printer.write(reference.getSignature());
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.elementPrinterHelper.writeComment(f);
        this.elementPrinterHelper.visitCtNamedElement(f, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(f);
        this.scan(f.getType());
        this.printer.write(" ");
        this.printer.write(f.getSimpleName());
        if (f.getDefaultExpression() != null) {
            this.printer.write(" = ");
            this.scan(f.getDefaultExpression());
        }
        this.printer.write(";");
    }

    @Override
    public <T> void visitCtEnumValue(CtEnumValue<T> enumValue) {
        this.elementPrinterHelper.visitCtNamedElement(enumValue, this.sourceCompilationUnit);
        this.printer.write(enumValue.getSimpleName());
        if (enumValue.getDefaultExpression() != null) {
            CtConstructorCall constructorCall = (CtConstructorCall)enumValue.getDefaultExpression();
            if (constructorCall.getArguments().size() > 0) {
                this.printer.write("(");
                boolean first = true;
                for (CtExpression<?> ctexpr : constructorCall.getArguments()) {
                    if (first) {
                        first = false;
                    } else {
                        this.printer.write(",");
                    }
                    this.scan(ctexpr);
                }
                this.printer.write(")");
            }
            if (constructorCall instanceof CtNewClass) {
                this.scan(((CtNewClass)constructorCall).getAnonymousClass());
            }
        }
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.printCtFieldAccess(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.printCtFieldAccess(fieldWrite);
    }

    private <T> void printCtFieldAccess(CtFieldAccess<T> f) {
        this.enterCtExpression(f);
        try (PrintingContext.Writable _context = this.context.modify();){
            Object target;
            if (f.getVariable().isStatic() && f.getTarget() instanceof CtTypeAccess) {
                _context.ignoreGenerics(true);
            }
            if ((target = f.getTarget()) != null) {
                boolean isInitializeStaticFinalField = this.isInitializeStaticFinalField((CtExpression<T>)f.getTarget());
                boolean isStaticField = f.getVariable().isStatic();
                boolean isImportedField = this.importsContext.isImported(f.getVariable());
                if (!(isInitializeStaticFinalField || isStaticField && isImportedField)) {
                    if (target.isImplicit()) {
                        CtField<T> field = f.getVariable().getFieldDeclaration();
                        String fieldName = field.getSimpleName();
                        CtVariable var = (CtVariable)f.getVariable().map(new PotentialVariableDeclarationFunction(fieldName)).first();
                        if (var != field) {
                            target.setImplicit(false);
                        }
                    }
                    this.printer.snapshotLength();
                    this.scan((CtElement)target);
                    if (this.printer.hasNewContent()) {
                        this.printer.write(".");
                    }
                }
                _context.ignoreStaticAccess(true);
            }
            this.scan(f.getVariable());
        }
        this.exitCtExpression(f);
    }

    private <T> boolean isInitializeStaticFinalField(CtExpression<T> targetExp) {
        CtAnonymousExecutable anonymousParent;
        CtElement parent;
        try {
            parent = targetExp.getParent();
            anonymousParent = targetExp.getParent(CtAnonymousExecutable.class);
        }
        catch (ParentNotInitializedException e) {
            return false;
        }
        return parent instanceof CtFieldWrite && targetExp.equals(((CtFieldWrite)parent).getTarget()) && anonymousParent != null && ((CtFieldWrite)parent).getVariable() != null && ((CtFieldWrite)parent).getVariable().getModifiers().contains((Object)ModifierKind.STATIC) && ((CtFieldWrite)parent).getVariable().getModifiers().contains((Object)ModifierKind.FINAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        try {
            String targetTypeQualifiedName;
            CtType<?> lastType;
            String lastTypeQualifiedName;
            this.enterCtExpression(thisAccess);
            CtTypeAccess target = (CtTypeAccess)thisAccess.getTarget();
            CtTypeReference targetType = target.getAccessedType();
            if (thisAccess.isImplicit()) {
                return;
            }
            if (targetType == null || thisAccess.getParent(CtType.class) != null && thisAccess.getParent(CtType.class).isTopLevel()) {
                this.printer.write("this");
                return;
            }
            if (targetType.isAnonymous()) {
                this.printer.write("this");
                return;
            }
            if (!this.context.currentThis.isEmpty() && !(lastTypeQualifiedName = (lastType = this.context.currentThis.peekFirst().type).getQualifiedName()).equals(targetTypeQualifiedName = targetType.getQualifiedName())) {
                this.printer.snapshotLength();
                this.visitCtTypeReferenceWithoutGenerics(targetType);
                if (this.printer.hasNewContent()) {
                    this.printer.write(".");
                }
                this.printer.write("this");
                return;
            }
            this.printer.write("this");
        }
        finally {
            this.exitCtExpression(thisAccess);
        }
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.enterCtExpression(f);
        if (f.getTarget() != null) {
            this.scan((CtElement)f.getTarget());
            this.printer.write(".");
        }
        this.printer.write("super");
        this.exitCtExpression(f);
    }

    @Override
    public void visitCtComment(CtComment comment) {
        if (!this.env.isCommentsEnabled() && this.context.elementStack.size() > 1) {
            return;
        }
        switch (comment.getCommentType()) {
            case FILE: {
                this.printer.write("/**").writeln();
                break;
            }
            case JAVADOC: {
                this.printer.write("/**").writeln().writeTabs();
                break;
            }
            case INLINE: {
                this.printer.write("// ");
                break;
            }
            case BLOCK: {
                this.printer.write("/* ");
            }
        }
        String content = comment.getContent();
        switch (comment.getCommentType()) {
            case INLINE: {
                this.printer.write(content);
                break;
            }
            default: {
                String[] lines = content.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    String com = lines[i];
                    if (comment.getCommentType() == CtComment.CommentType.BLOCK) {
                        this.printer.write(com);
                        if (lines.length <= 1) continue;
                        this.printer.writeln().writeTabs();
                        continue;
                    }
                    if (com.length() > 0) {
                        this.printer.write(" * " + com).writeln().writeTabs();
                        continue;
                    }
                    this.printer.write(" *" + com).writeln().writeTabs();
                }
            }
        }
        switch (comment.getCommentType()) {
            case BLOCK: {
                this.printer.write(" */");
                break;
            }
            case FILE: {
                this.printer.write(" */");
                break;
            }
            case JAVADOC: {
                this.printer.write(" */");
            }
        }
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        this.enterCtExpression(annotationFieldAccess);
        try (PrintingContext.Writable _context = this.context.modify();){
            if (annotationFieldAccess.getTarget() != null) {
                this.scan((CtElement)annotationFieldAccess.getTarget());
                this.printer.write(".");
                _context.ignoreStaticAccess(true);
            }
            _context.ignoreGenerics(true);
            this.scan(annotationFieldAccess.getVariable());
            this.printer.write("()");
        }
        this.exitCtExpression(annotationFieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        boolean isStatic = reference.getSimpleName().equals("class") || !reference.getSimpleName().equals("super") && reference.isStatic();
        boolean printType = true;
        if (reference.isFinal() && reference.isStatic()) {
            CtTypeReference<?> declTypeRef = reference.getDeclaringType();
            if (declTypeRef.isAnonymous()) {
                printType = false;
            } else if (this.context.isInCurrentScope(declTypeRef)) {
                printType = false;
            }
        }
        if (isStatic && printType && !this.context.ignoreStaticAccess()) {
            try (Object _context = this.context.modify().ignoreGenerics(true);){
                this.scan(reference.getDeclaringType());
            }
            this.printer.write(".");
        }
        this.printer.write(reference.getSimpleName());
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.enterCtStatement(forLoop);
        this.printer.write("for (");
        List<CtStatement> st = forLoop.getForInit();
        if (st.size() > 0) {
            this.scan(st.get(0));
        }
        if (st.size() > 1) {
            try (Object _context = this.context.modify().noTypeDecl(true);){
                for (int i = 1; i < st.size(); ++i) {
                    this.printer.write(", ");
                    this.scan(st.get(i));
                }
            }
        }
        this.printer.write("; ");
        this.scan(forLoop.getExpression());
        this.printer.write(";");
        if (!forLoop.getForUpdate().isEmpty()) {
            this.printer.write(" ");
        }
        for (CtStatement s : forLoop.getForUpdate()) {
            this.scan(s);
            this.printer.write(" , ");
        }
        if (forLoop.getForUpdate().size() > 0) {
            this.printer.removeLastChar();
        }
        this.printer.write(")");
        this.elementPrinterHelper.writeIfOrLoopBlock(forLoop.getBody());
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.enterCtStatement(foreach);
        this.printer.write("for (");
        this.scan(foreach.getVariable());
        this.printer.write(" : ");
        this.scan(foreach.getExpression());
        this.printer.write(")");
        this.elementPrinterHelper.writeIfOrLoopBlock(foreach.getBody());
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.enterCtStatement(ifElement);
        this.printer.write("if (");
        this.scan(ifElement.getCondition());
        this.printer.write(")");
        this.elementPrinterHelper.writeIfOrLoopBlock((CtStatement)ifElement.getThenStatement());
        if (ifElement.getElseStatement() != null) {
            List<CtComment> comments = this.elementPrinterHelper.getComments(ifElement, CommentOffset.INSIDE);
            for (CtComment comment : comments) {
                SourcePosition thenPosition;
                SourcePosition sourcePosition = thenPosition = ifElement.getThenStatement().getPosition() == null ? ((CtBlock)ifElement.getThenStatement()).getStatement(0).getPosition() : ifElement.getThenStatement().getPosition();
                if (comment.getPosition().getSourceStart() <= thenPosition.getSourceEnd()) continue;
                this.elementPrinterHelper.writeComment(comment);
            }
            this.printer.write("else");
            this.elementPrinterHelper.writeIfOrLoopBlock((CtStatement)ifElement.getElseStatement());
        }
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.visitCtType(intrface);
        this.printer.write("interface " + intrface.getSimpleName());
        if (intrface.getFormalCtTypeParameters() != null) {
            this.elementPrinterHelper.writeFormalTypeParameters(intrface);
        }
        if (intrface.getSuperInterfaces().size() > 0) {
            this.printer.write(" extends ");
            for (CtTypeReference<?> ref : intrface.getSuperInterfaces()) {
                this.scan(ref);
                this.printer.write(" , ");
            }
            this.printer.removeLastChar();
        }
        this.context.pushCurrentThis(intrface);
        this.printer.write(" {").incTab();
        this.elementPrinterHelper.writeElementList(intrface.getTypeMembers());
        this.printer.decTab().writeTabs().write("}");
        this.context.popCurrentThis();
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.enterCtStatement(invocation);
        this.enterCtExpression(invocation);
        if (invocation.getExecutable().isConstructor()) {
            CtType parentType;
            this.elementPrinterHelper.writeActualTypeArguments(invocation.getExecutable());
            try {
                parentType = invocation.getParent(CtType.class);
            }
            catch (ParentNotInitializedException e) {
                parentType = null;
            }
            if (parentType != null && parentType.getQualifiedName() != null && parentType.getQualifiedName().equals(invocation.getExecutable().getDeclaringType().getQualifiedName())) {
                this.printer.write("this");
            } else {
                this.printer.snapshotLength();
                this.scan((CtElement)invocation.getTarget());
                if (this.printer.hasNewContent()) {
                    this.printer.write(".");
                }
                this.printer.write("super");
            }
        } else {
            this.printer.snapshotLength();
            PrintingContext.Writable _context = this.context.modify();
            Object object = null;
            try {
                if (invocation.getTarget() instanceof CtTypeAccess) {
                    _context.ignoreGenerics(true);
                }
                this.scan((CtElement)invocation.getTarget());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (_context != null) {
                    if (object != null) {
                        try {
                            _context.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        _context.close();
                    }
                }
            }
            if (this.printer.hasNewContent()) {
                this.printer.write(".");
            }
            this.elementPrinterHelper.writeActualTypeArguments(invocation);
            if (this.env.isPreserveLineNumbers()) {
                this.printer.adjustPosition(invocation, this.sourceCompilationUnit);
            }
            this.printer.write(invocation.getExecutable().getSimpleName());
        }
        this.printer.write("(");
        boolean remove = false;
        for (CtExpression ctExpression : invocation.getArguments()) {
            this.scan(ctExpression);
            this.printer.write(", ");
            remove = true;
        }
        if (remove) {
            this.printer.removeLastChar();
        }
        this.printer.write(")");
        this.exitCtExpression(invocation);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.enterCtExpression(literal);
        if (literal.getValue() == null) {
            this.printer.write("null");
        } else if (literal.getValue() instanceof Long) {
            this.printer.write(literal.getValue() + "L");
        } else if (literal.getValue() instanceof Float) {
            this.printer.write(literal.getValue() + "F");
        } else if (literal.getValue() instanceof Character) {
            this.printer.write("'");
            boolean mayContainsSpecialCharacter = true;
            SourcePosition position = literal.getPosition();
            if (position != null) {
                int stringLength = position.getSourceEnd() - position.getSourceStart() - 1;
                mayContainsSpecialCharacter = stringLength != 1;
            }
            this.printer.writeStringLiteral(new String(new char[]{((Character)literal.getValue()).charValue()}), mayContainsSpecialCharacter);
            this.printer.write("'");
        } else if (literal.getValue() instanceof String) {
            this.printer.write('\"');
            boolean mayContainsSpecialCharacters = true;
            SourcePosition position = literal.getPosition();
            if (position != null) {
                int stringLength = position.getSourceEnd() - position.getSourceStart() - 1;
                mayContainsSpecialCharacters = ((String)literal.getValue()).length() != stringLength;
            }
            this.printer.writeStringLiteral((String)literal.getValue(), mayContainsSpecialCharacters);
            this.printer.write('\"');
        } else if (literal.getValue() instanceof Class) {
            this.printer.write(((Class)literal.getValue()).getName());
        } else {
            this.printer.write(literal.getValue().toString());
        }
        this.exitCtExpression(literal);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        if (!this.context.noTypeDecl()) {
            this.enterCtStatement(localVariable);
        }
        if (this.env.isPreserveLineNumbers()) {
            this.printer.adjustPosition(localVariable, this.sourceCompilationUnit);
        }
        if (!this.context.noTypeDecl()) {
            this.elementPrinterHelper.writeModifiers(localVariable);
            this.scan(localVariable.getType());
            this.printer.write(" ");
        }
        this.printer.write(localVariable.getSimpleName());
        if (localVariable.getDefaultExpression() != null) {
            this.printer.write(" = ");
            this.scan(localVariable.getDefaultExpression());
        }
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.printer.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        if (this.env.isPreserveLineNumbers()) {
            this.printer.adjustPosition(catchVariable, this.sourceCompilationUnit);
        }
        this.elementPrinterHelper.writeModifiers(catchVariable);
        this.scan(catchVariable.getType());
        this.printer.write(" ");
        this.printer.write(catchVariable.getSimpleName());
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        this.printer.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.elementPrinterHelper.writeComment(m);
        this.elementPrinterHelper.visitCtNamedElement(m, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(m);
        if (m.isDefaultMethod()) {
            this.printer.write("default ");
        }
        this.elementPrinterHelper.writeFormalTypeParameters(m);
        if (m.getFormalCtTypeParameters().size() > 0) {
            this.printer.write(' ');
        }
        try (Object _context = this.context.modify().ignoreGenerics(false);){
            this.scan(m.getType());
        }
        this.printer.write(" ");
        this.printer.write(m.getSimpleName());
        this.elementPrinterHelper.writeExecutableParameters(m);
        this.elementPrinterHelper.writeThrowsClause(m);
        if (m.getBody() != null) {
            this.printer.write(" ");
            this.scan(m.getBody());
            if (m.getBody().getPosition() != null) {
                if (m.getBody().getPosition().getCompilationUnit() == this.sourceCompilationUnit) {
                    if (m.getBody().getStatements().isEmpty() || !(m.getBody().getStatements().get(m.getBody().getStatements().size() - 1) instanceof CtReturn)) {
                        this.printer.putLineNumberMapping(m.getBody().getPosition().getEndLine());
                    }
                } else {
                    this.printer.undefineLine();
                }
            } else {
                this.printer.undefineLine();
            }
        } else {
            this.printer.write(";");
        }
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        this.elementPrinterHelper.writeComment(annotationMethod);
        this.elementPrinterHelper.visitCtNamedElement(annotationMethod, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(annotationMethod);
        this.scan(annotationMethod.getType());
        this.printer.write(" ");
        this.printer.write(annotationMethod.getSimpleName());
        this.printer.write("()");
        if (annotationMethod.getDefaultExpression() != null) {
            this.printer.write(" default ");
            this.scan(annotationMethod.getDefaultExpression());
        }
        this.printer.write(";");
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        CtExpression<Object> e;
        int i;
        boolean isNotInAnnotation;
        this.enterCtExpression(newArray);
        try {
            isNotInAnnotation = newArray.getParent(CtAnnotationType.class) == null && newArray.getParent(CtAnnotation.class) == null;
        }
        catch (ParentNotInitializedException e2) {
            isNotInAnnotation = true;
        }
        if (isNotInAnnotation) {
            CtTypeReference<Object> ref = newArray.getType();
            if (ref != null) {
                this.printer.write("new ");
            }
            try (Object _context = this.context.modify().skipArray(true);){
                this.scan(ref);
            }
            i = 0;
            while (ref instanceof CtArrayTypeReference) {
                this.printer.write("[");
                if (newArray.getDimensionExpressions().size() > i) {
                    e = newArray.getDimensionExpressions().get(i);
                    this.scan(e);
                }
                this.printer.write("]");
                ref = ((CtArrayTypeReference)ref).getComponentType();
                ++i;
            }
        }
        if (newArray.getDimensionExpressions().size() == 0) {
            this.printer.write("{ ");
            List<CtExpression<?>> l_elements = newArray.getElements();
            for (i = 0; i < l_elements.size(); ++i) {
                e = l_elements.get(i);
                this.scan(e);
                this.printer.write(" , ");
                if (i + 1 != l_elements.size()) continue;
                this.printer.removeLastChar();
                List<CtComment> comments = this.elementPrinterHelper.getComments(e, CommentOffset.AFTER);
                if (comments.isEmpty() || comments.get(comments.size() - 1).getCommentType() != CtComment.CommentType.INLINE) continue;
                this.printer.insertLine();
            }
            this.elementPrinterHelper.writeComment(newArray, CommentOffset.INSIDE);
            this.printer.write(" }");
        }
        this.elementPrinterHelper.writeComment(newArray, CommentOffset.AFTER);
        this.exitCtExpression(newArray);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.enterCtStatement(ctConstructorCall);
        this.enterCtExpression(ctConstructorCall);
        this.printConstructorCall(ctConstructorCall);
        this.exitCtExpression(ctConstructorCall);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.enterCtStatement(newClass);
        this.enterCtExpression(newClass);
        this.printConstructorCall(newClass);
        this.scan(newClass.getAnonymousClass());
        this.exitCtExpression(newClass);
    }

    private <T> void printConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        Throwable throwable = null;
        try (PrintingContext.Writable _context = this.context.modify();){
            if (ctConstructorCall.getTarget() != null) {
                this.scan((CtElement)ctConstructorCall.getTarget());
                this.printer.write(".");
                _context.ignoreEnclosingClass(true);
            }
            if (this.hasDeclaringTypeWithGenerics(ctConstructorCall.getType())) {
                _context.ignoreEnclosingClass(true);
            }
            this.printer.write("new ");
            if (ctConstructorCall.getActualTypeArguments().size() > 0) {
                this.elementPrinterHelper.writeActualTypeArguments(ctConstructorCall);
            }
            this.scan(ctConstructorCall.getType());
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        this.printer.write("(");
        for (CtCodeElement ctCodeElement : ctConstructorCall.getArguments()) {
            this.scan(ctCodeElement);
            this.printer.write(", ");
        }
        if (ctConstructorCall.getArguments().size() > 0) {
            this.printer.removeLastChar();
        }
        this.printer.write(")");
    }

    private <T> boolean hasDeclaringTypeWithGenerics(CtTypeReference<T> reference) {
        if (reference == null) {
            return false;
        }
        if (reference.getDeclaringType() == null) {
            return false;
        }
        if (reference.isLocalType()) {
            return false;
        }
        if (reference.getDeclaringType().getActualTypeArguments().size() != 0) {
            return true;
        }
        return this.hasDeclaringTypeWithGenerics(reference.getDeclaringType());
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.enterCtExpression(lambda);
        this.printer.write("(");
        if (lambda.getParameters().size() > 0) {
            for (CtParameter<?> parameter : lambda.getParameters()) {
                this.scan(parameter);
                this.printer.write(",");
            }
            this.printer.removeLastChar();
        }
        this.printer.write(") -> ");
        if (lambda.getBody() != null) {
            this.scan(lambda.getBody());
        } else {
            this.scan(lambda.getExpression());
        }
        this.exitCtExpression(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.enterCtExpression(expression);
        this.scan((CtElement)expression.getTarget());
        this.printer.write("::");
        if (expression.getExecutable().isConstructor()) {
            this.printer.write("new");
        } else {
            this.printer.write(expression.getExecutable().getSimpleName());
        }
        this.exitCtExpression(expression);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.enterCtStatement(assignment);
        this.enterCtExpression(assignment);
        this.scan(assignment.getAssigned());
        this.printer.write(" ");
        this.printer.writeOperator(assignment.getKind());
        this.printer.write("= ");
        this.scan(assignment.getAssignment());
        this.exitCtExpression(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        if (!ctPackage.isUnnamedPackage()) {
            this.printer.write("package " + ctPackage.getQualifiedName() + ";");
        } else {
            this.printer.write("// default package (CtPackage.TOP_LEVEL_PACKAGE_NAME in Spoon= unnamed package)\n");
        }
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.printer.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.elementPrinterHelper.writeComment(parameter);
        this.elementPrinterHelper.writeAnnotations(parameter);
        this.elementPrinterHelper.writeModifiers(parameter);
        if (parameter.isVarArgs()) {
            this.scan(((CtArrayTypeReference)parameter.getType()).getComponentType());
            this.printer.write("...");
        } else {
            this.scan(parameter.getType());
        }
        this.printer.write(" ");
        this.printer.write(parameter.getSimpleName());
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.printer.write(reference.getSimpleName());
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.enterCtStatement(returnStatement);
        this.printer.write("return ");
        this.scan(returnStatement.getReturnedExpression());
    }

    private <T> void visitCtType(CtType<T> type) {
        this.elementPrinterHelper.writeComment(type, CommentOffset.BEFORE);
        this.printer.mapLine(type, this.sourceCompilationUnit);
        if (type.isTopLevel()) {
            this.context.currentTopLevel = type;
        }
        this.elementPrinterHelper.visitCtNamedElement(type, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(type);
    }

    @Override
    public void visitCtStatementList(CtStatementList statements) {
        for (CtStatement s : statements.getStatements()) {
            this.scan(s);
        }
    }

    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        this.enterCtStatement(switchStatement);
        this.printer.write("switch (");
        this.scan(switchStatement.getSelector());
        this.printer.write(") {").incTab();
        for (CtCase<E> c : switchStatement.getCases()) {
            this.printer.writeln().writeTabs();
            this.scan(c);
        }
        if (this.env.isPreserveLineNumbers()) {
            this.printer.decTab().write("}");
        } else {
            this.printer.decTab().writeln().writeTabs().write("}");
        }
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.enterCtStatement(synchro);
        this.printer.write("synchronized");
        if (synchro.getExpression() != null) {
            this.printer.write("(");
            this.scan(synchro.getExpression());
            this.printer.write(") ");
        }
        this.scan(synchro.getBlock());
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.enterCtStatement(throwStatement);
        this.printer.write("throw ");
        this.scan(throwStatement.getThrownExpression());
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.enterCtStatement(tryBlock);
        this.printer.write("try ");
        this.scan(tryBlock.getBody());
        for (CtCatch c : tryBlock.getCatchers()) {
            this.scan(c);
        }
        if (tryBlock.getFinalizer() != null) {
            this.printer.write(" finally ");
            this.scan(tryBlock.getFinalizer());
        }
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.enterCtStatement(tryWithResource);
        this.printer.write("try ");
        if (tryWithResource.getResources() != null && !tryWithResource.getResources().isEmpty()) {
            this.printer.write("(");
            for (CtLocalVariable ctLocalVariable : tryWithResource.getResources()) {
                this.scan(ctLocalVariable);
                this.printer.write(";");
            }
            this.printer.removeLastChar();
            this.printer.write(") ");
        }
        this.scan(tryWithResource.getBody());
        for (CtCatch ctCatch : tryWithResource.getCatchers()) {
            this.scan(ctCatch);
        }
        if (tryWithResource.getFinalizer() != null) {
            this.printer.write(" finally ");
            this.scan(tryWithResource.getFinalizer());
        }
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        if (ref.isImplicit()) {
            return;
        }
        this.elementPrinterHelper.writeAnnotations(ref);
        if (this.printQualified(ref)) {
            this.printer.write(ref.getQualifiedName());
        } else {
            this.printer.write(ref.getSimpleName());
        }
        if (ref.getBoundingType() != null) {
            if (ref.isUpper()) {
                this.printer.write(" extends ");
            } else {
                this.printer.write(" super ");
            }
            this.scan(ref.getBoundingType());
        }
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference wildcardReference) {
        this.visitCtTypeParameterReference(wildcardReference);
    }

    private boolean printQualified(CtTypeReference<?> ref) {
        if (this.importsContext.isImported(ref) || this.env.isAutoImports() && ref.getPackage() != null && ref.getPackage().getSimpleName().equals("java.lang")) {
            for (TypeContext typeContext : this.context.currentThis) {
                if (typeContext.getSimpleName().equals(ref.getSimpleName()) && !Objects.equals(typeContext.getPackage(), ref.getPackage())) {
                    return true;
                }
                if (!typeContext.isNameConflict(ref.getSimpleName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        for (CtTypeReference<?> bound : reference.getBounds()) {
            this.scan(bound);
            this.printer.write(" & ");
        }
        this.printer.removeLastChar();
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> ref) {
        this.visitCtTypeReference(ref, true);
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        if (typeAccess.isImplicit()) {
            return;
        }
        this.enterCtExpression(typeAccess);
        this.scan(typeAccess.getAccessedType());
        this.exitCtExpression(typeAccess);
    }

    private void visitCtTypeReferenceWithoutGenerics(CtTypeReference<?> ref) {
        this.visitCtTypeReference(ref, false);
    }

    private void visitCtTypeReference(CtTypeReference<?> ref, boolean withGenerics) {
        boolean isInner;
        if (ref.isImplicit()) {
            return;
        }
        if (ref.isPrimitive()) {
            this.elementPrinterHelper.writeAnnotations(ref);
            this.printer.write(ref.getSimpleName());
            return;
        }
        boolean bl = isInner = ref.getDeclaringType() != null;
        if (isInner) {
            CtTypeReference<?> accessType;
            if (!(this.context.ignoreEnclosingClass() || ref.isLocalType() || (accessType = ref.getAccessType()).isAnonymous())) {
                try (PrintingContext.Writable _context = this.context.modify();){
                    if (!withGenerics) {
                        _context.ignoreGenerics(true);
                    }
                    this.scan(accessType);
                }
                this.printer.write(".");
            }
            this.elementPrinterHelper.writeAnnotations(ref);
            if (ref.isLocalType()) {
                this.printer.write(ref.getSimpleName().replaceAll("^[0-9]*", ""));
            } else {
                this.printer.write(ref.getSimpleName());
            }
        } else {
            if (ref.getPackage() != null && this.printQualified(ref) && !ref.getPackage().isUnnamedPackage()) {
                this.scan(ref.getPackage());
                this.printer.write(".");
            }
            this.elementPrinterHelper.writeAnnotations(ref);
            this.printer.write(ref.getSimpleName());
        }
        if (withGenerics && !this.context.ignoreGenerics()) {
            try (Object _context = this.context.modify().ignoreEnclosingClass(false);){
                this.elementPrinterHelper.writeActualTypeArguments(ref);
            }
        }
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.enterCtStatement(operator);
        this.enterCtExpression(operator);
        this.printer.preWriteUnaryOperator(operator.getKind());
        this.scan(operator.getOperand());
        this.printer.postWriteUnaryOperator(operator.getKind());
        this.exitCtExpression(operator);
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.enterCtExpression(variableRead);
        this.printer.write(variableRead.getVariable().getSimpleName());
        this.exitCtExpression(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.enterCtExpression(variableWrite);
        this.printer.write(variableWrite.getVariable().getSimpleName());
        this.exitCtExpression(variableWrite);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.enterCtStatement(whileLoop);
        this.printer.write("while (");
        this.scan(whileLoop.getLoopingExpression());
        this.printer.write(")");
        this.elementPrinterHelper.writeIfOrLoopBlock(whileLoop.getBody());
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.elementPrinterHelper.writeComment(expression);
        this.printer.write(expression.getValue());
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.elementPrinterHelper.writeComment(statement);
        this.printer.write(statement.getValue());
    }

    public ElementPrinterHelper getElementPrinterHelper() {
        return this.elementPrinterHelper;
    }

    public PrintingContext getContext() {
        return this.context;
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        this.printer.write(reference.getSimpleName());
    }

    @Override
    public String getPackageDeclaration() {
        return this.printPackageInfo(this.context.currentTopLevel.getPackage());
    }

    @Override
    public String printPackageInfo(CtPackage pack) {
        PrinterHelper bck = this.printer;
        ElementPrinterHelper bck2 = this.elementPrinterHelper;
        this.printer = new PrinterHelper(this.env);
        this.elementPrinterHelper = new ElementPrinterHelper(this.printer, this, this.env);
        this.elementPrinterHelper.writeComment(pack);
        for (CtAnnotation<? extends Annotation> a : pack.getAnnotations()) {
            a.accept(this);
        }
        if (!pack.isUnnamedPackage()) {
            this.printer.write("package " + pack.getQualifiedName() + ";");
        }
        String ret = this.printer.toString();
        this.elementPrinterHelper = bck2;
        this.printer = bck;
        return ret;
    }

    @Override
    public String getResult() {
        return this.printer.toString();
    }

    @Override
    public void reset() {
        this.printer = new PrinterHelper(this.env);
        this.elementPrinterHelper.setPrinter(this.printer);
        this.context = new PrintingContext();
    }

    @Override
    public void calculate(CompilationUnit sourceCompilationUnit, List<CtType<?>> types) {
        this.sourceCompilationUnit = sourceCompilationUnit;
        this.importsContext = this.env.isAutoImports() ? new ImportScannerImpl() : new MinimalImportScanner();
        HashSet<CtReference> imports = new HashSet<CtReference>();
        for (CtType<?> t : types) {
            imports.addAll(this.computeImports(t));
        }
        this.elementPrinterHelper.writeHeader(types, imports);
        for (CtType<?> t : types) {
            this.scan(t);
            this.printer.writeln().writeln().writeTabs();
        }
    }

    @Override
    public Map<Integer, Integer> getLineNumberMapping() {
        return this.printer.getLineNumberMapping();
    }
}

