/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtAbstractVisitor;

public abstract class CtAbstractBiScanner
extends CtAbstractVisitor {
    protected Deque<CtElement> stack = new ArrayDeque<CtElement>();
    protected boolean isNotEqual = false;

    protected void enter(CtElement e) {
    }

    protected void exit(CtElement e) {
    }

    public boolean biScan(Collection<? extends CtElement> elements, Collection<? extends CtElement> others) {
        if (this.isNotEqual) {
            return this.isNotEqual;
        }
        if (elements == null) {
            if (others != null) {
                return this.fail();
            }
            return this.isNotEqual;
        }
        if (others == null) {
            return this.fail();
        }
        if (elements.size() != others.size()) {
            return this.fail();
        }
        Iterator<? extends CtElement> firstIt = elements.iterator();
        Iterator<? extends CtElement> secondIt = others.iterator();
        while (firstIt.hasNext() && secondIt.hasNext()) {
            this.biScan(firstIt.next(), secondIt.next());
        }
        return this.isNotEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean biScan(CtElement element, CtElement other) {
        if (this.isNotEqual) {
            return this.isNotEqual;
        }
        if (element == null) {
            if (other != null) {
                return this.fail();
            }
            return this.isNotEqual;
        }
        if (other == null) {
            return this.fail();
        }
        if (element == other) {
            return this.isNotEqual;
        }
        this.stack.push(other);
        try {
            element.accept(this);
        }
        catch (ClassCastException e) {
            boolean bl = this.fail();
            return bl;
        }
        finally {
            this.stack.pop();
        }
        return this.isNotEqual;
    }

    public boolean fail() {
        this.isNotEqual = true;
        return true;
    }
}

