/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path.impl;

import java.util.Collection;
import java.util.LinkedList;
import spoon.reflect.code.CtIf;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.path.CtPathRole;
import spoon.reflect.path.impl.AbstractPathElement;
import spoon.reflect.visitor.CtInheritanceScanner;

public class CtRolePathElement
extends AbstractPathElement<CtElement, CtElement> {
    public static final String STRING = "#";
    private final CtPathRole role;

    public CtRolePathElement(CtPathRole role) {
        this.role = role;
    }

    public CtPathRole getRole() {
        return this.role;
    }

    public String toString() {
        return STRING + this.role.toString() + this.getParamString();
    }

    @Override
    public Collection<CtElement> getElements(Collection<CtElement> roots) {
        RoleVisitor visitor = new RoleVisitor();
        visitor.scan(roots);
        return visitor.matchs;
    }

    private class RoleVisitor
    extends CtInheritanceScanner {
        private Collection<CtElement> matchs = new LinkedList<CtElement>();

        private RoleVisitor() {
        }

        @Override
        public <R> void scanCtExecutable(CtExecutable<R> e) {
            super.scanCtExecutable(e);
            switch (CtRolePathElement.this.role) {
                case BODY: {
                    if (e.getBody() == null) break;
                    if (CtRolePathElement.this.getArguments().containsKey("index") && e.getBody().getStatements().size() > Integer.parseInt(CtRolePathElement.this.getArguments().get("index"))) {
                        this.matchs.add(e.getBody().getStatements().get(Integer.parseInt(CtRolePathElement.this.getArguments().get("index"))));
                        break;
                    }
                    this.matchs.addAll(e.getBody().getStatements());
                }
            }
        }

        @Override
        public <T> void visitCtField(CtField<T> e) {
            super.visitCtField(e);
            if (CtRolePathElement.this.role == CtPathRole.DEFAULT_VALUE && e.getDefaultExpression() != null) {
                this.matchs.add(e.getDefaultExpression());
            }
        }

        @Override
        public void visitCtIf(CtIf e) {
            super.visitCtIf(e);
            switch (CtRolePathElement.this.role) {
                case THEN: {
                    if (e.getThenStatement() != null) {
                        this.matchs.add((CtElement)e.getThenStatement());
                    }
                }
                case ELSE: {
                    if (e.getElseStatement() == null) break;
                    this.matchs.add((CtElement)e.getElseStatement());
                }
            }
        }
    }
}

