/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtPackageReference;

public class PackageFactory
extends SubFactory
implements Serializable {
    private static final long serialVersionUID = 1L;

    public PackageFactory(Factory factory) {
        super(factory);
    }

    public CtPackageReference createReference(CtPackage pack) {
        if (pack == null) {
            throw new IllegalArgumentException();
        }
        return this.createReference(pack.getQualifiedName());
    }

    public CtPackageReference createReference(Package pack) {
        return this.createReference(pack.getName());
    }

    public CtPackageReference topLevel() {
        return this.factory.getModel().getRootPackage().getReference();
    }

    public CtPackageReference createReference(String name) {
        CtPackageReference ref = this.factory.Core().createPackageReference();
        ref.setSimpleName(name);
        return ref;
    }

    public CtPackage create(CtPackage parent, String simpleName) {
        return this.getOrCreate(parent.toString() + "." + simpleName);
    }

    public CtPackage getOrCreate(String qualifiedName) {
        if (qualifiedName.isEmpty()) {
            return this.factory.getModel().getRootPackage();
        }
        StringTokenizer token = new StringTokenizer(qualifiedName, ".");
        CtPackage last = this.factory.getModel().getRootPackage();
        while (token.hasMoreElements()) {
            String name = token.nextToken();
            CtPackage next = last.getPackage(name);
            if (next == null) {
                next = this.factory.Core().createPackage();
                next.setSimpleName(name);
                last.addPackage(next);
            }
            last = next;
        }
        return last;
    }

    public CtPackage get(String qualifiedName) {
        if (qualifiedName.contains("$")) {
            throw new RuntimeException("Invalid package name " + qualifiedName);
        }
        StringTokenizer token = new StringTokenizer(qualifiedName, ".");
        CtPackage current = this.factory.getModel().getRootPackage();
        if (token.hasMoreElements()) {
            for (current = current.getPackage(token.nextToken()); token.hasMoreElements() && current != null; current = current.getPackage(token.nextToken())) {
            }
        }
        return current;
    }

    public Collection<CtPackage> getAll() {
        return this.factory.getModel().getAllPackages();
    }

    public CtPackage getRootPackage() {
        return this.factory.getModel().getRootPackage();
    }

    private List<CtPackage> getSubPackageList(CtPackage pack) {
        ArrayList<CtPackage> packs = new ArrayList<CtPackage>();
        packs.add(pack);
        for (CtPackage p : pack.getPackages()) {
            packs.addAll(this.getSubPackageList(p));
        }
        return packs;
    }
}

