/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.ExecutableFactory;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class ConstructorFactory
extends ExecutableFactory {
    public ConstructorFactory(Factory factory) {
        super(factory);
    }

    public <T> CtConstructor<T> create(CtClass<T> target, CtConstructor<?> source) {
        CtConstructor<?> newConstructor = source.clone();
        target.addConstructor(newConstructor);
        return newConstructor;
    }

    public <T> CtConstructor<T> create(CtClass<T> target, CtMethod<?> source) {
        CtMethod<?> method = source.clone();
        CtConstructor newConstructor = this.factory.Core().createConstructor();
        newConstructor.setAnnotations(method.getAnnotations());
        newConstructor.setBody(method.getBody());
        newConstructor.setDocComment(method.getDocComment());
        newConstructor.setFormalCtTypeParameters(method.getFormalCtTypeParameters());
        newConstructor.setModifiers(method.getModifiers());
        newConstructor.setParameters(method.getParameters());
        target.addConstructor(newConstructor);
        return newConstructor;
    }

    public <T> CtConstructor<T> create(CtClass<T> target, Set<ModifierKind> modifiers, List<CtParameter<?>> parameters, Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        CtConstructor constructor = this.factory.Core().createConstructor();
        constructor.setModifiers(modifiers);
        constructor.setParameters(parameters);
        constructor.setThrownTypes(thrownTypes);
        target.addConstructor(constructor);
        return constructor;
    }

    public <T> CtConstructor<T> createDefault(CtClass<T> target) {
        CtConstructor constructor = this.factory.Core().createConstructor();
        constructor.addModifier(ModifierKind.PUBLIC);
        target.addConstructor(constructor);
        return constructor;
    }

    public <T> CtConstructor<T> create(CtClass<T> target, Set<ModifierKind> modifiers, List<CtParameter<?>> parameters, Set<CtTypeReference<? extends Throwable>> thrownTypes, CtBlock<T> body) {
        CtConstructor<T> constructor = this.create(target, modifiers, parameters, thrownTypes);
        constructor.setBody(body);
        return constructor;
    }

    public <T> CtExecutableReference<T> createReference(CtConstructor<T> c) {
        return this.factory.Executable().createReference(c);
    }

    public <T> CtExecutableReference<T> createReference(Constructor<T> constructor) {
        CtTypeReference<T> type = this.factory.Type().createReference(constructor.getDeclaringClass());
        return this.createReference(type, type.clone(), "<init>", this.factory.Type().createReferences(Arrays.asList(constructor.getParameterTypes())));
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<T> type, CtExpression<?> ... parameters) {
        CtExecutableReference<T> executableReference = this.factory.Core().createExecutableReference();
        executableReference.setType(type);
        executableReference.setDeclaringType(type == null ? null : type.clone());
        executableReference.setSimpleName("<init>");
        ArrayList typeReferences = new ArrayList();
        for (CtExpression<?> parameter : parameters) {
            typeReferences.add(parameter.getType() == null ? null : parameter.getType().clone());
        }
        executableReference.setParameters(typeReferences);
        return executableReference;
    }
}

