/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.support.compiler.jdt.JDTSnippetCompiler;

public class CompilationUnitFactory
extends SubFactory {
    private transient Map<String, CompilationUnit> cachedCompilationUnits = new TreeMap<String, CompilationUnit>();

    public CompilationUnitFactory(Factory factory) {
        super(factory);
    }

    public Map<String, CompilationUnit> getMap() {
        return this.cachedCompilationUnits;
    }

    public CompilationUnit create() {
        CompilationUnit cu = this.factory.Core().createCompilationUnit();
        return cu;
    }

    public CompilationUnit create(String filePath) {
        CompilationUnit cu = this.cachedCompilationUnits.get(filePath);
        if (cu == null) {
            if (filePath.startsWith(JDTSnippetCompiler.SNIPPET_FILENAME_PREFIX)) {
                cu = this.factory.Core().createCompilationUnit();
                this.cachedCompilationUnits.put(filePath, cu);
                return cu;
            }
            cu = this.factory.Core().createCompilationUnit();
            cu.setFile(new File(filePath));
            this.cachedCompilationUnits.put(filePath, cu);
        }
        return cu;
    }

    public CompilationUnit removeFromCache(String filePath) {
        return this.cachedCompilationUnits.remove(filePath);
    }
}

