/*
 * Decompiled with CFR 0.152.
 */
package spoon.generating;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.processing.AbstractManualProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.OverridingMethodFilter;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.comparator.CtLineElementComparator;
import spoon.support.visitor.clone.CloneBuilder;

public class CloneVisitorGenerator
extends AbstractManualProcessor {
    private static final String TARGET_CLONE_PACKAGE = "spoon.support.visitor.clone";
    private static final String TARGET_CLONE_TYPE = "CloneVisitor";
    private static final String TARGET_BUILDER_CLONE_TYPE = "CloneBuilder";
    private static final String GENERATING_CLONE_PACKAGE = "spoon.generating.clone";
    private static final String GENERATING_CLONE = "spoon.generating.clone.CloneVisitorTemplate";
    private static final String GENERATING_BUILDER_CLONE = "spoon.generating.clone.CloneBuilderTemplate";

    @Override
    public void process() {
        final CtClass<Object> target = this.createCloneVisitor();
        final CtClass<Object> targetBuilder = this.createCloneBuilder();
        final Factory factory = target.getFactory();
        CtTypeReference cloneBuilder = factory.Type().createReference("spoon.support.visitor.clone.CloneBuilder");
        final CtTypeAccess cloneBuilderType = factory.Code().createTypeAccess(cloneBuilder);
        final CtVariableAccess builderFieldAccess = factory.Code().createVariableRead(factory.Field().createReference(target.getReference(), cloneBuilder, "builder"), false);
        final CtFieldReference<?> other = factory.Field().createReference(target.getField("other"));
        final CtVariableAccess<?> otherRead = factory.Code().createVariableRead(other, true);
        new CtScanner(){
            private final List<String> internals = Collections.singletonList("CtCircularTypeReference");

            @Override
            public <T> void visitCtMethod(CtMethod<T> element) {
                if (!element.getSimpleName().startsWith("visitCt")) {
                    return;
                }
                CtMethod<T> clone = element.clone();
                CtParameter<?> ctParameter = element.getParameters().get(0);
                CtVariableAccess<CtElement> elementVarRead = factory.Code().createVariableRead(ctParameter.getReference(), false);
                CtInvocation<CloneBuilder> cloneBuilderInvocation = this.createCloneBuilderInvocation(elementVarRead);
                CtLocalVariable<CloneBuilder> localCloningElement = this.createLocalCloningElement(ctParameter.getType(), cloneBuilderInvocation);
                for (int i = 1; i < clone.getBody().getStatements().size() - 1; ++i) {
                    CtInvocation targetInvocation = (CtInvocation)((CtInvocation)clone.getBody().getStatement(i)).getArguments().get(0);
                    if ("getValue".equals(targetInvocation.getExecutable().getSimpleName()) && "CtLiteral".equals(targetInvocation.getExecutable().getDeclaringType().getSimpleName())) {
                        clone.getBody().getStatement(i--).delete();
                        continue;
                    }
                    clone.getBody().getStatement(i).replace(this.createSetter((CtInvocation)clone.getBody().getStatement(i), factory.Code().createVariableRead(localCloningElement.getReference(), false)));
                }
                clone.getBody().getStatement(0).delete();
                clone.getBody().getStatement(clone.getBody().getStatements().size() - 1).delete();
                clone.getBody().insertBegin(localCloningElement);
                clone.getBody().insertEnd(this.createAssignment(factory.Code().createVariableRead(localCloningElement.getReference(), false)));
                CtComment comment = factory.Core().createComment();
                comment.setCommentType(CtComment.CommentType.INLINE);
                comment.setContent("auto-generated, see " + CloneVisitorGenerator.class.getName());
                clone.addComment(comment);
                target.addMethod(clone);
            }

            private CtInvocation<?> createSetter(CtInvocation scanInvocation, CtVariableAccess<CtElement> elementVarRead) {
                CtInvocation getter = (CtInvocation)scanInvocation.getArguments().get(0);
                String getterName = getter.getExecutable().getSimpleName();
                CtExecutableReference setterRef = factory.Executable().createReference("void CtElement#set" + getterName.substring(3, getterName.length()) + "()");
                CtExecutableReference cloneRef = factory.Executable().createReference("CtElement spoon.support.visitor.equals.CloneHelper#clone()");
                CtInvocation cloneInv = factory.Code().createInvocation(null, cloneRef, getter);
                cloneInv.setTarget(factory.Code().createTypeAccess(factory.Type().createReference("spoon.support.visitor.equals.CloneHelper")));
                return factory.Code().createInvocation(elementVarRead, setterRef, cloneInv);
            }

            private CtAssignment createAssignment(CtVariableAccess assignment) {
                return factory.Code().createVariableAssignment(other, false, assignment);
            }

            private <T> CtLocalVariable<T> createLocalCloningElement(CtTypeReference<T> typeReference, CtInvocation<T> ctInvocation) {
                return factory.Code().createLocalVariable(typeReference, "a" + typeReference.getSimpleName(), ctInvocation);
            }

            private CtInvocation<CloneBuilder> createCloneBuilderInvocation(CtVariableAccess<CtElement> elementAccess) {
                CtExecutableReference buildExecRef = factory.Executable().createReference("CloneBuilder CtElement#build()");
                return factory.Code().createInvocation(cloneBuilderType, buildExecRef, builderFieldAccess, elementAccess, this.createFactoryInvocation(elementAccess.clone()));
            }

            private CtInvocation<Object> createFactoryInvocation(CtVariableAccess<CtElement> elementAccess) {
                String typeName = elementAccess.getType().getSimpleName();
                CtInvocation getFactory = factory.Code().createInvocation(null, factory.Executable().createReference("Factory CtElement#getFactory()"), new CtExpression[0]);
                getFactory.setTarget(elementAccess);
                String factoryName = this.internals.contains(typeName) ? "Internal" : "Core";
                CtInvocation coreFactory = factory.Code().createInvocation(getFactory, factory.Executable().createReference("CoreFactory Factory#" + factoryName + "()"), new CtExpression[0]);
                return factory.Code().createInvocation(coreFactory, factory.Executable().createReference("CoreFactory CtElement#create" + typeName.substring(2, typeName.length()) + "()"), new CtExpression[0]);
            }
        }.scan(this.getFactory().Class().get((Class)CtScanner.class));
        new CtScanner(){
            private final List<String> excludesAST = Arrays.asList("spoon.support.reflect.declaration.CtTypeInformationImpl", "spoon.support.reflect.code.CtAbstractInvocationImpl", "spoon.support.reflect.declaration.CtTypedElementImpl", "spoon.support.reflect.declaration.CtVariableImpl", "spoon.support.reflect.reference.CtActualTypeContainerImpl", "spoon.support.reflect.code.CtCFlowBreakImpl", "spoon.support.reflect.declaration.CtCodeSnippetImpl", "spoon.support.reflect.declaration.CtFormalTypeDeclarerImpl", "spoon.support.reflect.declaration.CtGenericElementImpl", "spoon.support.reflect.reference.CtGenericElementReferenceImpl", "spoon.support.reflect.declaration.CtModifiableImpl", "spoon.support.reflect.declaration.CtMultiTypedElementImpl", "spoon.support.reflect.declaration.CtTypeMemberImpl");
            private final List<String> excludesFields = Arrays.asList("factory", "elementValues", "target", "metadata");
            private final CtTypeReference<List> LIST_REFERENCE = factory.Type().createReference(List.class);
            private final CtTypeReference<Collection> COLLECTION_REFERENCE = factory.Type().createReference(Collection.class);
            private final CtTypeReference<Set> SET_REFERENCE = factory.Type().createReference(Set.class);
            private final CtTypeReference<CtElement> CTELEMENT_REFERENCE = factory.Type().createReference(CtElement.class);
            private final CtClass<?> GETTER_TEMPLATE_MATCHER_CLASS = factory.Class().get("spoon.generating.clone.GetterTemplateMatcher");
            private final CtClass<?> SETTER_TEMPLATE_MATCHER_CLASS = factory.Class().get("spoon.generating.clone.SetterTemplateMatcher");

            @Override
            public <T> void visitCtMethod(CtMethod<T> element) {
                if (!element.getSimpleName().startsWith("visitCt") && !element.getSimpleName().startsWith("scanCt")) {
                    return;
                }
                if ("scanCtVisitable".equals(element.getSimpleName())) {
                    return;
                }
                String qualifiedNameOfImplClass = "spoon.support" + element.getParameters().get(0).getType().getQualifiedName().substring(5) + "Impl";
                if (this.excludesAST.contains(qualifiedNameOfImplClass)) {
                    return;
                }
                CtType declaration = factory.Class().get(qualifiedNameOfImplClass);
                if (declaration == null) {
                    throw new SpoonException(qualifiedNameOfImplClass + " doesn't have declaration in the source path for " + element.getSignature());
                }
                CtMethod<T> clone = element.clone();
                clone.getBody().getStatements().clear();
                for (CtField<?> ctField : declaration.getFields()) {
                    if (this.excludesFields.contains(ctField.getSimpleName()) || this.isConstantOrStatic(ctField) || this.isSubTypeOfCtElement(ctField.getType())) continue;
                    CtMethod<?> setterOfField = this.getSetterOf(ctField);
                    CtInvocation<?> setterInvocation = this.createSetterInvocation(element.getParameters().get(0).getType(), setterOfField, this.createGetterInvocation(element.getParameters().get(0), this.getGetterOf(ctField)));
                    List<CtMethod<?>> methodsToAvoid = this.getCtMethodThrowUnsupportedOperation(setterOfField);
                    if (methodsToAvoid.size() > 0) {
                        clone.getBody().addStatement(this.createProtectionToException(setterInvocation, methodsToAvoid));
                        continue;
                    }
                    clone.getBody().addStatement(setterInvocation);
                }
                if (clone.getBody().getStatements().size() > 0) {
                    clone.getBody().insertEnd(this.createSuperInvocation(element));
                    CtComment comment = factory.Core().createComment();
                    comment.setCommentType(CtComment.CommentType.INLINE);
                    comment.setContent("auto-generated, see " + CloneVisitorGenerator.class.getName());
                    clone.addComment(comment);
                    targetBuilder.addMethod(clone);
                }
            }

            private CtIf createProtectionToException(CtInvocation<?> setterInvocation, List<CtMethod<?>> methodsAvoid) {
                CtIf anIf = factory.Core().createIf();
                anIf.setCondition((CtExpression<Boolean>)factory.Core().createUnaryOperator().setOperand(this.createBinaryConditions(methodsAvoid)).setKind(UnaryOperatorKind.NOT));
                anIf.setThenStatement(factory.Code().createCtBlock(setterInvocation));
                return anIf;
            }

            private CtExpression<Object> createBinaryConditions(List<CtMethod<?>> methodsAvoid) {
                CtBinaryOperator left = null;
                for (int i = 0; i < methodsAvoid.size(); ++i) {
                    CtInterface<?> ctInterface = this.getInterfaceOf(methodsAvoid.get(i).getDeclaringType());
                    if (i == 0) {
                        left = factory.Code().createBinaryOperator(otherRead, factory.Code().createTypeAccess(ctInterface.getReference()), BinaryOperatorKind.INSTANCEOF);
                        continue;
                    }
                    CtBinaryOperator right = factory.Code().createBinaryOperator(otherRead, factory.Code().createTypeAccess(ctInterface.getReference()), BinaryOperatorKind.INSTANCEOF);
                    left = factory.Code().createBinaryOperator(left, right, BinaryOperatorKind.OR);
                }
                return left;
            }

            private List<CtMethod<?>> getCtMethodThrowUnsupportedOperation(CtMethod<?> method) {
                ArrayList avoid = new ArrayList();
                CtInterface<?> ctInterface = this.getInterfaceOf(method.getDeclaringType());
                if (ctInterface == null) {
                    return avoid;
                }
                CtMethod<?> declarationMethod = this.getMethodByCtMethod(ctInterface, method);
                for (CtMethod ctMethod : Query.getElements(factory, new OverridingMethodFilter(declarationMethod))) {
                    if (this.avoidThrowUnsupportedOperationException(ctMethod)) continue;
                    avoid.add(ctMethod);
                }
                return avoid;
            }

            private boolean avoidThrowUnsupportedOperationException(CtMethod<?> candidate) {
                if (candidate.getBody().getStatements().size() != 1) {
                    return true;
                }
                if (!(candidate.getBody().getStatement(0) instanceof CtThrow)) {
                    return true;
                }
                CtThrow ctThrow = (CtThrow)candidate.getBody().getStatement(0);
                if (!(ctThrow.getThrownExpression() instanceof CtConstructorCall)) {
                    return true;
                }
                CtConstructorCall thrownExpression = (CtConstructorCall)ctThrow.getThrownExpression();
                return !thrownExpression.getType().equals(factory.Type().createReference(UnsupportedOperationException.class));
            }

            private CtMethod<?> getMethodByCtMethod(CtType<?> ctType, CtMethod<?> method) {
                for (CtMethod<?> ctMethod : ctType.getAllMethods()) {
                    if (!method.getSimpleName().equals(ctMethod.getSimpleName())) continue;
                    boolean cont = method.getParameters().size() == ctMethod.getParameters().size();
                    for (int i = 0; cont && i < method.getParameters().size(); ++i) {
                        if (method.getParameters().get(i).getType().equals(ctMethod.getParameters().get(i).getType())) continue;
                        cont = false;
                    }
                    if (!cont) continue;
                    return ctMethod;
                }
                throw new AssertionError((Object)("Can't find method " + method.getSignature() + " in the given interface " + ctType.getQualifiedName()));
            }

            private CtInterface<?> getInterfaceOf(CtType<?> declaringType) {
                CtTypeReference[] interfaces;
                for (CtTypeReference anInterface : interfaces = declaringType.getSuperInterfaces().toArray(new CtTypeReference[declaringType.getSuperInterfaces().size()])) {
                    if (!anInterface.getSimpleName().equals(declaringType.getSimpleName().substring(0, declaringType.getSimpleName().length() - 4))) continue;
                    return (CtInterface)anInterface.getDeclaration();
                }
                throw new AssertionError((Object)("You should have the interface for the implementation " + declaringType.getQualifiedName()));
            }

            private <T> CtInvocation<T> createSuperInvocation(CtMethod<T> element) {
                return factory.Code().createInvocation(factory.Core().createSuperAccess(), element.getReference(), factory.Code().createVariableRead(element.getParameters().get(0).getReference(), false));
            }

            private CtInvocation<?> createSetterInvocation(CtTypeReference<?> type, CtMethod<?> setter, CtInvocation<?> getter) {
                return factory.Code().createInvocation((CtExpression<?>)otherRead.clone().addTypeCast(type), setter.getReference(), getter);
            }

            private CtInvocation<?> createGetterInvocation(CtParameter<?> element, CtMethod<?> getter) {
                return factory.Code().createInvocation(factory.Code().createVariableRead(element.getReference(), false), getter.getReference(), new CtExpression[0]);
            }

            private <T> CtMethod<?> getSetterOf(final CtField<T> ctField) {
                for (CtMethod<?> ctMethod : ctField.getDeclaringType().getMethods()) {
                    if (!ctMethod.getSimpleName().startsWith("set") || !ctMethod.getSimpleName().toLowerCase().contains(ctField.getSimpleName().toLowerCase()) || ctMethod.getParameters().size() != 1 || !ctMethod.getParameters().get(0).getType().equals(ctField.getType())) continue;
                    return ctMethod;
                }
                this.SETTER_TEMPLATE_MATCHER_CLASS.getMethod("setElement", factory.Type().BOOLEAN_PRIMITIVE).getBody();
                List<CtMethod> matchers = ctField.getDeclaringType().getElements(new TypeFilter<CtMethod>(CtMethod.class){

                    @Override
                    public boolean matches(CtMethod element) {
                        CtBlock body = element.getBody();
                        if (body.getStatements().size() != 2) {
                            return false;
                        }
                        if (body.getStatement(0) instanceof CtAssignment) {
                            CtExpression assigned = ((CtAssignment)body.getStatement(0)).getAssigned();
                            if (!(assigned instanceof CtFieldAccess)) {
                                return false;
                            }
                            return ((CtFieldAccess)assigned).getVariable().getSimpleName().equals(ctField.getSimpleName());
                        }
                        return false;
                    }
                });
                if (matchers.size() != 1) {
                    throw new SpoonException("Get more than one setter. Please make an more ingenious method to get setter method.");
                }
                return matchers.get(0);
            }

            private <T> CtMethod<?> getGetterOf(CtField<T> ctField) {
                for (CtMethod<?> ctMethod : ctField.getDeclaringType().getMethods()) {
                    if (!ctMethod.getSimpleName().startsWith("get") && !ctMethod.getSimpleName().startsWith("is") || !ctMethod.getSimpleName().toLowerCase().contains(ctField.getSimpleName().toLowerCase()) || !ctMethod.getType().equals(ctField.getType()) || ctMethod.getParameters().size() != 0) continue;
                    return ctMethod;
                }
                final CtBlock templateRoot = this.GETTER_TEMPLATE_MATCHER_CLASS.getMethod("getElement", new CtTypeReference[0]).getBody();
                ((CtReturn)templateRoot.getStatement(0)).setReturnedExpression(factory.Code().createVariableRead(ctField.getReference(), true));
                List<CtMethod> matchers = ctField.getDeclaringType().getElements(new TypeFilter<CtMethod>(CtMethod.class){

                    @Override
                    public boolean matches(CtMethod element) {
                        return element.getBody().toString().equals(templateRoot.toString());
                    }
                });
                if (matchers.size() != 1) {
                    throw new SpoonException("Get more than one getter. Please make an more ingenious method to get getter method.");
                }
                return matchers.get(0);
            }

            private boolean isSubTypeOfCtElement(CtTypeReference<?> type) {
                if (!type.isPrimitive() && !type.equals(factory.Type().STRING)) {
                    if (type.isSubtypeOf(factory.Type().createReference(CtElement.class))) {
                        return true;
                    }
                    if ((type.getQualifiedName().equals(this.LIST_REFERENCE.getQualifiedName()) || type.getQualifiedName().equals(this.COLLECTION_REFERENCE.getQualifiedName()) || type.getQualifiedName().equals(this.SET_REFERENCE.getQualifiedName())) && type.getActualTypeArguments().get(0).isSubtypeOf(this.CTELEMENT_REFERENCE)) {
                        return true;
                    }
                }
                return false;
            }

            private boolean isConstantOrStatic(CtField<?> ctField) {
                return ctField.getModifiers().contains((Object)ModifierKind.FINAL) || ctField.getModifiers().contains((Object)ModifierKind.STATIC);
            }
        }.scan(this.getFactory().Class().get((Class)CtInheritanceScanner.class));
        Collections.sort(target.getTypeMembers(), new CtLineElementComparator());
        Collections.sort(targetBuilder.getTypeMembers(), new CtLineElementComparator());
    }

    private CtClass<Object> createCloneVisitor() {
        CtPackage aPackage = this.getFactory().Package().getOrCreate(TARGET_CLONE_PACKAGE);
        CtType target = this.getFactory().Class().get(GENERATING_CLONE);
        target.setSimpleName(TARGET_CLONE_TYPE);
        target.addModifier(ModifierKind.PUBLIC);
        aPackage.addType(target);
        List<CtTypeReference> references = target.getElements(new TypeFilter<CtTypeReference>(CtTypeReference.class){

            @Override
            public boolean matches(CtTypeReference reference) {
                return CloneVisitorGenerator.GENERATING_CLONE.equals(reference.getQualifiedName());
            }
        });
        for (CtTypeReference reference : references) {
            reference.setSimpleName(TARGET_CLONE_TYPE);
            reference.setPackage(aPackage.getReference());
        }
        return target;
    }

    private CtClass<Object> createCloneBuilder() {
        CtPackage aPackage = this.getFactory().Package().getOrCreate(TARGET_CLONE_PACKAGE);
        CtType target = this.getFactory().Class().get(GENERATING_BUILDER_CLONE);
        target.setSimpleName(TARGET_BUILDER_CLONE_TYPE);
        target.addModifier(ModifierKind.PUBLIC);
        aPackage.addType(target);
        List<CtTypeReference> references = target.getElements(new TypeFilter<CtTypeReference>(CtTypeReference.class){

            @Override
            public boolean matches(CtTypeReference reference) {
                return CloneVisitorGenerator.GENERATING_BUILDER_CLONE.equals(reference.getQualifiedName());
            }
        });
        for (CtTypeReference reference : references) {
            reference.setSimpleName(TARGET_BUILDER_CLONE_TYPE);
            reference.setPackage(aPackage.getReference());
        }
        return target;
    }
}

