/*
 * Decompiled with CFR 0.152.
 */
package spoon.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import spoon.Launcher;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResource;
import spoon.support.compiler.FileSystemFile;
import spoon.support.compiler.FileSystemFolder;
import spoon.support.compiler.ZipFolder;

public abstract class SpoonResourceHelper {
    private SpoonResourceHelper() {
    }

    public static boolean isArchive(File f) {
        return f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
    }

    public static boolean isFile(File f) {
        return f.isFile() && !SpoonResourceHelper.isArchive(f);
    }

    public static List<SpoonResource> resources(String ... paths) throws FileNotFoundException {
        ArrayList<SpoonResource> files = new ArrayList<SpoonResource>();
        for (String path : paths) {
            files.add(SpoonResourceHelper.createResource(new File(path)));
        }
        return files;
    }

    public static SpoonFile createFile(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        return new FileSystemFile(f);
    }

    public static SpoonResource createResource(File f) throws FileNotFoundException {
        if (SpoonResourceHelper.isFile(f)) {
            return SpoonResourceHelper.createFile(f);
        }
        return SpoonResourceHelper.createFolder(f);
    }

    public static SpoonFolder createFolder(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString() + " does not exist");
        }
        try {
            if (f.isDirectory()) {
                return new FileSystemFolder(f);
            }
            if (SpoonResourceHelper.isArchive(f)) {
                return new ZipFolder(f);
            }
        }
        catch (IOException e) {
            Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

