/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class SpoonTask
extends Java {
    String classname;
    File input;
    int javaCompliance = 7;
    boolean nooutput = false;
    boolean compile = false;
    File output;
    File destination;
    List<ProcessorType> processorTypes = new ArrayList<ProcessorType>();
    Vector<FileSet> sourcefilesets = new Vector();
    boolean stats = false;
    File template;
    Vector<FileSet> templatefilesets = new Vector();
    boolean verbose = false;
    boolean debug = false;
    boolean imports = false;
    boolean noclasspath = false;
    boolean precompile = false;
    boolean buildOnlyOutdatedFiles = false;
    String outputType;
    String encoding;
    boolean lines;
    boolean tabs = false;
    int tabSize = 4;
    Path sourceClasspath;
    Path templateClasspath;

    public SpoonTask() {
        this.setClassname("spoon.Launcher");
        this.setFailonerror(true);
    }

    public void addProcessor(ProcessorType processorType) {
        this.processorTypes.add(processorType);
    }

    public void addSourceSet(FileSet set) {
        this.sourcefilesets.addElement(set);
    }

    public void addTemplateSet(FileSet set) {
        this.templatefilesets.addElement(set);
    }

    public void execute() throws BuildException {
        File dir;
        FileSet fs;
        int i;
        String f;
        this.setFork(false);
        if (this.verbose) {
            this.createArg().setValue("-v");
        }
        if (this.debug) {
            this.createArg().setValue("--vvv");
        }
        if (this.precompile) {
            this.createArg().setValue("--precompile");
        }
        if (this.tabs) {
            this.createArg().setValue("--tabs");
        }
        if (this.imports) {
            this.createArg().setValue("--with-imports");
        }
        if (this.noclasspath) {
            this.createArg().setValue("--noclasspath");
        }
        this.createArg().setValue("--tabsize");
        this.createArg().setValue("" + this.tabSize);
        if (this.outputType != null) {
            this.createArg().setValue("--output-type");
            this.createArg().setValue(this.outputType);
        }
        if (this.encoding != null) {
            this.createArg().setValue("--encoding");
            this.createArg().setValue(this.encoding);
        }
        if (this.compile) {
            this.createArg().setValue("--compile");
        }
        if (this.buildOnlyOutdatedFiles) {
            this.createArg().setValue("--buildOnlyOutdatedFiles");
        }
        if (this.lines) {
            this.createArg().setValue("--lines");
        }
        this.createArg().setValue("--compliance");
        this.createArg().setValue("" + this.javaCompliance);
        if (this.output != null) {
            if (this.output.exists() && !this.output.isDirectory()) {
                throw new BuildException("Output must be a directory");
            }
            this.createArg().setValue("-o");
            this.createArg().setValue(this.output.getAbsolutePath());
        }
        if (this.destination != null) {
            if (this.destination.exists() && !this.destination.isDirectory()) {
                throw new BuildException("Destination must be a directory");
            }
            this.createArg().setValue("-d");
            this.createArg().setValue(this.destination.getAbsolutePath());
        }
        if (this.input != null || this.sourcefilesets.size() > 0) {
            this.createArg().setValue("-i");
            f = "";
            if (this.input != null) {
                f = f + this.input.getAbsolutePath() + File.pathSeparator;
            }
            for (i = 0; i < this.sourcefilesets.size(); ++i) {
                fs = this.sourcefilesets.elementAt(i);
                dir = fs.getDir(this.getProject());
                f = f + dir.getAbsolutePath() + File.pathSeparator;
            }
            this.createArg().setValue(f);
        }
        if (this.template != null || this.templatefilesets.size() > 0) {
            this.createArg().setValue("-t");
            f = "";
            if (this.template != null) {
                if (!this.template.exists()) {
                    throw new BuildException("template file or directory does not exist (" + this.template.getAbsolutePath() + ")");
                }
                f = f + this.template.getAbsolutePath() + File.pathSeparator;
            }
            for (i = 0; i < this.templatefilesets.size(); ++i) {
                fs = this.templatefilesets.elementAt(i);
                dir = fs.getDir(this.getProject());
                f = f + dir.getAbsolutePath() + File.pathSeparator;
            }
            this.createArg().setValue(f);
        }
        if (this.processorTypes != null && this.processorTypes.size() > 0) {
            this.createArg().setValue("-p");
            String process = "";
            for (ProcessorType t : this.processorTypes) {
                process = process + t.type + File.pathSeparator;
            }
            this.createArg().setValue(process);
        }
        if (this.classname != null) {
            this.createArg().setValue(this.classname);
        }
        if (this.sourceClasspath != null) {
            this.createArg().setValue("--source-classpath");
            this.createArg().setValue(this.sourceClasspath.toString());
        } else if (this.getCommandLine().getClasspath() != null) {
            this.createArg().setValue("--source-classpath");
            this.createArg().setValue(this.getCommandLine().getClasspath().toString());
        }
        if (this.templateClasspath != null) {
            this.createArg().setValue("--template-classpath");
            this.createArg().setValue(this.templateClasspath.toString());
        } else if (this.getCommandLine().getClasspath() != null) {
            this.createArg().setValue("--template-classpath");
            this.createArg().setValue(this.getCommandLine().getClasspath().toString());
        }
        super.execute();
    }

    public void setClassName(String classname) {
        this.classname = classname;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public void setJavaCompliance(int javaCompliance) {
        this.javaCompliance = javaCompliance;
    }

    public void setNoOutput(boolean nooutput) {
        this.nooutput = nooutput;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void setStats(boolean stats) {
        this.stats = stats;
    }

    public void setTemplate(File template) {
        this.template = template;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTabs(boolean tabs) {
        this.tabs = tabs;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public void setPrecompile(boolean precompile) {
        this.precompile = precompile;
    }

    public void setSourceClasspath(Path s) {
        this.createSourceClasspath().append(s);
    }

    public void setSourceClasspathRef(Reference r) {
        this.createSourceClasspath().setRefid(r);
    }

    private Path createSourceClasspath() {
        if (this.sourceClasspath == null) {
            this.sourceClasspath = new Path(this.getProject());
        }
        return this.sourceClasspath;
    }

    public void setTemplateClasspath(Path s) {
        this.createTemplateClasspath().append(s);
    }

    public void setTemplateClasspathRef(Reference r) {
        this.createTemplateClasspath().setRefid(r);
    }

    private Path createTemplateClasspath() {
        if (this.templateClasspath == null) {
            this.templateClasspath = new Path(this.getProject());
        }
        return this.templateClasspath;
    }

    public void setBuildOnlyOutdatedFiles(boolean buildOnlyOutdatedFiles) {
        this.buildOnlyOutdatedFiles = buildOnlyOutdatedFiles;
    }

    public void setOutputType(String ouputType) {
        this.outputType = ouputType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setImports(boolean imports) {
        this.imports = imports;
    }

    public void setNoClasspath(boolean noclasspath) {
        this.noclasspath = noclasspath;
    }

    public void setLines(boolean lines) {
        this.lines = lines;
    }

    public static class ProcessorType {
        String type;

        public ProcessorType() {
        }

        public ProcessorType(String type) {
            this.setType(type);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

