/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.lib;

import io.apisense.dart.api.Dart;
import io.apisense.dart.api.Data;
import io.apisense.dart.api.Seed;
import io.apisense.dart.lib.BitMask;
import io.apisense.sting.lib.Sting;
import java.util.Set;

public abstract class DartImpl<D extends Data>
extends Sting
implements Dart<D> {
    private final int supportedSeeds;

    protected DartImpl(Class<? extends Dart<D>> descDart, Set<? extends Seed> available) {
        super(descDart);
        int mask = 0;
        for (Seed seed : available) {
            mask += seed.value();
        }
        this.supportedSeeds = mask;
    }

    @Override
    public int seeds() {
        return this.supportedSeeds;
    }

    @Override
    public final boolean available(int fields) {
        return BitMask.matches(fields, this.supportedSeeds);
    }

    @Override
    public D data() {
        return this.map(this.supportedSeeds);
    }

    @Override
    public Long timestamp() {
        return System.currentTimeMillis();
    }
}

