/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.api;

import io.apisense.generation.DocCommentProcessor;
import io.apisense.generation.api.APISENSELauncherAPI;
import java.io.File;
import java.io.IOException;
import java.util.List;
import spoon.processing.Processor;

public final class APIGenerator {
    private final String libName;
    private final File out;
    private final List<String> classesToAnalyze;

    public APIGenerator(File out, String libName, List<String> classesToAnalyze) {
        this.libName = libName;
        this.out = out;
        this.classesToAnalyze = classesToAnalyze;
    }

    public void generateDocumentation() throws IOException {
        assert (this.libName != null);
        assert (this.out != null);
        assert (this.classesToAnalyze != null);
        APISENSELauncherAPI launcher = new APISENSELauncherAPI(this.out, this.libName);
        for (String stingClass : this.classesToAnalyze) {
            launcher.addInputResource(stingClass);
        }
        launcher.addProcessor((Processor)new DocCommentProcessor());
        launcher.getEnvironment().setNoClasspath(true);
        launcher.getEnvironment().setCommentEnabled(true);
        launcher.run();
    }
}

