/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation;

import io.apisense.generation.JavaToJS;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;

public class JavaToJsConverter
implements JavaToJS {
    private static final String[] javaNumberType = new String[]{"int", "Integer", "long", "Long", "Double", "Float"};
    private static final String[] javaArrayType = new String[]{"Array", "List"};
    private final Map<String, String> typeConversion = new HashMap<String, String>();

    public JavaToJsConverter() {
        this.setNumberConversion("number");
        this.setArrayConversion("array");
        this.setConversion("Map", "object");
        this.setConversion("Object", "object");
        this.setConversion("String", "string");
        this.setConversion("Boolean", "boolean");
    }

    @Override
    public void setArrayConversion(String jsType) {
        for (String javaType : javaArrayType) {
            this.setConversion(javaType, jsType);
        }
    }

    @Override
    public void setNumberConversion(String jsType) {
        for (String javaType : javaNumberType) {
            this.setConversion(javaType, jsType);
        }
    }

    @Override
    public void setConversion(String javaType, String jsType) {
        this.typeConversion.put(javaType, jsType);
    }

    @Override
    public String generateClassDeclaration(CtType<?> type) {
        return "function " + type.getSimpleName() + "() {}";
    }

    @Override
    public String generateFunctionDefinition(CtMethod<?> method) {
        return "function(" + this.generateParametersSequence(method) + "){}";
    }

    protected String generateParametersSequence(CtMethod<?> method) {
        List parameters = method.getParameters();
        StringBuilder argsSequenceBuilder = new StringBuilder();
        for (CtParameter parameter : parameters) {
            argsSequenceBuilder.append(this.buildParameterDeclaration(parameter)).append(", ");
        }
        String argsSequence = argsSequenceBuilder.toString();
        if (!parameters.isEmpty()) {
            argsSequence = argsSequence.substring(0, argsSequence.length() - 2);
        }
        return argsSequence;
    }

    protected String buildParameterDeclaration(CtParameter parameter) {
        return parameter.getSimpleName();
    }

    @Override
    public String generateFieldDeclaration(CtType<?> type, CtNamedElement field) {
        return type.getSimpleName() + ".prototype." + field.getSimpleName();
    }

    @Override
    public String findJsType(CtTypedElement field) {
        String key = field.getType().getSimpleName();
        return this.typeConversion.getOrDefault(key, key);
    }
}

