/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation;

import io.apisense.generation.api.APIGenerator;
import io.apisense.generation.documentation.DocGenerator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionHandlerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger logger = LoggerFactory.getLogger(Generator.class);
    private static final String CLASSES_META_VAR = " STING_CLASSES";
    @Option(name="-a", aliases={"--api"}, usage="Generate Tern API for the given classes.", depends={"-n"})
    private boolean api;
    @Option(name="-d", aliases={"--documentation"}, usage="Generate Javascript documentation of the given classes.")
    private boolean documentation;
    @Option(name="-n", aliases={"--name"}, usage="Determine the name of your generated API library.", metaVar="LIB_NAME")
    private String libName;
    @Option(name="-o", aliases={"--output"}, usage="Output file for the generated json.", metaVar="OUTPUT")
    private File out;
    @Argument(usage="The Java files containing the classes to generate API from.", metaVar=" STING_CLASSES", required=true)
    private List<String> classesToAnalyze;

    public static void main(String[] args) throws IOException {
        new Generator().execute(args);
    }

    private void execute(String[] args) throws IOException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            logger.error(e.getMessage(), (Throwable)e);
            Generator.printHelp(parser);
            return;
        }
        if (!this.documentation && !this.api) {
            logger.info("No generation type specified, will do nothing");
            Generator.printHelp(parser);
        }
        this.generate();
    }

    private void generate() throws IOException {
        if (this.documentation) {
            new DocGenerator(this.out, this.classesToAnalyze).generateDocumentation();
        }
        if (this.api) {
            new APIGenerator(this.out, this.libName, this.classesToAnalyze).generateDocumentation();
        }
    }

    private static void printHelp(CmdLineParser parser) {
        parser.printUsage((OutputStream)System.err);
        logger.error("\tExample: java -jar sting-api-generator.jar" + parser.printExample(OptionHandlerFilter.ALL) + CLASSES_META_VAR);
    }
}

