/*
 * Decompiled with CFR 0.152.
 */
package spoon.template;

import java.lang.reflect.Field;
import java.util.List;
import spoon.SpoonException;
import spoon.processing.FactoryAccessor;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.ReferenceTypeFilter;
import spoon.support.template.Parameters;
import spoon.support.template.SubstitutionVisitor;
import spoon.template.Local;
import spoon.template.Parameter;
import spoon.template.Template;
import spoon.template.TemplateException;

public abstract class Substitution {
    private Substitution() {
    }

    public static <T extends Template<?>> void insertAll(CtType<?> targetType, T template) {
        CtClass<T> templateClass = Substitution.getTemplateCtClass(targetType, template);
        Substitution.insertAllSuperInterfaces(targetType, template);
        Substitution.insertAllMethods(targetType, template);
        Substitution.insertAllConstructors(targetType, template);
        for (CtTypeMember typeMember : templateClass.getTypeMembers()) {
            if (typeMember instanceof CtField) {
                Substitution.insertGeneratedField(targetType, template, (CtField)typeMember);
                continue;
            }
            if (!(typeMember instanceof CtType)) continue;
            Substitution.insertGeneratedNestedType(targetType, template, (CtType)typeMember);
        }
    }

    public static void insertAllSuperInterfaces(CtType<?> targetType, Template<?> template) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetType, template);
        Substitution.insertAllSuperInterfaces(targetType, template, sourceClass);
    }

    static void insertAllSuperInterfaces(CtType<?> targetType, Template<?> template, CtClass<? extends Template<?>> sourceClass) {
        for (CtTypeReference ctTypeReference : sourceClass.getSuperInterfaces()) {
            if (ctTypeReference.equals(targetType.getFactory().Type().createReference(Template.class))) continue;
            CtTypeReference t1 = ctTypeReference;
            if (Parameters.getNames(sourceClass).contains(ctTypeReference.getSimpleName())) {
                Object o = Parameters.getValue(template, ctTypeReference.getSimpleName(), null);
                if (o instanceof CtTypeReference) {
                    t1 = (CtTypeReference)o;
                } else if (o instanceof Class) {
                    t1 = targetType.getFactory().Type().createReference((Class)o);
                } else if (o instanceof String) {
                    t1 = targetType.getFactory().Type().createReference((String)o);
                }
            }
            if (t1.equals(targetType.getReference())) continue;
            Class<?> c = null;
            try {
                c = t1.getActualClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (c != null && c.isInterface()) {
                targetType.addSuperInterface(t1);
            }
            if (c != null) continue;
            targetType.addSuperInterface(t1);
        }
    }

    public static void insertAllMethods(CtType<?> targetType, Template<?> template) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetType, template);
        Substitution.insertAllMethods(targetType, template, sourceClass);
    }

    static void insertAllMethods(CtType<?> targetType, Template<?> template, CtClass<?> sourceClass) {
        for (CtMethod<?> m : sourceClass.getMethods()) {
            if (m.getAnnotation(Local.class) != null || m.getAnnotation(Parameter.class) != null) continue;
            Substitution.insertMethod(targetType, template, m);
        }
    }

    public static void insertAllFields(CtType<?> targetType, Template<?> template) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetType, template);
        for (CtTypeMember typeMember : sourceClass.getTypeMembers()) {
            if (!(typeMember instanceof CtField)) continue;
            Substitution.insertGeneratedField(targetType, template, (CtField)typeMember);
        }
    }

    static void insertGeneratedField(CtType<?> targetType, Template<?> template, CtField<?> field) {
        if (field.getAnnotation(Local.class) != null) {
            return;
        }
        if (Parameters.isParameterSource(field.getReference())) {
            return;
        }
        Substitution.insertField(targetType, template, field);
    }

    public static void insertAllNestedTypes(CtType<?> targetType, Template<?> template) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetType, template);
        for (CtTypeMember typeMember : sourceClass.getTypeMembers()) {
            if (!(typeMember instanceof CtType)) continue;
            Substitution.insertGeneratedNestedType(targetType, template, (CtType)typeMember);
        }
    }

    static void insertGeneratedNestedType(CtType<?> targetType, Template<?> template, CtType<?> nestedType) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetType, template);
        if (nestedType.getAnnotation(Local.class) != null) {
            return;
        }
        CtType<?> result = Substitution.substitute(sourceClass, template, nestedType);
        targetType.addNestedType(result);
    }

    public static void insertAllConstructors(CtType<?> targetType, Template<?> template) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetType, template);
        Substitution.insertAllConstructors(targetType, template, sourceClass);
    }

    static void insertAllConstructors(CtType<?> targetType, Template<?> template, CtClass<?> sourceClass) {
        if (targetType instanceof CtClass) {
            for (CtConstructor ctConstructor : sourceClass.getConstructors()) {
                if (ctConstructor.isImplicit() || ctConstructor.getAnnotation(Local.class) != null) continue;
                Substitution.insertConstructor((CtClass)targetType, template, ctConstructor);
            }
        }
        if (targetType instanceof CtClass) {
            for (CtAnonymousExecutable ctAnonymousExecutable : sourceClass.getAnonymousExecutables()) {
                ((CtClass)targetType).addAnonymousExecutable(Substitution.substitute(targetType, template, ctAnonymousExecutable));
            }
        }
    }

    public static <T> CtConstructor<T> insertConstructor(CtClass<T> targetClass, Template<?> template, CtMethod<?> sourceMethod) {
        if (targetClass instanceof CtInterface) {
            return null;
        }
        CtConstructor<T> newConstructor = targetClass.getFactory().Constructor().create(targetClass, sourceMethod);
        newConstructor = Substitution.substitute(targetClass, template, newConstructor);
        targetClass.addConstructor(newConstructor);
        return newConstructor;
    }

    public static <T> CtMethod<T> insertMethod(CtType<?> targetType, Template<?> template, CtMethod<T> sourceMethod) {
        CtMethod<T> newMethod = Substitution.substitute(targetType, template, sourceMethod);
        if (targetType instanceof CtInterface) {
            newMethod.setBody(null);
        }
        targetType.addMethod(newMethod);
        return newMethod;
    }

    public static <T> CtConstructor<T> insertConstructor(CtClass<T> targetClass, Template<?> template, CtConstructor<?> sourceConstructor) {
        CtConstructor<T> c;
        CtConstructor<?> newConstrutor = Substitution.substitute(targetClass, template, sourceConstructor);
        if (newConstrutor.getParameters().isEmpty() && (c = targetClass.getConstructor(new CtTypeReference[0])) != null && c.isImplicit()) {
            targetClass.getConstructors().remove(c);
        }
        targetClass.addConstructor(newConstrutor);
        return newConstrutor;
    }

    public static CtBlock<?> substituteMethodBody(CtClass<?> targetClass, Template<?> template, String executableName, CtTypeReference<?> ... parameterTypes) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetClass, template);
        CtTypeMember sourceExecutable = executableName.equals(template.getClass().getSimpleName()) ? sourceClass.getConstructor(parameterTypes) : sourceClass.getMethod(executableName, parameterTypes);
        return Substitution.substitute(targetClass, template, sourceExecutable.getBody());
    }

    public static CtStatement substituteStatement(CtClass<?> targetClass, Template<?> template, int statementIndex, String executableName, CtTypeReference<?> ... parameterTypes) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetClass, template);
        CtTypeMember sourceExecutable = executableName.equals(template.getClass().getSimpleName()) ? sourceClass.getConstructor(parameterTypes) : sourceClass.getMethod(executableName, parameterTypes);
        return (CtStatement)Substitution.substitute(targetClass, template, sourceExecutable.getBody().getStatement(statementIndex));
    }

    public static CtExpression<?> substituteFieldDefaultExpression(CtType<?> targetType, Template<?> template, String fieldName) {
        CtClass sourceClass = Substitution.getTemplateCtClass(targetType, template);
        CtField<?> sourceField = sourceClass.getField(fieldName);
        return Substitution.substitute(targetType, template, sourceField.getDefaultExpression());
    }

    public static <E extends CtElement> E substitute(CtType<?> targetType, Template<?> template, E code) {
        if (code == null) {
            return null;
        }
        if (targetType == null) {
            throw new RuntimeException("target is null in substitution");
        }
        CtElement result = code.clone();
        new SubstitutionVisitor(targetType.getFactory(), targetType, template).scan(result);
        return (E)result;
    }

    public static <T extends CtType<?>> T substitute(Template<?> template, T templateType) {
        CtType<?> result = templateType.clone();
        result.setPositions(null);
        new SubstitutionVisitor(templateType.getFactory(), result, template).scan(result);
        return (T)result;
    }

    public static <T> CtField<T> insertField(CtType<?> targetType, Template<?> template, CtField<T> sourceField) {
        CtField<T> field = Substitution.substitute(targetType, template, sourceField);
        targetType.addField(field);
        return field;
    }

    public static void redirectTypeReferences(CtElement element, CtTypeReference<?> source, CtTypeReference<?> target) {
        List<CtTypeReference> refs = Query.getReferences(element, new ReferenceTypeFilter<CtTypeReference>(CtTypeReference.class));
        String srcName = source.getQualifiedName();
        String targetName = target.getSimpleName();
        CtPackageReference targetPackage = target.getPackage();
        for (CtTypeReference ref : refs) {
            if (!ref.getQualifiedName().equals(srcName)) continue;
            ref.setSimpleName(targetName);
            ref.setPackage(targetPackage);
        }
    }

    static <T> CtClass<T> getTemplateCtClass(CtType<?> targetType, Template<?> template) {
        Factory factory = targetType != null ? targetType.getFactory() : Substitution.getFactory(template);
        return Substitution.getTemplateCtClass(factory, template);
    }

    static <T> CtClass<T> getTemplateCtClass(Factory factory, Template<?> template) {
        CtType c = factory.Class().get((Class)template.getClass());
        if (c.isShadow()) {
            throw new SpoonException("The template " + template.getClass().getName() + " is not part of model. Add template sources to spoon template path.");
        }
        return c;
    }

    static Factory getFactory(Template<?> template) {
        try {
            for (Field f : Parameters.getAllTemplateParameterFields(template.getClass())) {
                if (f.get(template) == null || !(f.get(template) instanceof FactoryAccessor)) continue;
                return ((FactoryAccessor)f.get(template)).getFactory();
            }
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
        throw new TemplateException("no factory found in template " + template.getClass().getName());
    }
}

