/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtClassImpl;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.util.SignatureBasedSortedSet;

public class CtEnumImpl<T extends Enum<?>>
extends CtClassImpl<T>
implements CtEnum<T> {
    private static final long serialVersionUID = 1L;
    private List<CtEnumValue<?>> enumValues = CtElementImpl.emptyList();
    private CtMethod<T[]> valuesMethod;
    private CtMethod<T> valueOfMethod;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtEnum(this);
    }

    @Override
    public Set<CtMethod<?>> getAllMethods() {
        SignatureBasedSortedSet allMethods = new SignatureBasedSortedSet();
        allMethods.addAll(this.getMethods());
        allMethods.addAll(this.getFactory().Type().get(Enum.class).getMethods());
        allMethods.add(this.valuesMethod());
        allMethods.add(this.valueOfMethod());
        return allMethods;
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        for (CtTypeReference<?> ref : this.getSuperInterfaces()) {
            if (!ref.isSubtypeOf(type)) continue;
            return true;
        }
        return this.getSuperclass().isSubtypeOf(type);
    }

    @Override
    public <C extends CtEnum<T>> C addEnumValue(CtEnumValue<?> enumValue) {
        if (enumValue == null) {
            return (C)this;
        }
        if (this.enumValues == CtElementImpl.emptyList()) {
            this.enumValues = new ArrayList();
        }
        if (!this.enumValues.contains(enumValue)) {
            enumValue.setParent(this);
            this.enumValues.add(enumValue);
        }
        return (C)this;
    }

    @Override
    public boolean removeEnumValue(CtEnumValue<?> enumValue) {
        return this.enumValues.remove(enumValue);
    }

    @Override
    public CtEnumValue<?> getEnumValue(String name) {
        for (CtEnumValue<?> enumValue : this.enumValues) {
            if (!enumValue.getSimpleName().equals(name)) continue;
            return enumValue;
        }
        return null;
    }

    @Override
    public List<CtEnumValue<?>> getEnumValues() {
        return Collections.unmodifiableList(this.enumValues);
    }

    @Override
    public <C extends CtEnum<T>> C setEnumValues(List<CtEnumValue<?>> enumValues) {
        if (enumValues == null || enumValues.isEmpty()) {
            this.enumValues = CtEnumImpl.emptyList();
            return (C)this;
        }
        this.enumValues.clear();
        for (CtEnumValue<?> enumValue : enumValues) {
            this.addEnumValue(enumValue);
        }
        return (C)this;
    }

    @Override
    public List<CtField<?>> getFields() {
        ArrayList result = new ArrayList();
        result.addAll(this.getEnumValues());
        result.addAll(super.getFields());
        return result;
    }

    @Override
    public CtField<?> getField(String name) {
        CtField<?> field = super.getField(name);
        if (field == null) {
            return this.getEnumValue(name);
        }
        return field;
    }

    @Override
    public CtEnum<T> clone() {
        return (CtEnum)super.clone();
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return this.getFactory().Type().createReference(Enum.class);
    }

    private CtMethod valuesMethod() {
        if (this.valuesMethod == null) {
            this.valuesMethod = this.getFactory().Core().createMethod();
            this.valuesMethod.setParent(this);
            this.valuesMethod.addModifier(ModifierKind.PUBLIC);
            this.valuesMethod.addModifier(ModifierKind.STATIC);
            this.valuesMethod.setSimpleName("values");
            this.valuesMethod.setImplicit(true);
            this.valuesMethod.setType(this.factory.Type().createArrayReference(this.getReference()));
        }
        return this.valuesMethod;
    }

    private CtMethod valueOfMethod() {
        if (this.valueOfMethod == null) {
            this.valueOfMethod = this.getFactory().Core().createMethod();
            this.valueOfMethod.setParent(this);
            this.valueOfMethod.addModifier(ModifierKind.PUBLIC);
            this.valueOfMethod.addModifier(ModifierKind.STATIC);
            this.valueOfMethod.setSimpleName("valueOf");
            this.valueOfMethod.setImplicit(true);
            this.valueOfMethod.addThrownType(this.getFactory().Type().createReference(IllegalArgumentException.class));
            this.valueOfMethod.setType((CtTypeReference<T>)this.getReference());
            this.factory.Method().createParameter(this.valuesMethod, this.factory.Type().STRING, "name");
        }
        return this.valueOfMethod;
    }

    @Override
    public <R> CtMethod<R> getMethod(String name, CtTypeReference<?> ... parameterTypes) {
        if ("values".equals(name) && parameterTypes.length == 0) {
            return this.valuesMethod();
        }
        if ("valueOf".equals(name) && parameterTypes.length == 1 && parameterTypes[0].equals(this.factory.Type().STRING)) {
            return this.valueOfMethod();
        }
        return super.getMethod(name, parameterTypes);
    }

    @Override
    public <R> CtMethod<R> getMethod(CtTypeReference<R> returnType, String name, CtTypeReference<?> ... parameterTypes) {
        if ("values".equals(name) && parameterTypes.length == 0 && returnType.equals(this.getReference())) {
            return this.valuesMethod();
        }
        if ("valueOf".equals(name) && parameterTypes.length == 1 && parameterTypes[0].equals(this.factory.Type().STRING) && returnType.equals(this.factory.Type().createArrayReference(this.getReference()))) {
            return this.valueOfMethod();
        }
        return super.getMethod(returnType, name, parameterTypes);
    }
}

