/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.SpoonModelBuilder;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.UnsettableProperty;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtTypeImpl;
import spoon.support.reflect.eval.VisitorPartialEvaluator;
import spoon.support.util.SignatureBasedSortedSet;

public class CtClassImpl<T>
extends CtTypeImpl<T>
implements CtClass<T> {
    private static final long serialVersionUID = 1L;
    CtTypeReference<?> superClass;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtClass(this);
    }

    @Override
    public List<CtAnonymousExecutable> getAnonymousExecutables() {
        ArrayList<CtAnonymousExecutable> anonymousExecutables = new ArrayList<CtAnonymousExecutable>();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtAnonymousExecutable)) continue;
            anonymousExecutables.add((CtAnonymousExecutable)typeMember);
        }
        return anonymousExecutables;
    }

    @Override
    public CtConstructor<T> getConstructor(CtTypeReference<?> ... parameterTypes) {
        for (CtTypeMember typeMember : this.getTypeMembers()) {
            if (!(typeMember instanceof CtConstructor)) continue;
            CtConstructor c = (CtConstructor)typeMember;
            boolean cont = c.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < c.getParameters().size() && i < parameterTypes.length; ++i) {
                if (parameterTypes[i].getQualifiedName().equals(c.getParameters().get(i).getType().getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return c;
        }
        return null;
    }

    @Override
    public Set<CtConstructor<T>> getConstructors() {
        SignatureBasedSortedSet<CtConstructor<T>> constructors = new SignatureBasedSortedSet<CtConstructor<T>>();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtConstructor)) continue;
            constructors.add((CtConstructor)typeMember);
        }
        return constructors;
    }

    @Override
    public <C extends CtClass<T>> C addAnonymousExecutable(CtAnonymousExecutable e) {
        return (C)((CtClass)this.addTypeMember(e));
    }

    @Override
    public boolean removeAnonymousExecutable(CtAnonymousExecutable e) {
        return this.removeTypeMember(e);
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return this.superClass;
    }

    @Override
    public <C extends CtClass<T>> C setAnonymousExecutables(List<CtAnonymousExecutable> anonymousExecutables) {
        if (anonymousExecutables == null || anonymousExecutables.isEmpty()) {
            this.typeMembers.removeAll(this.getAnonymousExecutables());
            return (C)this;
        }
        this.typeMembers.removeAll(this.getAnonymousExecutables());
        for (CtAnonymousExecutable exec : anonymousExecutables) {
            this.addAnonymousExecutable(exec);
        }
        return (C)this;
    }

    @Override
    public <C extends CtClass<T>> C setConstructors(Set<CtConstructor<T>> constructors) {
        if (constructors == null || constructors.isEmpty()) {
            this.typeMembers.removeAll(this.getConstructors());
            return (C)this;
        }
        this.typeMembers.removeAll(this.getConstructors());
        for (CtConstructor<T> constructor : constructors) {
            this.addConstructor(constructor);
        }
        return (C)this;
    }

    @Override
    public <C extends CtClass<T>> C addConstructor(CtConstructor<T> constructor) {
        return (C)((CtClass)this.addTypeMember(constructor));
    }

    @Override
    public void removeConstructor(CtConstructor<T> constructor) {
        this.removeTypeMember(constructor);
    }

    @Override
    public <C extends CtType<T>> C setSuperclass(CtTypeReference<?> superClass) {
        if (superClass != null) {
            superClass.setParent(this);
        }
        this.superClass = superClass;
        return (C)this;
    }

    @Override
    public boolean isAnonymous() {
        try {
            Integer.parseInt(this.getSimpleName());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        if (this.getSuperclass() != null && this.getSuperclass().isSubtypeOf(type)) {
            return true;
        }
        for (CtTypeReference<?> ref : this.getSuperInterfaces()) {
            if (!ref.isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }

    public <C extends CtStatement> C insertAfter(CtStatement statement) {
        CtStatementImpl.insertAfter((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertAfter(CtStatementList statements) {
        CtStatementImpl.insertAfter((CtStatement)this, statements);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatement statement) {
        CtStatementImpl.insertBefore((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatementList statements) {
        CtStatementImpl.insertBefore((CtStatement)this, statements);
        return (C)this;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @UnsettableProperty
    public <C extends CtStatement> C setLabel(String label) {
        return (C)this;
    }

    @Override
    public <R extends CtCodeElement> R partiallyEvaluate() {
        VisitorPartialEvaluator eval = new VisitorPartialEvaluator();
        return (R)eval.evaluate(this);
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        Collection<CtExecutableReference<?>> declaredExecutables = super.getDeclaredExecutables();
        ArrayList l = new ArrayList(declaredExecutables.size() + this.getConstructors().size());
        l.addAll(declaredExecutables);
        for (CtExecutable ctExecutable : this.getConstructors()) {
            l.add(ctExecutable.getReference());
        }
        return Collections.unmodifiableList(l);
    }

    @Override
    public void replace(CtStatement element) {
        this.replace((CtElement)element);
    }

    @Override
    public CtClass<T> clone() {
        return (CtClass)super.clone();
    }

    @Override
    public T newInstance() {
        try {
            JDTBasedSpoonCompiler spooner = new JDTBasedSpoonCompiler(this.getFactory());
            spooner.compile(SpoonModelBuilder.InputType.CTTYPES);
            Class<?> klass = new NewInstanceClassloader(spooner.getBinaryOutputDirectory()).loadClass(this.getQualifiedName());
            return (T)klass.newInstance();
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        Set l = (Set)super.getAllExecutables();
        for (CtConstructor<T> ctConstructor : this.getConstructors()) {
            l.add(ctConstructor.getReference());
        }
        for (CtExecutable ctExecutable : this.getAnonymousExecutables()) {
            l.add(ctExecutable.getReference());
        }
        return l;
    }

    private class NewInstanceClassloader
    extends URLClassLoader {
        NewInstanceClassloader(File binaryOutputDirectory) throws MalformedURLException {
            super(new URL[]{binaryOutputDirectory.toURL()});
        }

        @Override
        public Class<?> loadClass(String s) throws ClassNotFoundException {
            try {
                return this.findClass(s);
            }
            catch (Exception e) {
                return super.loadClass(s);
            }
        }
    }
}

