/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import spoon.SpoonException;
import spoon.processing.AbstractProcessor;
import spoon.processing.ProcessInterruption;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.support.visitor.ProcessingVisitor;

public class QueueProcessingManager
implements ProcessingManager {
    Processor<?> current;
    Factory factory;
    Queue<Processor<?>> processors;
    ProcessingVisitor visitor;

    public QueueProcessingManager(Factory factory) {
        this.setFactory(factory);
    }

    @Override
    public void addProcessor(Class<? extends Processor<?>> type) {
        try {
            Processor<?> p = type.newInstance();
            this.addProcessor(p);
        }
        catch (Exception e) {
            throw new SpoonException("Unable to instantiate processor \"" + type.getName() + "\" - Your processor should have a constructor with no arguments", e);
        }
    }

    @Override
    public boolean addProcessor(Processor<?> p) {
        p.setFactory(this.getFactory());
        return this.getProcessors().add(p);
    }

    @Override
    public void addProcessor(String qualifiedName) {
        try {
            this.addProcessor(this.getFactory().getEnvironment().getClassLoader().loadClass(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            throw new SpoonException("Unable to load processor \"" + qualifiedName + "\" - Check your classpath.", e);
        }
    }

    public Processor<?> getCurrentProcessor() {
        return this.current;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    public Queue<Processor<?>> getProcessors() {
        if (this.processors == null) {
            this.processors = new LinkedList();
        }
        return this.processors;
    }

    protected ProcessingVisitor getVisitor() {
        if (this.visitor == null) {
            this.visitor = new ProcessingVisitor(this.getFactory());
        }
        return this.visitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Collection<? extends CtElement> elements) {
        Processor p;
        LinkedList processors = new LinkedList(this.getProcessors());
        while ((p = (Processor)processors.poll()) != null) {
            try {
                this.getFactory().getEnvironment().reportProgressMessage(p.getClass().getName());
                this.current = p;
                p.initProperties(AbstractProcessor.loadProperties(p));
                p.init();
                p.process();
                for (CtElement ctElement : new ArrayList<CtElement>(elements)) {
                    this.getVisitor().setProcessor(p);
                    this.getVisitor().scan(ctElement);
                }
            }
            catch (ProcessInterruption processInterruption) {}
            continue;
            finally {
                p.processingDone();
            }
        }
    }

    @Override
    public void process(CtElement element) {
        ArrayList<CtElement> l = new ArrayList<CtElement>();
        l.add(element);
        this.process(l);
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
        factory.getEnvironment().setManager(this);
    }
}

