/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.printer;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import spoon.compiler.Environment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.printer.CommentOffset;
import spoon.reflect.visitor.printer.PrinterHelper;

public class ElementPrinterHelper {
    private final DefaultJavaPrettyPrinter prettyPrinter;
    private final Environment env;
    private PrinterHelper printer;

    public ElementPrinterHelper(PrinterHelper printerHelper, DefaultJavaPrettyPrinter prettyPrinter, Environment env) {
        this.printer = printerHelper;
        this.prettyPrinter = prettyPrinter;
        this.env = env;
    }

    public void setPrinter(PrinterHelper printer) {
        this.printer = printer;
    }

    public void writeAnnotations(CtElement element) {
        for (CtAnnotation<? extends Annotation> annotation : element.getAnnotations()) {
            this.prettyPrinter.scan(annotation);
        }
    }

    public void writeModifiers(CtModifiable modifiable) {
        for (ModifierKind modifierKind : modifiable.getModifiers()) {
            this.printer.write(modifierKind.toString() + " ");
        }
    }

    public void visitCtNamedElement(CtNamedElement namedElement, CompilationUnit sourceCompilationUnit) {
        this.writeAnnotations(namedElement);
        if (this.env.isPreserveLineNumbers()) {
            this.printer.adjustPosition(namedElement, sourceCompilationUnit);
        }
    }

    public void writeExtendsClause(CtType<?> type) {
        if (type.getSuperclass() != null) {
            this.printer.write(" extends ");
            this.prettyPrinter.scan(type.getSuperclass());
        }
    }

    public void writeImplementsClause(CtType<?> type) {
        if (type.getSuperInterfaces().size() > 0) {
            this.printer.write(" implements ");
            for (CtTypeReference<?> ref : type.getSuperInterfaces()) {
                this.prettyPrinter.scan(ref);
                this.printer.write(" , ");
            }
            this.printer.removeLastChar();
        }
    }

    public void writeExecutableParameters(CtExecutable<?> executable) {
        this.printer.write("(");
        if (executable.getParameters().size() > 0) {
            for (CtParameter<?> p : executable.getParameters()) {
                this.prettyPrinter.scan(p);
                this.printer.write(", ");
            }
            this.printer.removeLastChar();
        }
        this.printer.write(")");
    }

    public void writeThrowsClause(CtExecutable<?> executable) {
        if (executable.getThrownTypes().size() > 0) {
            this.printer.write(" throws ");
            for (CtTypeReference<Throwable> ref : executable.getThrownTypes()) {
                this.prettyPrinter.scan(ref);
                this.printer.write(", ");
            }
            this.printer.removeLastChar();
        }
    }

    public void writeStatement(CtStatement statement) {
        this.prettyPrinter.scan(statement);
        if (!(statement instanceof CtBlock || statement instanceof CtIf || statement instanceof CtFor || statement instanceof CtForEach || statement instanceof CtWhile || statement instanceof CtTry || statement instanceof CtSwitch || statement instanceof CtSynchronized || statement instanceof CtClass || statement instanceof CtComment)) {
            this.printer.write(";");
        }
        this.writeComment(statement, CommentOffset.AFTER);
    }

    public void writeElementList(List<CtTypeMember> elements) {
        for (CtTypeMember element : elements) {
            if (element instanceof CtConstructor && element.isImplicit()) continue;
            this.printer.writeln().writeTabs();
            this.prettyPrinter.scan(element);
            if (this.env.isPreserveLineNumbers()) continue;
            this.printer.writeln();
        }
    }

    public void writeAnnotationElement(Factory factory, Object value) {
        if (value instanceof CtTypeAccess) {
            this.prettyPrinter.scan((CtTypeAccess)value);
            this.printer.write(".class");
        } else if (value instanceof CtFieldReference) {
            this.prettyPrinter.scan(((CtFieldReference)value).getDeclaringType());
            this.printer.write("." + ((CtFieldReference)value).getSimpleName());
        } else if (value instanceof CtElement) {
            this.prettyPrinter.scan((CtElement)value);
        } else if (value instanceof String) {
            this.printer.write("\"" + value.toString() + "\"");
        } else if (value instanceof Collection) {
            this.printer.write("{");
            if (!((Collection)value).isEmpty()) {
                for (Object obj : (Collection)value) {
                    this.writeAnnotationElement(factory, obj);
                    this.printer.write(" ,");
                }
                this.printer.removeLastChar();
            }
            this.printer.write("}");
        } else if (value instanceof Object[]) {
            this.printer.write("{");
            if (((Object[])value).length > 0) {
                for (Object obj : (Object[])value) {
                    this.writeAnnotationElement(factory, obj);
                    this.printer.write(" ,");
                }
                this.printer.removeLastChar();
            }
            this.printer.write("}");
        } else if (value instanceof Enum) {
            try (Object c = this.prettyPrinter.getContext().modify().ignoreGenerics(true);){
                this.prettyPrinter.scan(factory.Type().createReference(((Enum)value).getDeclaringClass()));
            }
            this.printer.write(".");
            this.printer.write(value.toString());
        } else {
            this.printer.write(value.toString());
        }
    }

    public void writeFormalTypeParameters(CtFormalTypeDeclarer ctFormalTypeDeclarer) {
        List<CtTypeParameter> parameters = ctFormalTypeDeclarer.getFormalCtTypeParameters();
        if (parameters == null) {
            return;
        }
        if (parameters.size() > 0) {
            this.printer.write('<');
            for (CtTypeParameter parameter : parameters) {
                this.prettyPrinter.scan(parameter);
                this.printer.write(", ");
            }
            this.printer.removeLastChar();
            this.printer.write('>');
        }
    }

    public void writeActualTypeArguments(CtActualTypeContainer ctGenericElementReference) {
        List<CtTypeReference<?>> arguments = ctGenericElementReference.getActualTypeArguments();
        if (arguments != null && arguments.size() > 0) {
            this.printer.write("<");
            boolean isImplicitTypeReference = true;
            for (CtTypeReference ctTypeReference : arguments) {
                if (ctTypeReference.isImplicit()) continue;
                isImplicitTypeReference = false;
                this.prettyPrinter.scan(ctTypeReference);
                this.printer.write(", ");
            }
            if (!isImplicitTypeReference) {
                this.printer.removeLastChar();
            }
            this.printer.write(">");
        }
    }

    public void writeHeader(List<CtType<?>> types, Collection<CtReference> imports) {
        if (!types.isEmpty()) {
            for (CtType<?> ctType : types) {
                this.writeComment(ctType, CommentOffset.TOP_FILE);
                this.printer.writeln().writeln().writeTabs();
            }
            if (!types.get(0).getPackage().isUnnamedPackage()) {
                this.printer.write("package " + types.get(0).getPackage().getQualifiedName() + ";");
            }
            this.printer.writeln().writeln().writeTabs();
            for (CtReference ref : imports) {
                if (ref instanceof CtTypeReference) {
                    CtTypeReference typeRef = (CtTypeReference)ref;
                    this.printer.write("import " + typeRef.getQualifiedName() + ";").writeln().writeTabs();
                    continue;
                }
                if (ref instanceof CtExecutableReference) {
                    CtExecutableReference execRef = (CtExecutableReference)ref;
                    if (execRef.getDeclaringType() == null) continue;
                    this.printer.write("import static " + this.removeInnerTypeSeparator(execRef.getDeclaringType().getQualifiedName()) + "." + execRef.getSimpleName() + ";").writeln().writeTabs();
                    continue;
                }
                if (!(ref instanceof CtFieldReference)) continue;
                CtFieldReference fieldRef = (CtFieldReference)ref;
                this.printer.write("import static " + this.removeInnerTypeSeparator(fieldRef.getDeclaringType().getQualifiedName()) + "." + fieldRef.getSimpleName() + ";").writeln().writeTabs();
            }
            this.printer.writeln().writeTabs();
        }
    }

    private String removeInnerTypeSeparator(String fqn) {
        return fqn.replace("$", ".");
    }

    public void writeComment(CtComment comment) {
        if (!this.env.isCommentsEnabled() || comment == null) {
            return;
        }
        this.prettyPrinter.scan(comment);
        this.printer.writeln().writeTabs();
    }

    private void writeComment(List<CtComment> comments) {
        if (!this.env.isCommentsEnabled() || comments == null) {
            return;
        }
        for (CtComment comment : comments) {
            this.writeComment(comment);
        }
    }

    public void writeComment(CtElement element) {
        if (element == null) {
            return;
        }
        this.writeComment(element.getComments());
    }

    public void writeComment(CtElement element, CommentOffset offset) {
        this.writeComment(this.getComments(element, offset));
    }

    public List<CtComment> getComments(CtElement element, CommentOffset offset) {
        ArrayList<CtComment> commentsToPrint = new ArrayList<CtComment>();
        if (!this.env.isCommentsEnabled() || element == null) {
            return commentsToPrint;
        }
        for (CtComment comment : element.getComments()) {
            if (comment.getCommentType() == CtComment.CommentType.FILE && offset == CommentOffset.TOP_FILE) {
                commentsToPrint.add(comment);
                continue;
            }
            if (comment.getCommentType() == CtComment.CommentType.FILE) continue;
            if (comment.getPosition() == null || element.getPosition() == null) {
                if (offset != CommentOffset.BEFORE) continue;
                commentsToPrint.add(comment);
                continue;
            }
            int line = element.getPosition().getLine();
            int sourceEnd = element.getPosition().getSourceEnd();
            int sourceStart = element.getPosition().getSourceStart();
            if (offset == CommentOffset.BEFORE && (comment.getPosition().getLine() < line || sourceStart <= comment.getPosition().getSourceStart() && sourceEnd >= comment.getPosition().getSourceEnd())) {
                commentsToPrint.add(comment);
                continue;
            }
            if (offset == CommentOffset.AFTER && comment.getPosition().getSourceStart() > sourceEnd) {
                commentsToPrint.add(comment);
                continue;
            }
            int endLine = element.getPosition().getEndLine();
            if (offset != CommentOffset.INSIDE || comment.getPosition().getLine() < line || comment.getPosition().getEndLine() > endLine) continue;
            commentsToPrint.add(comment);
        }
        return commentsToPrint;
    }

    public void writeIfOrLoopBlock(CtStatement block) {
        if (block != null) {
            if (!block.isImplicit() && (block instanceof CtBlock || block instanceof CtIf)) {
                this.printer.write(" ");
            }
            if (!(block instanceof CtBlock) && !(block instanceof CtIf)) {
                this.printer.incTab();
                this.printer.writeln().writeTabs();
            }
            this.writeStatement(block);
            if (!(block instanceof CtBlock) && !(block instanceof CtIf)) {
                this.printer.decTab().writeln().writeTabs();
            }
            if (!(block.isImplicit() || block.isParentInitialized() && (block.getParent() instanceof CtFor || block.getParent() instanceof CtForEach || block.getParent() instanceof CtIf))) {
                this.printer.write(" ");
            }
        } else {
            this.printer.write(";");
        }
    }
}

