/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.visitor.filter.TypeFilter;

public class LineFilter
extends TypeFilter<CtStatement> {
    public LineFilter() {
        super(CtStatement.class);
    }

    @Override
    public boolean matches(CtStatement element) {
        CtElement parent;
        if (!super.matches(element)) {
            return false;
        }
        if (element instanceof CtBlock) {
            return false;
        }
        try {
            parent = element.getParent();
        }
        catch (ParentNotInitializedException e) {
            return false;
        }
        if (parent instanceof CtStatementList) {
            return true;
        }
        if (parent instanceof CtIf) {
            CtIf anIf = (CtIf)parent;
            return element.equals(anIf.getThenStatement()) || element.equals(anIf.getElseStatement());
        }
        if (parent instanceof CtLoop) {
            CtLoop loop = (CtLoop)parent;
            return loop.getBody().equals(element);
        }
        return false;
    }
}

