/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.chain;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtFunction;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.QueryFailurePolicy;

public class CtQueryImpl<O>
implements CtQuery<O> {
    private List<Object> inputs;
    private Step firstStep;
    private Step lastStep;
    private Step tail;
    private boolean logging = false;
    private QueryFailurePolicy failurePolicy = QueryFailurePolicy.FAIL;

    public CtQueryImpl() {
        this.tail = new TailConsumer();
        this.tail.setName("TailConsumer");
        this.firstStep = this.tail;
        this.lastStep = this.tail;
    }

    public <T> CtQueryImpl(T input) {
        this();
        this.setInput(input);
    }

    public List<Object> getInputs() {
        return this.inputs == null ? Collections.emptyList() : this.inputs;
    }

    public CtQuery<O> setInput(O input) {
        if (this.inputs != null) {
            this.inputs.clear();
        }
        return this.addInput(input);
    }

    public CtQuery<O> addInput(O input) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Object>();
        }
        this.inputs.add(input);
        return this;
    }

    @Override
    public <I, R> CtQuery<R> map(CtFunction<I, R> function) {
        this.add(new FunctionWrapper(function));
        return this;
    }

    @Override
    public <T extends CtElement> CtQuery<T> filterChildren(Filter<T> filter) {
        this.add(new ChildrenFilteringWrapper(filter));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEach(CtConsumer<O> output, Object input) {
        this.tail.setNext(output);
        try {
            if (input == null) {
                if (this.inputs != null) {
                    for (Object in : this.inputs) {
                        this.firstStep.accept(in);
                    }
                }
            } else {
                if (this.inputs != null) {
                    throw new SpoonException("Do not add QueryStep inputs if you want to use query for extra input");
                }
                this.firstStep.accept(input);
            }
        }
        finally {
            this.tail.setNext(null);
        }
    }

    @Override
    public List<O> list() {
        final ArrayList list = new ArrayList();
        this.forEach(new CtConsumer<O>(){

            @Override
            public void accept(O out) {
                list.add(out);
            }
        }, null);
        return list;
    }

    @Override
    public CtQuery<O> name(String name) {
        if (this.lastStep == this.tail) {
            throw new SpoonException("Cannot set name of the step on the chain with no step");
        }
        this.lastStep.setName(name);
        return this;
    }

    @Override
    public CtQuery<O> failurePolicy(QueryFailurePolicy policy) {
        if (this.lastStep == this.tail) {
            throw new SpoonException("Cannot set ignoreIncompatibleInput of the step on the chain with no step");
        }
        this.failurePolicy = policy;
        return this;
    }

    private boolean isLogging() {
        return this.logging;
    }

    public CtQuery<O> logging(boolean logging) {
        this.logging = logging;
        return this;
    }

    private void add(Step step) {
        if (this.lastStep == this.tail) {
            this.firstStep = step;
            this.lastStep = step;
        } else {
            this.lastStep.setNext(step);
            this.lastStep = step;
        }
        step.setNext(this.tail);
        this.name(String.valueOf(this.getLength()));
    }

    public int getLength() {
        int len = 0;
        for (Step s = this.firstStep; s != this.tail; s = (Step)s.getNext()) {
            ++len;
        }
        return len;
    }

    private void onClassCastException(Step step, ClassCastException e, Object ... parameters) {
        if (step.isFailOnCCE()) {
            throw e;
        }
        if (Launcher.LOGGER.isTraceEnabled()) {
            Launcher.LOGGER.trace((Object)e);
        }
        this.log(step, e.getMessage(), parameters);
    }

    private void log(Step step, String message, Object ... parameters) {
        if (this.isLogging() && Launcher.LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("Step ");
            sb.append(step.getName()).append(") ");
            sb.append(message);
            for (int i = 0; i < parameters.length; ++i) {
                sb.append("\nParameter ").append(i + 1).append(") ");
                sb.append(parameters[i]);
            }
            Launcher.LOGGER.info((Object)sb.toString());
        }
    }

    private static interface CtConsumer<T> {
        public void accept(T var1);
    }

    private class ChildrenFilteringWrapper
    extends CtScanner
    implements Step {
        private String name;
        protected CtConsumer<Object> next;
        private Filter<CtElement> filter;

        ChildrenFilteringWrapper(Filter<? extends CtElement> filter) {
            this.filter = filter;
        }

        @Override
        public void accept(Object input) {
            if (input == null) {
                return;
            }
            CtQueryImpl.this.log(this, "CtScanner received", new Object[]{input});
            this.scan(input);
        }

        @Override
        public void scan(CtElement element) {
            this.processFilter(element);
            super.scan(element);
        }

        private void processFilter(CtElement element) {
            if (element == null) {
                return;
            }
            boolean matches = false;
            try {
                matches = this.filter.matches(element);
            }
            catch (ClassCastException e) {
                CtQueryImpl.this.onClassCastException(this, e, new Object[]{element});
                return;
            }
            if (matches) {
                this.next.accept(element);
            } else {
                CtQueryImpl.this.log(this, "Skipped child element, because Filter#matches(input) returned false", new Object[]{element});
            }
        }

        @Override
        public CtConsumer<Object> getNext() {
            return this.next;
        }

        @Override
        public void setNext(CtConsumer<Object> next) {
            this.next = next;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public boolean isFailOnCCE() {
            return false;
        }
    }

    private class FunctionWrapper
    extends AbstractStep {
        private CtFunction<Object, Object> fnc;

        FunctionWrapper(CtFunction<?, ?> code) {
            this.fnc = code;
        }

        @Override
        public void processInput(Object input) {
            Object result;
            try {
                result = this.fnc.apply(input);
            }
            catch (ClassCastException e) {
                CtQueryImpl.this.onClassCastException(this, e, new Object[]{input});
                return;
            }
            if (result == null) {
                return;
            }
            if (result instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    this.next.accept(input);
                } else {
                    CtQueryImpl.this.log(this, "Skipped element, because CtFunction#accept(input) returned false", new Object[]{input});
                }
                return;
            }
            if (result instanceof Iterable) {
                for (Object out : (Iterable)result) {
                    this.next.accept(out);
                }
                return;
            }
            if (result.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(result); ++i) {
                    this.next.accept(Array.get(result, i));
                }
                return;
            }
            this.next.accept(result);
        }
    }

    private class TailConsumer
    extends AbstractStep {
        private TailConsumer() {
        }

        @Override
        public void processInput(Object out) {
            if (this.next != null) {
                try {
                    this.next.accept(out);
                }
                catch (ClassCastException e) {
                    CtQueryImpl.this.onClassCastException(this, e, new Object[]{out});
                }
            }
        }
    }

    private abstract class AbstractStep
    implements Step {
        private String name;
        protected CtConsumer<Object> next;

        private AbstractStep() {
        }

        @Override
        public CtConsumer<Object> getNext() {
            return this.next;
        }

        @Override
        public void setNext(CtConsumer<Object> next) {
            this.next = next;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public boolean isFailOnCCE() {
            return CtQueryImpl.this.failurePolicy == QueryFailurePolicy.FAIL;
        }

        @Override
        public final void accept(Object input) {
            if (input == null) {
                return;
            }
            CtQueryImpl.this.log(this, "received", new Object[]{input});
            this.processInput(input);
        }

        protected abstract void processInput(Object var1);
    }

    private static interface Step
    extends CtConsumer<Object> {
        public CtConsumer<Object> getNext();

        public void setNext(CtConsumer<Object> var1);

        public String getName();

        public void setName(String var1);

        public boolean isFailOnCCE();
    }
}

