/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;

public class ExecutableFactory
extends SubFactory {
    public ExecutableFactory(Factory factory) {
        super(factory);
    }

    public CtAnonymousExecutable createAnonymous(CtClass<?> target, CtBlock<Void> body) {
        CtAnonymousExecutable a = this.factory.Core().createAnonymousExecutable();
        target.addAnonymousExecutable(a);
        a.setBody(body);
        return a;
    }

    public <T> CtParameter<T> createParameter(CtExecutable<?> parent, CtTypeReference<T> type, String name) {
        CtParameter<T> parameter = this.factory.Core().createParameter();
        parameter.setType(type);
        parameter.setSimpleName(name);
        if (parent != null) {
            parent.addParameter(parameter);
        }
        return parameter;
    }

    public <T> CtParameterReference<T> createParameterReference(CtParameter<T> parameter) {
        CtParameterReference ref = this.factory.Core().createParameterReference();
        if (parameter.getParent() != null) {
            ref.setDeclaringExecutable(this.factory.Executable().createReference(parameter.getParent()));
        }
        ref.setSimpleName(parameter.getSimpleName());
        ref.setType(parameter.getType());
        return ref;
    }

    public <T> CtExecutableReference<T> createReference(CtExecutable<T> e) {
        CtTypeReference[] refs = new CtTypeReference[e.getParameters().size()];
        int i = 0;
        for (CtParameter<?> param : e.getParameters()) {
            refs[i++] = param.getType() != null ? param.getType().clone() : this.factory.Type().OBJECT.clone();
        }
        String executableName = e.getSimpleName();
        if (e instanceof CtMethod) {
            boolean isStatic = ((CtMethod)e).hasModifier(ModifierKind.STATIC);
            return this.createReference(((CtMethod)e).getDeclaringType().getReference(), isStatic, ((CtMethod)e).getType().clone(), executableName, refs);
        }
        if (e instanceof CtLambda) {
            return this.createReference(e.getParent(CtType.class).getReference(), e.getType(), executableName, refs);
        }
        if (e instanceof CtAnonymousExecutable) {
            return this.createReference(((CtAnonymousExecutable)e).getDeclaringType().getReference(), e.getType().clone(), executableName, new CtTypeReference[0]);
        }
        return this.createReference(((CtConstructor)e).getDeclaringType().getReference(), ((CtConstructor)e).getType().clone(), "<init>", refs);
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, CtTypeReference<T> type, String methodName, CtTypeReference<?> ... parameterTypes) {
        return this.createReference(declaringType, false, type, methodName, parameterTypes);
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, boolean isStatic, CtTypeReference<T> type, String methodName, CtTypeReference<?> ... parameterTypes) {
        return this.createReference(declaringType, isStatic, type, methodName, Arrays.asList(parameterTypes));
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, boolean isStatic, CtTypeReference<T> type, String methodName, List<CtTypeReference<?>> parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setStatic(isStatic);
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList(parameterTypes);
        methodRef.setParameters(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, CtTypeReference<T> type, String methodName, List<CtTypeReference<?>> parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList(parameterTypes);
        methodRef.setParameters(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(String signature) {
        CtExecutableReference executableRef = this.factory.Core().createExecutableReference();
        String type = signature.substring(0, signature.indexOf(" "));
        String declaringType = signature.substring(signature.indexOf(" ") + 1, signature.indexOf("#"));
        String executableName = signature.substring(signature.indexOf("#") + 1, signature.indexOf("("));
        executableRef.setSimpleName(executableName);
        executableRef.setDeclaringType(this.factory.Type().createReference(declaringType));
        CtTypeReference typeRef = this.factory.Type().createReference(type);
        executableRef.setType(typeRef);
        String parameters = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
        ArrayList params = new ArrayList(2);
        StringTokenizer t = new StringTokenizer(parameters, ",");
        while (t.hasMoreTokens()) {
            String paramType = t.nextToken();
            params.add(this.factory.Type().createReference(paramType));
        }
        executableRef.setParameters(params);
        return executableRef;
    }
}

