/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

public class SignaturePrinter
extends CtScanner {
    private final StringBuffer signature = new StringBuffer();

    public String getSignature() {
        return this.signature.toString();
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.scan(reference.getComponentType());
        this.write("[]");
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.scan(reference.getDeclaringType());
        this.write("#");
        if (reference.isConstructor()) {
            this.write(reference.getDeclaringType().getSimpleName());
        } else {
            this.write(reference.getSimpleName());
        }
        this.write("(");
        if (reference.getParameters().size() > 0) {
            for (CtTypeReference<?> param : reference.getParameters()) {
                if (param != null && !"null".equals(param.getSimpleName())) {
                    this.scan(param);
                } else {
                    this.write("<unknown>");
                }
                this.write(", ");
            }
            if (reference.getParameters().size() > 0) {
                this.clearLast();
                this.clearLast();
            }
        }
        this.write(")");
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        this.write(reference.getQualifiedName());
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.write(ref.getQualifiedName());
        if (ref.getBoundingType() != null) {
            if (ref.isUpper()) {
                this.write(" extends ");
            } else {
                this.write(" super ");
            }
            this.scan(ref.getBoundingType());
        }
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        for (CtTypeReference<?> bound : reference.getBounds()) {
            this.scan(bound);
            this.write(", ");
        }
        this.clearLast();
        this.clearLast();
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        if (c.getDeclaringType() != null) {
            this.write(c.getDeclaringType().getQualifiedName());
        }
        this.write("(");
        for (CtParameter<?> p : c.getParameters()) {
            this.scan(p.getType());
            this.write(",");
        }
        if (c.getParameters().size() > 0) {
            this.clearLast();
        }
        this.write(")");
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        this.visitCtMethod(annotationMethod);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        if (!m.getFormalCtTypeParameters().isEmpty()) {
            this.write("<");
            for (CtTypeParameter ctTypeParameter : m.getFormalCtTypeParameters()) {
                this.scan(ctTypeParameter.getReference());
                this.write(",");
            }
            if (m.getFormalCtTypeParameters().size() > 0) {
                this.clearLast();
            }
            this.write("> ");
        }
        if (m.getType() != null) {
            this.write(m.getType().getQualifiedName());
        }
        this.write(" ");
        this.write(m.getSimpleName());
        this.write("(");
        for (CtParameter ctParameter : m.getParameters()) {
            this.scan(ctParameter.getType());
            this.write(",");
        }
        if (!m.getParameters().isEmpty()) {
            this.clearLast();
        }
        this.write(")");
    }

    private SignaturePrinter clearLast() {
        this.signature.deleteCharAt(this.signature.length() - 1);
        return this;
    }

    protected SignaturePrinter write(String value) {
        this.signature.append(value);
        return this;
    }
}

