/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.reference.CtReferenceImpl;
import spoon.support.util.QualifiedNameBasedSortedSet;
import spoon.support.util.RtHelper;

public class CtTypeReferenceImpl<T>
extends CtReferenceImpl
implements CtTypeReference<T> {
    private static final long serialVersionUID = 1L;
    List<CtTypeReference<?>> actualTypeArguments = CtElementImpl.emptyList();
    CtTypeReference<?> declaringType;
    private CtPackageReference pack;
    boolean isShadow;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtTypeReference(this);
    }

    @Override
    public CtTypeReference<?> box() {
        if (!this.isPrimitive()) {
            return this;
        }
        if (this.getSimpleName().equals("int")) {
            return this.getFactory().Type().createReference(Integer.class);
        }
        if (this.getSimpleName().equals("float")) {
            return this.getFactory().Type().createReference(Float.class);
        }
        if (this.getSimpleName().equals("long")) {
            return this.getFactory().Type().createReference(Long.class);
        }
        if (this.getSimpleName().equals("char")) {
            return this.getFactory().Type().createReference(Character.class);
        }
        if (this.getSimpleName().equals("double")) {
            return this.getFactory().Type().createReference(Double.class);
        }
        if (this.getSimpleName().equals("boolean")) {
            return this.getFactory().Type().createReference(Boolean.class);
        }
        if (this.getSimpleName().equals("short")) {
            return this.getFactory().Type().createReference(Short.class);
        }
        if (this.getSimpleName().equals("byte")) {
            return this.getFactory().Type().createReference(Byte.class);
        }
        if (this.getSimpleName().equals("void")) {
            return this.getFactory().Type().createReference(Void.class);
        }
        return this;
    }

    @Override
    public Class<T> getActualClass() {
        if (this.isPrimitive()) {
            String simpleN = this.getSimpleName();
            if ("boolean".equals(simpleN)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(simpleN)) {
                return Byte.TYPE;
            }
            if ("double".equals(simpleN)) {
                return Double.TYPE;
            }
            if ("int".equals(simpleN)) {
                return Integer.TYPE;
            }
            if ("short".equals(simpleN)) {
                return Short.TYPE;
            }
            if ("char".equals(simpleN)) {
                return Character.TYPE;
            }
            if ("long".equals(simpleN)) {
                return Long.TYPE;
            }
            if ("float".equals(simpleN)) {
                return Float.TYPE;
            }
            if ("void".equals(simpleN)) {
                return Void.TYPE;
            }
        }
        return this.findClass();
    }

    protected Class<T> findClass() {
        try {
            return this.getFactory().getEnvironment().getClassLoader().loadClass(this.getQualifiedName());
        }
        catch (Throwable e) {
            throw new SpoonClassNotFoundException("cannot load class: " + this.getQualifiedName(), e);
        }
    }

    @Override
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        return this.getActualClass();
    }

    @Override
    public CtType<T> getDeclaration() {
        return this.getFactory().Type().get(this.getQualifiedName());
    }

    @Override
    public CtType<T> getTypeDeclaration() {
        CtType t = this.getFactory().Type().get(this.getQualifiedName());
        if (t != null) {
            return t;
        }
        return this.getFactory().Type().get(this.getActualClass());
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public CtPackageReference getPackage() {
        return this.pack;
    }

    @Override
    public String getQualifiedName() {
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        if (this.getPackage() != null && !this.getPackage().isUnnamedPackage()) {
            return this.getPackage().getSimpleName() + "." + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public boolean isAssignableFrom(CtTypeReference<?> type) {
        return type != null && type.isSubtypeOf(this);
    }

    @Override
    public boolean isPrimitive() {
        return "boolean".equals(this.getSimpleName()) || "byte".equals(this.getSimpleName()) || "double".equals(this.getSimpleName()) || "int".equals(this.getSimpleName()) || "short".equals(this.getSimpleName()) || "char".equals(this.getSimpleName()) || "long".equals(this.getSimpleName()) || "float".equals(this.getSimpleName()) || "void".equals(this.getSimpleName());
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        if (type instanceof CtTypeParameterReference) {
            return false;
        }
        if ("<nulltype>".equals(this.getSimpleName()) || "<nulltype>".equals(type.getSimpleName())) {
            return false;
        }
        if (this.isPrimitive() || type.isPrimitive()) {
            return this.equals(type);
        }
        CtType<?> superTypeDecl = type.getDeclaration();
        CtElement subTypeDecl = this.getDeclaration();
        if (subTypeDecl == null && superTypeDecl == null) {
            try {
                if (this instanceof CtArrayTypeReference && type instanceof CtArrayTypeReference) {
                    return ((CtArrayTypeReference)((Object)this)).getComponentType().isSubtypeOf(((CtArrayTypeReference)type).getComponentType());
                }
                Class<T> actualSubType = this.getActualClass();
                Class<T> actualSuperType = type.getActualClass();
                return actualSuperType.isAssignableFrom(actualSubType);
            }
            catch (Exception e) {
                Launcher.LOGGER.error((Object)("cannot determine runtime types for '" + this + "' (" + this.getQualifiedName() + ") and '" + type + "' (" + type.getQualifiedName() + ")"), (Throwable)e);
                return false;
            }
        }
        if (this.getQualifiedName().equals(type.getQualifiedName())) {
            return true;
        }
        if (subTypeDecl != null) {
            if (this.getFactory().Type().OBJECT.equals(type)) {
                return true;
            }
            for (CtTypeReference<?> ref : subTypeDecl.getSuperInterfaces()) {
                if (!ref.isSubtypeOf(type)) continue;
                return true;
            }
            if (subTypeDecl instanceof CtClass && ((CtClass)subTypeDecl).getSuperclass() != null) {
                if (((CtClass)subTypeDecl).getSuperclass().equals(type)) {
                    return true;
                }
                return ((CtClass)subTypeDecl).getSuperclass().isSubtypeOf(type);
            }
            return false;
        }
        try {
            Class<T> actualSubType = this.getActualClass();
            for (Class<?> c : actualSubType.getInterfaces()) {
                if (!this.getFactory().Type().createReference(c).isSubtypeOf(type)) continue;
                return true;
            }
            CtTypeReference<T> superType = this.getFactory().Type().createReference(actualSubType.getSuperclass());
            return superType != null && (superType.equals(type) || superType.isSubtypeOf(type));
        }
        catch (Exception e) {
            Launcher.LOGGER.error((Object)("cannot determine runtime types for '" + this + "' and '" + type + "'"), (Throwable)e);
            return false;
        }
    }

    public <C extends CtActualTypeContainer> C setActualTypeArguments(List<? extends CtTypeReference<?>> actualTypeArguments) {
        if (actualTypeArguments == null || actualTypeArguments.isEmpty()) {
            this.actualTypeArguments = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList(2);
        }
        this.actualTypeArguments.clear();
        for (CtTypeReference<?> actualTypeArgument : actualTypeArguments) {
            this.addActualTypeArgument(actualTypeArgument);
        }
        return (C)this;
    }

    @Override
    public <C extends CtTypeReference<T>> C setDeclaringType(CtTypeReference<?> declaringType) {
        if (declaringType != null) {
            declaringType.setParent(this);
        }
        this.declaringType = declaringType;
        return (C)this;
    }

    @Override
    public <C extends CtTypeReference<T>> C setPackage(CtPackageReference pack) {
        if (pack != null) {
            pack.setParent(this);
        }
        this.pack = pack;
        return (C)this;
    }

    @Override
    public void replace(CtTypeReference<?> reference) {
        super.replace(reference);
    }

    @Override
    public CtIntersectionTypeReference<T> asCtIntersectionTypeReference() {
        return (CtIntersectionTypeReference)((Object)this);
    }

    @Override
    public CtTypeReference<?> unbox() {
        Class<T> actualClass;
        if (this.isPrimitive()) {
            return this;
        }
        try {
            actualClass = this.getActualClass();
        }
        catch (SpoonClassNotFoundException e) {
            return this;
        }
        if (actualClass == Integer.class) {
            return this.getFactory().Type().createReference(Integer.TYPE);
        }
        if (actualClass == Float.class) {
            return this.getFactory().Type().createReference(Float.TYPE);
        }
        if (actualClass == Long.class) {
            return this.getFactory().Type().createReference(Long.TYPE);
        }
        if (actualClass == Character.class) {
            return this.getFactory().Type().createReference(Character.TYPE);
        }
        if (actualClass == Double.class) {
            return this.getFactory().Type().createReference(Double.TYPE);
        }
        if (actualClass == Boolean.class) {
            return this.getFactory().Type().createReference(Boolean.TYPE);
        }
        if (actualClass == Short.class) {
            return this.getFactory().Type().createReference(Short.TYPE);
        }
        if (actualClass == Byte.class) {
            return this.getFactory().Type().createReference(Byte.TYPE);
        }
        if (actualClass == Void.class) {
            return this.getFactory().Type().createReference(Void.TYPE);
        }
        return this;
    }

    @Override
    public Collection<CtFieldReference<?>> getDeclaredFields() {
        CtElement t = this.getDeclaration();
        if (t == null) {
            try {
                return this.getDeclaredFieldReferences();
            }
            catch (SpoonClassNotFoundException cnfe) {
                this.handleParentNotFound(cnfe);
                return Collections.emptyList();
            }
        }
        return t.getDeclaredFields();
    }

    private Collection<CtFieldReference<?>> getDeclaredFieldReferences() {
        ArrayList references = new ArrayList();
        for (Field field : this.getDeclaredFields(this.getActualClass())) {
            references.add(this.getFactory().Field().createReference(field));
        }
        if (this.getActualClass().isAnnotation()) {
            for (AccessibleObject accessibleObject : this.getActualClass().getDeclaredMethods()) {
                CtTypeReference<?> retRef = this.getFactory().Type().createReference(((Method)accessibleObject).getReturnType());
                CtFieldReference<?> fr = this.getFactory().Field().createReference(this, retRef, ((Method)accessibleObject).getName());
                references.add(fr);
            }
        }
        return references;
    }

    private Field[] getDeclaredFields(Class<?> cls) {
        try {
            return cls.getDeclaredFields();
        }
        catch (Throwable e) {
            throw new SpoonClassNotFoundException("cannot load fields of class: " + this.getQualifiedName(), e);
        }
    }

    private void handleParentNotFound(SpoonClassNotFoundException cnfe) {
        String msg = "cannot load class: " + this.getQualifiedName() + " with class loader " + Thread.currentThread().getContextClassLoader();
        if (this.getFactory().getEnvironment().getNoClasspath()) {
            Launcher.LOGGER.warn((Object)msg);
            return;
        }
        throw cnfe;
    }

    @Override
    public CtFieldReference<?> getDeclaredField(String name) {
        if (name == null) {
            return null;
        }
        CtElement t = this.getDeclaration();
        if (t == null) {
            try {
                Collection<CtFieldReference<?>> fields = this.getDeclaredFieldReferences();
                for (CtFieldReference<?> field : fields) {
                    if (!name.equals(field.getSimpleName())) continue;
                    return field;
                }
            }
            catch (SpoonClassNotFoundException cnfe) {
                this.handleParentNotFound(cnfe);
                return null;
            }
            return null;
        }
        return t.getDeclaredField(name);
    }

    @Override
    public CtFieldReference<?> getDeclaredOrInheritedField(String fieldName) {
        CtElement t = this.getDeclaration();
        if (t == null) {
            CtFieldReference<?> field = this.getDeclaredField(fieldName);
            if (field != null) {
                return field;
            }
            CtTypeReference<?> typeRef = this.getSuperclass();
            if (typeRef != null && (field = typeRef.getDeclaredOrInheritedField(fieldName)) != null) {
                return field;
            }
            Set<CtTypeReference<?>> ifaces = this.getSuperInterfaces();
            for (CtTypeReference<?> iface : ifaces) {
                field = iface.getDeclaredOrInheritedField(fieldName);
                if (field == null) continue;
                return field;
            }
            return field;
        }
        return t.getDeclaredOrInheritedField(fieldName);
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        CtElement t = this.getDeclaration();
        if (t == null) {
            return RtHelper.getAllExecutables(this.getActualClass(), this.getFactory());
        }
        return t.getDeclaredExecutables();
    }

    @Override
    public Collection<CtFieldReference<?>> getAllFields() {
        try {
            CtType<T> t = this.getTypeDeclaration();
            return t.getAllFields();
        }
        catch (SpoonClassNotFoundException cnfe) {
            this.handleParentNotFound(cnfe);
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        ArrayList l = new ArrayList();
        CtType<T> t = this.getTypeDeclaration();
        if (t != null) {
            l.addAll(t.getAllExecutables());
        }
        return l;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            return t.getModifiers();
        }
        Class<T> c = this.getActualClass();
        return RtHelper.getModifiers(c.getModifiers());
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            return t.getSuperclass();
        }
        Class<T> c = this.getActualClass();
        Class<T> sc = c.getSuperclass();
        if (sc == null) {
            return null;
        }
        return this.getFactory().Type().createReference(sc);
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            return t.getSuperInterfaces();
        }
        Class<T> c = this.getActualClass();
        Class<?>[] sis = c.getInterfaces();
        if (sis != null && sis.length > 0) {
            QualifiedNameBasedSortedSet set = new QualifiedNameBasedSortedSet();
            for (Class<?> si : sis) {
                set.add(this.getFactory().Type().createReference(si));
            }
            return set;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isAnonymous() {
        try {
            Integer.parseInt(this.getSimpleName());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isLocalType() {
        if (this.getDeclaration() != null) {
            return this.getDeclaration().isLocalType();
        }
        Pattern pattern = Pattern.compile("^([0-9]+)([a-zA-Z]+)$");
        Matcher m = pattern.matcher(this.getSimpleName());
        return m.find();
    }

    public <C extends CtActualTypeContainer> C addActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (actualTypeArgument == null) {
            return (C)this;
        }
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList(2);
        }
        actualTypeArgument.setParent(this);
        this.actualTypeArguments.add(actualTypeArgument);
        return (C)this;
    }

    @Override
    public boolean removeActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        return this.actualTypeArguments != CtElementImpl.emptyList() && this.actualTypeArguments.remove(actualTypeArgument);
    }

    @Override
    public boolean isInterface() {
        CtElement t = this.getDeclaration();
        if (t == null) {
            return this.getActualClass().isInterface();
        }
        return t.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        CtElement t = this.getDeclaration();
        if (t == null) {
            return this.getActualClass().isAnnotation();
        }
        return t.isAnnotationType();
    }

    @Override
    public boolean isGenerics() {
        return false;
    }

    @Override
    public boolean canAccess(CtTypeReference<?> type) {
        try {
            Set<ModifierKind> modifiers = type.getModifiers();
            if (modifiers.contains((Object)ModifierKind.PUBLIC)) {
                return true;
            }
            if (modifiers.contains((Object)ModifierKind.PROTECTED) && this.isSubtypeOf(type)) {
                return true;
            }
            if (modifiers.contains((Object)ModifierKind.PRIVATE)) {
                return type.getTopLevelType().getQualifiedName().equals(this.getQualifiedName());
            }
            return type.getTopLevelType().getPackage().getSimpleName().equals(this.getTopLevelType().getPackage().getSimpleName());
        }
        catch (SpoonClassNotFoundException e) {
            this.handleParentNotFound(e);
            return true;
        }
    }

    @Override
    public CtTypeReference<?> getTopLevelType() {
        CtTypeReference<Object> type = this;
        CtTypeReference<?> parentType;
        while ((parentType = type.getDeclaringType()) != null) {
            type = parentType;
        }
        return type;
    }

    @Override
    public CtTypeReference<?> getAccessType() {
        CtTypeReference<?> declType = this.getDeclaringType();
        if (declType == null) {
            throw new SpoonException("The nestedType is expected, but it is: " + this.getQualifiedName());
        }
        CtType contextType = this.getParent(CtType.class);
        if (contextType == null) {
            return declType;
        }
        CtTypeReference contextTypeRef = contextType.getReference();
        if (contextType != null && !contextTypeRef.canAccess(declType)) {
            CtTypeReference visibleDeclType = null;
            for (CtTypeReference<Object> type = contextTypeRef; visibleDeclType == null && type != null; type = type.getDeclaringType()) {
                visibleDeclType = CtTypeReferenceImpl.getLastVisibleSuperClassExtendingFrom(type, declType);
                if (visibleDeclType == null) continue;
                CtTypeReferenceImpl.applyActualTypeArguments(visibleDeclType, declType);
                break;
            }
            declType = visibleDeclType;
        }
        return declType;
    }

    private static void applyActualTypeArguments(CtTypeReference<?> targetTypeRef, CtTypeReference<?> sourceTypeRef) {
        CtTypeReference<?> targetDeclType = targetTypeRef.getDeclaringType();
        CtTypeReference<?> sourceDeclType = sourceTypeRef.getDeclaringType();
        if (targetDeclType != null && sourceDeclType != null && targetDeclType.isSubtypeOf(sourceDeclType)) {
            CtTypeReferenceImpl.applyActualTypeArguments(targetDeclType, sourceDeclType);
        }
        if (!targetTypeRef.isSubtypeOf(sourceTypeRef)) {
            throw new SpoonException("Invalid arguments. targetTypeRef " + targetTypeRef.getQualifiedName() + " must be a sub type of sourceTypeRef " + sourceTypeRef.getQualifiedName());
        }
        ArrayList newTypeArgs = new ArrayList();
        for (CtTypeReference<?> l_tr : sourceTypeRef.getActualTypeArguments()) {
            newTypeArgs.add(l_tr.clone());
        }
        targetTypeRef.setActualTypeArguments(newTypeArgs);
    }

    private static CtTypeReference<?> getLastVisibleSuperClassExtendingFrom(CtTypeReference<?> sourceType, CtTypeReference<?> targetType) {
        String targetQN = targetType.getQualifiedName();
        CtTypeReference<?> adept = sourceType;
        CtTypeReference<?> type = sourceType;
        while (!targetQN.equals(type.getQualifiedName())) {
            if ((type = type.getSuperclass()) == null) {
                return null;
            }
            if (!sourceType.canAccess(type)) continue;
            adept = type;
        }
        return adept;
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtTypeReference<T> clone() {
        return (CtTypeReference)super.clone();
    }
}

