/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Set;
import spoon.Launcher;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.reference.CtVariableReferenceImpl;
import spoon.support.util.RtHelper;

public class CtFieldReferenceImpl<T>
extends CtVariableReferenceImpl<T>
implements CtFieldReference<T> {
    private static final long serialVersionUID = 1L;
    CtTypeReference<?> declaringType;
    boolean fina = false;
    boolean stat = false;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtFieldReference(this);
    }

    @Override
    public Member getActualField() {
        try {
            if (this.getDeclaringType().getActualClass().isAnnotation()) {
                return this.getDeclaringType().getActualClass().getDeclaredMethod(this.getSimpleName(), new Class[0]);
            }
            return this.getDeclaringType().getActualClass().getDeclaredField(this.getSimpleName());
        }
        catch (Exception e) {
            Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        return (AnnotatedElement)((Object)this.getActualField());
    }

    @Override
    public CtField<T> getDeclaration() {
        CtField<T> ctField = this.lookupDynamically();
        if (ctField != null) {
            return ctField;
        }
        return this.fromDeclaringType();
    }

    private CtField<T> lookupDynamically() {
        CtElement element = this;
        CtField<?> optional = null;
        String name = this.getSimpleName();
        try {
            do {
                CtType type;
                if ((type = element.getParent(CtType.class)) == null) {
                    return null;
                }
                CtField<?> potential = type.getField(name);
                if (potential != null) {
                    optional = potential;
                }
                element = type;
            } while (optional == null);
        }
        catch (ParentNotInitializedException e) {
            return null;
        }
        return optional;
    }

    private CtField<T> fromDeclaringType() {
        if (this.declaringType == null) {
            return null;
        }
        CtType<?> type = this.declaringType.getDeclaration();
        if (type != null) {
            return type.getField(this.getSimpleName());
        }
        return null;
    }

    @Override
    public CtField<T> getFieldDeclaration() {
        if (this.declaringType == null) {
            return null;
        }
        CtType<?> type = this.declaringType.getTypeDeclaration();
        if (type != null) {
            CtField<?> ctField = type.getField(this.getSimpleName());
            if (ctField == null && type instanceof CtEnum) {
                return ((CtEnum)type).getEnumValue(this.getSimpleName());
            }
            return ctField;
        }
        return null;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getQualifiedName() {
        return this.getDeclaringType().getQualifiedName() + "#" + this.getSimpleName();
    }

    @Override
    public boolean isFinal() {
        return this.fina;
    }

    @Override
    public boolean isStatic() {
        return this.stat;
    }

    @Override
    public <C extends CtFieldReference<T>> C setDeclaringType(CtTypeReference<?> declaringType) {
        if (declaringType != null) {
            declaringType.setParent(this);
        }
        this.declaringType = declaringType;
        return (C)this;
    }

    @Override
    public <C extends CtFieldReference<T>> C setFinal(boolean b) {
        this.fina = b;
        return (C)this;
    }

    @Override
    public <C extends CtFieldReference<T>> C setStatic(boolean stat) {
        this.stat = stat;
        return (C)this;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtVariable v = this.getDeclaration();
        if (v != null) {
            return v.getModifiers();
        }
        Member m = this.getActualField();
        if (m != null) {
            return RtHelper.getModifiers(m.getModifiers());
        }
        return Collections.emptySet();
    }

    @Override
    public CtFieldReference<T> clone() {
        return (CtFieldReference)super.clone();
    }
}

