/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import spoon.Launcher;
import spoon.OutputType;
import spoon.SpoonException;
import spoon.SpoonModelBuilder;
import spoon.compiler.Environment;
import spoon.compiler.ModelBuildingException;
import spoon.compiler.SpoonCompiler;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResource;
import spoon.compiler.SpoonResourceHelper;
import spoon.compiler.builder.AdvancedOptions;
import spoon.compiler.builder.AnnotationProcessingOptions;
import spoon.compiler.builder.ClasspathOptions;
import spoon.compiler.builder.ComplianceOptions;
import spoon.compiler.builder.JDTBuilder;
import spoon.compiler.builder.JDTBuilderImpl;
import spoon.compiler.builder.SourceOptions;
import spoon.processing.Processor;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.visitor.AstParentConsistencyChecker;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.QueueProcessingManager;
import spoon.support.compiler.VirtualFolder;
import spoon.support.compiler.jdt.CompilationUnitFilter;
import spoon.support.compiler.jdt.FileCompilerConfig;
import spoon.support.compiler.jdt.JDTBatchCompiler;
import spoon.support.compiler.jdt.JDTCommentBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.TreeBuilderRequestor;

public class JDTBasedSpoonCompiler
implements SpoonCompiler {
    protected INameEnvironment environment = null;
    protected final List<CategorizedProblem> probs = new ArrayList<CategorizedProblem>();
    protected final TreeBuilderRequestor requestor = new TreeBuilderRequestor(this);
    protected Factory factory;
    protected int javaCompliance = 7;
    protected boolean build = false;
    protected SpoonFolder sources = new VirtualFolder();
    protected SpoonFolder templates = new VirtualFolder();
    protected String[] templateClasspath = new String[0];
    protected boolean buildOnlyOutdatedFiles = false;
    protected File outputDirectory = new File("spooned");
    protected List<SpoonResource> forceBuildList = new ArrayList<SpoonResource>();
    protected String encoding;
    protected List<CompilationUnitFilter> compilationUnitFilters = new ArrayList<CompilationUnitFilter>();
    private static final CompilationUnitDeclaration[] EMPTY_RESULT = new CompilationUnitDeclaration[0];

    public JDTBasedSpoonCompiler(Factory factory) {
        this.factory = factory;
    }

    @Override
    public boolean build() {
        return this.build(null);
    }

    @Override
    public boolean build(JDTBuilder builder) {
        if (this.factory == null) {
            throw new SpoonException("Factory not initialized");
        }
        if (this.build) {
            throw new SpoonException("Model already built");
        }
        this.build = true;
        this.factory.getEnvironment().debugMessage("building sources: " + this.sources.getAllJavaFiles());
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        boolean srcSuccess = this.buildSources(builder);
        this.reportProblems(this.factory.getEnvironment());
        this.factory.getEnvironment().debugMessage("built in " + (System.currentTimeMillis() - t) + " ms");
        this.factory.getEnvironment().debugMessage("building templates: " + this.templates.getAllJavaFiles());
        t = System.currentTimeMillis();
        boolean templateSuccess = this.buildTemplates(builder);
        this.factory.getEnvironment().debugMessage("built in " + (System.currentTimeMillis() - t) + " ms");
        this.checkModel();
        return srcSuccess && templateSuccess;
    }

    private void checkModel() {
        if (!this.factory.getEnvironment().checksAreSkipped()) {
            this.factory.getModel().getRootPackage().accept(new AstParentConsistencyChecker());
        }
    }

    @Override
    public boolean compile(SpoonModelBuilder.InputType ... types) {
        this.factory.getEnvironment().debugMessage("compiling sources: " + this.factory.CompilationUnit().getMap().keySet());
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        JDTBatchCompiler batchCompiler = this.createBatchCompiler(types);
        Object[] args = new JDTBuilderImpl().classpathOptions((ClasspathOptions<?>)((ClasspathOptions)((ClasspathOptions)new ClasspathOptions().encoding(this.encoding)).classpath(this.getSourceClasspath())).binaries(this.getBinaryOutputDirectory())).complianceOptions((ComplianceOptions<?>)new ComplianceOptions().compliance(this.javaCompliance)).annotationProcessingOptions((AnnotationProcessingOptions<?>)new AnnotationProcessingOptions().compileProcessors()).advancedOptions((AdvancedOptions<?>)((AdvancedOptions)((AdvancedOptions)new AdvancedOptions().preserveUnusedVars()).continueExecution()).enableJavadoc()).sources((SourceOptions<?>)new SourceOptions().sources(new String[0])).build();
        this.getFactory().getEnvironment().debugMessage("compile args: " + Arrays.toString(args));
        System.setProperty("jdt.compiler.useSingleThread", "true");
        batchCompiler.compile((String[])args);
        this.reportProblems(this.factory.getEnvironment());
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        return this.probs.size() == 0;
    }

    @Override
    public void instantiateAndProcess(List<String> processors) {
        QueueProcessingManager processing = new QueueProcessingManager(this.factory);
        for (String processorName : processors) {
            processing.addProcessor(processorName);
            this.factory.getEnvironment().debugMessage("Loaded processor " + processorName + ".");
        }
        processing.process(this.factory.Package().getRootPackage());
    }

    @Override
    public void process(Collection<Processor<? extends CtElement>> processors) {
        QueueProcessingManager processing = new QueueProcessingManager(this.factory);
        for (Processor<? extends CtElement> processorName : processors) {
            processing.addProcessor(processorName);
            this.factory.getEnvironment().debugMessage("Loaded processor " + processorName + ".");
        }
        processing.process(this.factory.Package().getRootPackage());
    }

    @Override
    public void generateProcessedSourceFiles(OutputType outputType) {
        this.generateProcessedSourceFiles(outputType, null);
    }

    @Override
    public void generateProcessedSourceFiles(OutputType outputType, Filter<CtType<?>> typeFilter) {
        switch (outputType) {
            case CLASSES: {
                this.generateProcessedSourceFilesUsingTypes(typeFilter);
                break;
            }
            case COMPILATION_UNITS: {
                this.generateProcessedSourceFilesUsingCUs();
                break;
            }
        }
    }

    @Override
    public void addInputSource(File source) {
        try {
            if (SpoonResourceHelper.isFile(source)) {
                this.sources.addFile(SpoonResourceHelper.createFile(source));
            } else {
                this.sources.addFolder(SpoonResourceHelper.createFolder(source));
            }
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public void addInputSource(SpoonResource source) {
        if (source.isFile()) {
            this.sources.addFile((SpoonFile)source);
        } else {
            this.sources.addFolder((SpoonFolder)source);
        }
    }

    @Override
    public void addInputSources(List<SpoonResource> resources) {
        for (SpoonResource r : resources) {
            this.addInputSource(r);
        }
    }

    @Override
    public Set<File> getInputSources() {
        HashSet<File> files = new HashSet<File>();
        for (SpoonFolder file : this.getSource().getSubFolders()) {
            files.add(new File(file.getPath()));
        }
        return files;
    }

    @Override
    public void addTemplateSource(SpoonResource source) {
        if (source.isFile()) {
            this.templates.addFile((SpoonFile)source);
        } else {
            this.templates.addFolder((SpoonFolder)source);
        }
    }

    @Override
    public void addTemplateSource(File source) {
        try {
            if (SpoonResourceHelper.isFile(source)) {
                this.templates.addFile(SpoonResourceHelper.createFile(source));
            } else {
                this.templates.addFolder(SpoonResourceHelper.createFolder(source));
            }
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public void addTemplateSources(List<SpoonResource> resources) {
        for (SpoonResource r : resources) {
            this.addTemplateSource(r);
        }
    }

    @Override
    public Set<File> getTemplateSources() {
        HashSet<File> files = new HashSet<File>();
        for (SpoonFolder file : this.getTemplates().getSubFolders()) {
            files.add(new File(file.getPath()));
        }
        return files;
    }

    @Override
    public void setSourceOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public File getSourceOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setBinaryOutputDirectory(File binaryOutputDirectory) {
        this.getEnvironment().setBinaryOutputDirectory(binaryOutputDirectory.getAbsolutePath());
    }

    @Override
    public File getBinaryOutputDirectory() {
        return new File(this.getEnvironment().getBinaryOutputDirectory());
    }

    @Override
    public String[] getSourceClasspath() {
        return this.getEnvironment().getSourceClasspath();
    }

    @Override
    public void setSourceClasspath(String ... classpath) {
        this.getEnvironment().setSourceClasspath(classpath);
    }

    @Override
    public String[] getTemplateClasspath() {
        return this.templateClasspath;
    }

    @Override
    public void setTemplateClasspath(String ... classpath) {
        this.templateClasspath = classpath;
    }

    @Override
    public void setBuildOnlyOutdatedFiles(boolean buildOnlyOutdatedFiles) {
        this.buildOnlyOutdatedFiles = buildOnlyOutdatedFiles;
    }

    @Override
    public void forceBuild(SpoonResource source) {
        this.forceBuildList.add(source);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    protected boolean buildSources(JDTBuilder jdtBuilder) {
        return this.buildUnitsAndModel(jdtBuilder, this.sources, this.getSourceClasspath(), "", this.buildOnlyOutdatedFiles);
    }

    protected JDTBatchCompiler createBatchCompiler() {
        return new JDTBatchCompiler(this);
    }

    protected JDTBatchCompiler createBatchCompiler(SpoonModelBuilder.InputType ... types) {
        JDTBatchCompiler batchCompiler = this.createBatchCompiler();
        if (types.length == 0) {
            types = new SpoonModelBuilder.InputType[]{SpoonModelBuilder.InputType.CTTYPES};
        }
        for (SpoonModelBuilder.InputType inputType : types) {
            inputType.initializeCompiler(batchCompiler);
        }
        return batchCompiler;
    }

    protected boolean buildTemplates(JDTBuilder jdtBuilder) {
        return this.buildUnitsAndModel(jdtBuilder, this.templates, this.getTemplateClasspath(), "template ", false);
    }

    protected boolean buildUnitsAndModel(JDTBuilder jdtBuilder, SpoonFolder sourcesFolder, String[] classpath, String debugMessagePrefix, boolean buildOnlyOutdatedFiles) {
        CompilationUnitDeclaration[] units = this.buildUnits(jdtBuilder, sourcesFolder, classpath, debugMessagePrefix, buildOnlyOutdatedFiles);
        this.buildModel(units);
        return this.probs.size() == 0;
    }

    protected CompilationUnitDeclaration[] buildUnits(JDTBuilder jdtBuilder, SpoonFolder sourcesFolder, String[] classpath, String debugMessagePrefix, boolean buildOnlyOutdatedFiles) {
        List<SpoonFile> sourceFiles = sourcesFolder.getAllJavaFiles();
        if (sourceFiles.isEmpty()) {
            return EMPTY_RESULT;
        }
        JDTBatchCompiler batchCompiler = this.createBatchCompiler(new FileCompilerConfig(sourcesFolder));
        Object[] args = jdtBuilder == null ? new JDTBuilderImpl().classpathOptions((ClasspathOptions<?>)((ClasspathOptions)new ClasspathOptions().encoding(this.encoding)).classpath(classpath)).complianceOptions((ComplianceOptions<?>)new ComplianceOptions().compliance(this.javaCompliance)).advancedOptions((AdvancedOptions<?>)((AdvancedOptions)((AdvancedOptions)new AdvancedOptions().preserveUnusedVars()).continueExecution()).enableJavadoc()).sources((SourceOptions<?>)new SourceOptions().sources(new String[0])).build() : jdtBuilder.build();
        this.getFactory().getEnvironment().debugMessage(debugMessagePrefix + "build args: " + Arrays.toString(args));
        batchCompiler.configure((String[])args);
        if (buildOnlyOutdatedFiles && this.outputDirectory.exists()) {
            Collection outputFiles = FileUtils.listFiles((File)this.outputDirectory, (String[])new String[]{"java"}, (boolean)true);
            this.keepOutdatedFiles(sourceFiles, outputFiles);
        }
        CompilationUnitDeclaration[] units = batchCompiler.getUnits();
        return units;
    }

    protected void buildModel(CompilationUnitDeclaration[] units) {
        JDTTreeBuilder builder = new JDTTreeBuilder(this.factory);
        block0: for (CompilationUnitDeclaration unit : units) {
            String unitPath = new String(unit.getFileName());
            for (CompilationUnitFilter cuf : this.compilationUnitFilters) {
                if (!cuf.exclude(unitPath)) continue;
                continue block0;
            }
            unit.traverse((ASTVisitor)builder, unit.scope);
            if (!this.getFactory().getEnvironment().isCommentsEnabled()) continue;
            new JDTCommentBuilder(unit, this.factory).build();
        }
    }

    protected void generateProcessedSourceFilesUsingTypes(Filter<CtType<?>> typeFilter) {
        if (this.factory.getEnvironment().getDefaultFileGenerator() != null) {
            this.factory.getEnvironment().debugMessage("Generating source using types...");
            QueueProcessingManager processing = new QueueProcessingManager(this.factory);
            processing.addProcessor(this.factory.getEnvironment().getDefaultFileGenerator());
            if (typeFilter != null) {
                processing.process(Query.getElements(this.factory.Package().getRootPackage(), typeFilter));
            } else {
                processing.process(this.factory.Package().getRootPackage());
            }
        }
    }

    protected void generateProcessedSourceFilesUsingCUs() {
        this.factory.getEnvironment().debugMessage("Generating source using compilation units...");
        if (this.outputDirectory == null) {
            throw new RuntimeException("You should set output directory before generating source files");
        }
        if (this.outputDirectory.isFile()) {
            throw new RuntimeException("Output must be a directory");
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new RuntimeException("Error creating output directory");
        }
        try {
            this.outputDirectory = this.outputDirectory.getCanonicalFile();
        }
        catch (IOException e1) {
            throw new SpoonException(e1);
        }
        this.factory.getEnvironment().debugMessage("Generating source files to: " + this.outputDirectory);
        ArrayList<File> printedFiles = new ArrayList<File>();
        for (CompilationUnit cu : this.factory.CompilationUnit().getMap().values()) {
            this.factory.getEnvironment().debugMessage("Generating source for compilation unit: " + cu.getFile());
            CtType<?> element = cu.getMainType();
            CtPackage pack = element.getPackage();
            File packageDir = pack.isUnnamedPackage() ? new File(this.outputDirectory.getAbsolutePath()) : new File(this.outputDirectory.getAbsolutePath() + File.separatorChar + pack.getQualifiedName().replace('.', File.separatorChar));
            if (!packageDir.exists() && !packageDir.mkdirs()) {
                throw new RuntimeException("Error creating output directory");
            }
            try {
                File file = new File(packageDir.getAbsolutePath() + File.separatorChar + element.getSimpleName() + ".java");
                file.createNewFile();
                InputStream is = this.getCompilationUnitInputStream(cu.getFile().getPath());
                IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(file));
                if (printedFiles.contains(file)) continue;
                printedFiles.add(file);
            }
            catch (Exception e) {
                Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void keepOutdatedFiles(List<SpoonFile> files, Collection<File> outputFiles) {
        int offset = this.outputDirectory.getAbsolutePath().length() + 1;
        ArrayList<String> relativeOutputPaths = new ArrayList<String>();
        for (File f : outputFiles) {
            relativeOutputPaths.add(f.getAbsolutePath().substring(offset));
        }
        for (SpoonFile sf : new ArrayList<SpoonFile>(files)) {
            if (this.forceBuildList.contains(sf)) continue;
            File f = sf.toFile();
            for (String s : relativeOutputPaths) {
                if (!f.getAbsolutePath().endsWith(s) || f.lastModified() > new File(this.outputDirectory, s).lastModified()) continue;
                files.remove(sf);
            }
        }
    }

    public void setEnvironment(INameEnvironment environment) {
        this.environment = environment;
    }

    public void reportProblem(CategorizedProblem pb) {
        if (pb == null) {
            return;
        }
        if (pb.getID() == 16777539) {
            throw new ModelBuildingException(pb.getMessage());
        }
        this.probs.add(pb);
    }

    public void reportProblems(Environment environment) {
        if (this.getProblems().size() > 0) {
            for (CategorizedProblem problem : this.getProblems()) {
                if (problem == null) continue;
                this.report(environment, problem);
            }
        }
    }

    protected void report(Environment environment, CategorizedProblem problem) {
        if (problem == null) {
            throw new IllegalArgumentException("problem cannot be null");
        }
        File file = new File(new String(problem.getOriginatingFileName()));
        String filename = file.getAbsolutePath();
        String message = problem.getMessage() + " at " + filename + ":" + problem.getSourceLineNumber();
        if (problem.isError()) {
            if (!environment.getNoClasspath()) {
                throw new ModelBuildingException(message);
            }
            int problemId = problem.getID();
            if (problemId != 0x1000002 && problemId != 0x22000032 && problemId != 268435846) {
                environment.report(null, Level.WARN, message);
            }
        }
    }

    public List<CategorizedProblem> getProblems() {
        return Collections.unmodifiableList(this.probs);
    }

    public SpoonFolder getSource() {
        return this.sources;
    }

    public SpoonFolder getTemplates() {
        return this.templates;
    }

    protected InputStream getCompilationUnitInputStream(String path) {
        Environment env = this.factory.getEnvironment();
        CompilationUnit cu = this.factory.CompilationUnit().getMap().get(path);
        List<CtType<?>> toBePrinted = cu.getDeclaredTypes();
        DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(env);
        printer.calculate(cu, toBePrinted);
        return new ByteArrayInputStream(printer.getResult().toString().getBytes());
    }

    protected Environment getEnvironment() {
        return this.getFactory().getEnvironment();
    }

    @Override
    public boolean compileInputSources() {
        return this.compile(SpoonModelBuilder.InputType.FILES);
    }

    @Override
    public void addCompilationUnitFilter(CompilationUnitFilter filter) {
        this.compilationUnitFilters.add(filter);
    }

    @Override
    public void removeCompilationUnitFilter(CompilationUnitFilter filter) {
        this.compilationUnitFilters.remove(filter);
    }

    @Override
    public List<CompilationUnitFilter> getCompilationUnitFilter() {
        return new ArrayList<CompilationUnitFilter>(this.compilationUnitFilters);
    }
}

