/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.support.compiler.ZipFolder;

public class ZipFile
implements SpoonFile {
    byte[] buffer;
    String name;
    ZipFolder parent;

    public ZipFile(ZipFolder parent, String name, byte[] buffer) {
        this.buffer = buffer;
        this.name = name;
        this.parent = parent;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.buffer);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SpoonFolder getParent() {
        return this.parent;
    }

    @Override
    public File getFileSystemParent() {
        return this.getParent().getFileSystemParent();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isJava() {
        return this.getName().endsWith(".java");
    }

    @Override
    public String getPath() {
        return this.toString();
    }

    public String toString() {
        return this.parent + "!" + this.getName();
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public File toFile() {
        return null;
    }

    @Override
    public boolean isActualFile() {
        return false;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

