/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import spoon.compiler.ModelBuildingException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.compiler.SnippetCompilationError;
import spoon.support.compiler.jdt.JDTSnippetCompiler;
import spoon.support.reflect.declaration.CtElementImpl;

public class SnippetCompilationHelper {
    private static final String WRAPPER_CLASS_NAME = "Wrapper";
    private static final String WRAPPER_METHOD_NAME = "wrap";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compileAndReplaceSnippetsIn(CtType<?> c) {
        Factory f = c.getFactory();
        CtType<?> workCopy = c;
        EnumSet<ModifierKind> backup = EnumSet.noneOf(ModifierKind.class);
        backup.addAll(workCopy.getModifiers());
        workCopy.removeModifier(ModifierKind.PUBLIC);
        try {
            SnippetCompilationHelper.build(f, workCopy.toString());
        }
        finally {
            c.setModifiers(backup);
        }
    }

    public static CtStatement compileStatement(CtCodeSnippetStatement st) throws SnippetCompilationError {
        return SnippetCompilationHelper.internalCompileStatement(st, st.getFactory().Type().VOID_PRIMITIVE);
    }

    public static CtStatement compileStatement(CtCodeSnippetStatement st, CtTypeReference returnType) throws SnippetCompilationError {
        return SnippetCompilationHelper.internalCompileStatement(st, returnType);
    }

    private static CtStatement internalCompileStatement(CtElement st, CtTypeReference returnType) {
        Factory f = st.getFactory();
        String contents = SnippetCompilationHelper.createWrapperContent(st, f, returnType);
        SnippetCompilationHelper.build(f, contents);
        CtType c = f.Type().get(WRAPPER_CLASS_NAME);
        CtMethod wrapper = c.getMethod(WRAPPER_METHOD_NAME, new CtTypeReference[0]);
        List<CtStatement> statements = wrapper.getBody().getStatements();
        CtStatement ret = statements.get(statements.size() - 1);
        c.getPackage().getTypes().remove(c);
        if (ret instanceof CtClass) {
            CtClass klass = (CtClass)ret;
            klass.setSimpleName(klass.getSimpleName().replaceAll("^[0-9]*", ""));
            klass.setParent(ret.getFactory().Package().getRootPackage());
            ret.getFactory().Package().getRootPackage().addType(klass);
        }
        return ret;
    }

    public static <T> CtExpression<T> compileExpression(CtCodeSnippetExpression<T> expr) throws SnippetCompilationError {
        CtReturn ret = (CtReturn)SnippetCompilationHelper.internalCompileStatement(expr, expr.getFactory().Type().OBJECT);
        return ret.getReturnedExpression();
    }

    private static void build(Factory f, String contents) {
        JDTSnippetCompiler builder = new JDTSnippetCompiler(f, contents);
        try {
            builder.build();
        }
        catch (Exception e) {
            throw new ModelBuildingException("snippet compilation error while compiling: " + contents, e);
        }
    }

    private static String createWrapperContent(CtElement element, Factory f, CtTypeReference returnType) {
        CtClass w = f.Class().create(WRAPPER_CLASS_NAME);
        CtBlock body = f.Core().createBlock();
        if (element instanceof CtStatement) {
            body.addStatement((CtStatement)element);
        } else if (element instanceof CtExpression) {
            CtReturn ret = f.Core().createReturn();
            ret.setReturnedExpression((CtExpression)element);
            body.addStatement(ret);
        }
        EnumSet<ModifierKind> modifiers = EnumSet.of(ModifierKind.STATIC);
        HashSet<CtTypeReference<? extends Throwable>> thrownTypes = new HashSet<CtTypeReference<? extends Throwable>>();
        thrownTypes.add(f.Class().get((Class)Throwable.class).getReference());
        f.Method().create(w, modifiers, returnType, WRAPPER_METHOD_NAME, CtElementImpl.emptyList(), thrownTypes, body);
        String contents = w.toString();
        w.getPackage().getTypes().remove(w);
        return contents;
    }
}

