/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.compiler.InvalidClassPathException;
import spoon.compiler.SpoonFile;
import spoon.processing.FileGenerator;
import spoon.processing.ProblemFixer;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.processing.ProcessorProperties;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.support.compiler.FileSystemFolder;

public class StandardEnvironment
implements Serializable,
Environment {
    private static final long serialVersionUID = 1L;
    private FileGenerator<? extends CtElement> defaultFileGenerator;
    private int errorCount = 0;
    private transient Factory factory;
    ProcessingManager manager;
    private boolean processingStopped = false;
    private boolean autoImports = false;
    private int warningCount = 0;
    private String[] sourceClasspath = null;
    private boolean preserveLineNumbers = false;
    private boolean copyResources = true;
    private boolean enableComments = false;
    private Logger logger = Launcher.LOGGER;
    private Level level = Level.OFF;
    private boolean shouldCompile = false;
    private boolean skipSelfChecks;
    Map<String, ProcessorProperties> processorProperties = new TreeMap<String, ProcessorProperties>();
    int complianceLevel = 7;
    boolean useTabulations = false;
    int tabulationSize = 4;
    private ClassLoader classloader;
    private ClassLoader inputClassloader;
    private boolean noclasspath = false;
    private String binaryOutputDirectory = "spooned-classes";

    @Override
    public void debugMessage(String message) {
        this.logger.debug((Object)message);
    }

    @Override
    public boolean isAutoImports() {
        return this.autoImports;
    }

    @Override
    public void setAutoImports(boolean autoImports) {
        this.autoImports = autoImports;
    }

    @Override
    public FileGenerator<? extends CtElement> getDefaultFileGenerator() {
        return this.defaultFileGenerator;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(String level) {
        this.level = this.toLevel(level);
        this.logger.setLevel(this.level);
    }

    @Override
    public boolean shouldCompile() {
        return this.shouldCompile;
    }

    @Override
    public void setShouldCompile(boolean shouldCompile) {
        this.shouldCompile = shouldCompile;
    }

    @Override
    public boolean checksAreSkipped() {
        return this.skipSelfChecks;
    }

    @Override
    public void setSelfChecks(boolean skip) {
        this.skipSelfChecks = skip;
    }

    private Level toLevel(String level) {
        if (level == null || level.isEmpty()) {
            throw new SpoonException("Wrong level given at Spoon.");
        }
        return Level.toLevel((String)level, (Level)Level.ALL);
    }

    @Override
    public ProcessingManager getManager() {
        return this.manager;
    }

    @Override
    public ProcessorProperties getProcessorProperties(String processorName) throws Exception {
        if (this.processorProperties.containsKey(processorName)) {
            return this.processorProperties.get(processorName);
        }
        return null;
    }

    @Override
    public boolean isProcessingStopped() {
        return this.processingStopped;
    }

    private void prefix(StringBuffer buffer, Level level) {
        if (level == Level.ERROR) {
            buffer.append("error: ");
            ++this.errorCount;
        } else if (level == Level.WARN) {
            buffer.append("warning: ");
            ++this.warningCount;
        }
    }

    @Override
    public void report(Processor<?> processor, Level level, CtElement element, String message) {
        StringBuffer buffer = new StringBuffer();
        this.prefix(buffer, level);
        buffer.append(message);
        try {
            CtType type = element instanceof CtType ? (CtType)element : element.getParent(CtType.class);
            SourcePosition sp = element.getPosition();
            if (sp == null) {
                buffer.append(" (Unknown Source)");
            } else {
                CtExecutable exe;
                buffer.append(" at " + type.getQualifiedName() + ".");
                CtExecutable ctExecutable = exe = element instanceof CtExecutable ? (CtExecutable)element : element.getParent(CtExecutable.class);
                if (exe != null) {
                    buffer.append(exe.getSimpleName());
                }
                buffer.append("(" + sp.getFile().getName() + ":" + sp.getLine() + ")");
            }
        }
        catch (ParentNotInitializedException e) {
            buffer.append(" (invalid parent)");
        }
        this.print(buffer.toString(), level);
    }

    @Override
    public void report(Processor<?> processor, Level level, CtElement element, String message, ProblemFixer<?> ... fixes) {
        this.report(processor, level, element, message);
    }

    @Override
    public void report(Processor<?> processor, Level level, String message) {
        StringBuffer buffer = new StringBuffer();
        this.prefix(buffer, level);
        buffer.append(message);
        this.print(buffer.toString(), level);
    }

    private void print(String message, Level level) {
        if (level.equals((Object)Level.ERROR)) {
            this.logger.error((Object)message);
        } else if (level.equals((Object)Level.WARN)) {
            this.logger.warn((Object)message);
        } else if (level.equals((Object)Level.DEBUG)) {
            this.logger.debug((Object)message);
        } else if (level.equals((Object)Level.INFO)) {
            this.logger.info((Object)message);
        }
    }

    @Override
    public void reportEnd() {
        this.logger.info((Object)"end of processing: ");
        if (this.warningCount > 0) {
            this.logger.info((Object)(this.warningCount + " warning"));
            if (this.warningCount > 1) {
                this.logger.info((Object)"s");
            }
            if (this.errorCount > 0) {
                this.logger.info((Object)", ");
            }
        }
        if (this.errorCount > 0) {
            this.logger.info((Object)(this.errorCount + " error"));
            if (this.errorCount > 1) {
                this.logger.info((Object)"s");
            }
        }
        if (this.errorCount + this.warningCount > 0) {
            this.logger.info((Object)"\n");
        } else {
            this.logger.info((Object)"no errors, no warnings");
        }
    }

    @Override
    public void reportProgressMessage(String message) {
        this.logger.info((Object)message);
    }

    public void setDebug(boolean debug) {
    }

    @Override
    public void setDefaultFileGenerator(FileGenerator<? extends CtElement> defaultFileGenerator) {
        this.defaultFileGenerator = defaultFileGenerator;
        defaultFileGenerator.setFactory(this.getFactory());
    }

    @Override
    public void setManager(ProcessingManager manager) {
        this.manager = manager;
    }

    @Override
    public void setProcessingStopped(boolean processingStopped) {
        this.processingStopped = processingStopped;
    }

    public void setVerbose(boolean verbose) {
    }

    @Override
    public int getComplianceLevel() {
        return this.complianceLevel;
    }

    @Override
    public void setComplianceLevel(int level) {
        this.complianceLevel = level;
    }

    @Override
    public void setProcessorProperties(String processorName, ProcessorProperties prop) {
        this.processorProperties.put(processorName, prop);
    }

    @Override
    public boolean isUsingTabulations() {
        return this.useTabulations;
    }

    @Override
    public void useTabulations(boolean tabulation) {
        this.useTabulations = tabulation;
    }

    @Override
    public int getTabulationSize() {
        return this.tabulationSize;
    }

    @Override
    public void setTabulationSize(int tabulationSize) {
        this.tabulationSize = tabulationSize;
    }

    @Override
    public void setInputClassLoader(ClassLoader aClassLoader) {
        if (aClassLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)aClassLoader).getURLs();
            if (urls != null && urls.length > 0) {
                ArrayList<String> classpath = new ArrayList<String>();
                for (URL url : urls) {
                    classpath.add(url.toString());
                }
                this.setSourceClasspath(classpath.toArray(new String[0]));
            }
            return;
        }
        this.classloader = aClassLoader;
    }

    @Override
    public ClassLoader getInputClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        if (this.inputClassloader == null) {
            this.inputClassloader = new URLClassLoader(this.urlClasspath(), Thread.currentThread().getContextClassLoader());
        }
        return this.inputClassloader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getInputClassLoader();
    }

    public URL[] urlClasspath() {
        String[] classpath = this.getSourceClasspath();
        int length = classpath == null ? 0 : classpath.length;
        URL[] urls = new URL[length];
        for (int i = 0; i < length; ++i) {
            try {
                urls[i] = new File(classpath[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Invalid classpath: " + classpath, e);
            }
        }
        return urls;
    }

    @Override
    public String[] getSourceClasspath() {
        return this.sourceClasspath;
    }

    @Override
    public void setSourceClasspath(String[] sourceClasspath) {
        this.verifySourceClasspath(sourceClasspath);
        this.sourceClasspath = sourceClasspath;
        this.inputClassloader = null;
    }

    private void verifySourceClasspath(String[] sourceClasspath) throws InvalidClassPathException {
        for (String classPathElem : sourceClasspath) {
            FileSystemFolder tmp;
            List<SpoonFile> javaFiles;
            File classOrJarFolder = new File(classPathElem);
            if (!classOrJarFolder.exists()) {
                throw new InvalidClassPathException(classPathElem + " does not exist, it is not a valid folder");
            }
            if (!classOrJarFolder.isDirectory() || (javaFiles = (tmp = new FileSystemFolder(classOrJarFolder)).getAllJavaFiles()).size() <= 0) continue;
            this.logger.warn((Object)("You're trying to give source code in the classpath, this should be given to addInputSource " + javaFiles));
        }
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public boolean isPreserveLineNumbers() {
        return this.preserveLineNumbers;
    }

    @Override
    public void setPreserveLineNumbers(boolean preserveLineNumbers) {
        this.preserveLineNumbers = preserveLineNumbers;
    }

    @Override
    public void setNoClasspath(boolean option) {
        this.noclasspath = option;
    }

    @Override
    public boolean getNoClasspath() {
        return this.noclasspath;
    }

    @Override
    public boolean isCopyResources() {
        return this.copyResources;
    }

    @Override
    public void setCopyResources(boolean copyResources) {
        this.copyResources = copyResources;
    }

    @Override
    public boolean isCommentsEnabled() {
        return this.enableComments;
    }

    @Override
    public void setCommentEnabled(boolean commentEnabled) {
        this.enableComments = commentEnabled;
    }

    @Override
    public void setBinaryOutputDirectory(String s) {
        this.binaryOutputDirectory = s;
    }

    @Override
    public String getBinaryOutputDirectory() {
        return this.binaryOutputDirectory;
    }
}

